/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.cert.CertFrRequestFiller;
import com.netscape.cms.servlet.common.CAServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caGetCertFromRequest", urlPatterns={"/ee/ca/getCertFromRequest", "/eeca/ca/getCertFromRequest"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="successTemplate", value="/ee/ca/ImportCert.template"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="ID", value="caGetCertFromRequest"), @WebInitParam(name="resourceID", value="certServer.ee.certificate"), @WebInitParam(name="importCert", value="true")})
public class GetCertFromRequest
extends CAServlet {
    public static Logger logger = LoggerFactory.getLogger(GetCertFromRequest.class);
    private static final long serialVersionUID = 5310646832256611066L;
    private static final String PROP_IMPORT = "importCert";
    protected static final String GET_CERT_FROM_REQUEST_TEMPLATE = "ImportCert.template";
    protected static final String DISPLAY_CERT_FROM_REQUEST_TEMPLATE = "displayCertFromRequest.template";
    protected static final String REQUEST_ID = "requestId";
    protected static final String CERT_TYPE = "certtype";
    protected String mCertFrReqSuccessTemplate = null;
    protected ICMSTemplateFiller mCertFrReqFiller = null;
    protected RequestQueue mQueue;
    protected boolean mImportCert = true;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CAEngine engine = CAEngine.getInstance();
        this.mQueue = engine.getRequestQueue();
        try {
            String fillername;
            String tmp = sc.getInitParameter(PROP_IMPORT);
            if (tmp != null && tmp.trim().equalsIgnoreCase("false")) {
                this.mImportCert = false;
            }
            Object defTemplate = null;
            defTemplate = this.mImportCert ? GET_CERT_FROM_REQUEST_TEMPLATE : DISPLAY_CERT_FROM_REQUEST_TEMPLATE;
            defTemplate = "/ca/" + (String)defTemplate;
            this.mCertFrReqSuccessTemplate = sc.getInitParameter("successTemplate");
            if (this.mCertFrReqSuccessTemplate == null) {
                this.mCertFrReqSuccessTemplate = defTemplate;
            }
            if ((fillername = sc.getInitParameter("successTemplateFiller")) != null) {
                ICMSTemplateFiller filler = this.newFillerObject(fillername);
                if (filler != null) {
                    this.mCertFrReqFiller = filler;
                }
            } else {
                this.mCertFrReqFiller = new CertFrRequestFiller();
            }
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_IMP_INIT_SERV_ERR", (Object[])new Object[]{e.toString(), this.mId}), (Throwable)e);
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        String group;
        ArgBlock httpParams = cmsReq.getHttpParams();
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String requestId = httpParams.getValueAsString(REQUEST_ID, null);
        if (requestId == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_NO_REQUEST_ID_PROVIDED", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_REQUEST_ID_PROVIDED", (String[])new String[0]));
        }
        try {
            new BigInteger(requestId);
        }
        catch (NumberFormatException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_REQ_ID_FORMAT", (Object[])new Object[]{requestId}), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_BASE_INVALID_NUMBER_FORMAT_1", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)requestId)}), (Throwable)e);
        }
        Request r = this.requestRepository.readRequest(new RequestId(requestId));
        if (r == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_ID_NOT_FOUND", (Object[])new Object[]{requestId}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_ID_NOT_FOUND", (String[])new String[]{requestId}));
        }
        if (authToken != null && (group = authToken.getInString("group")) != null && group != "" && group.equals("Registration Manager Agents")) {
            boolean groupMatched = false;
            String reqOwner = r.getRequestOwner();
            if (reqOwner != null) {
                logger.debug("GetCertFromRequest process: req owner=" + reqOwner);
                if (reqOwner.equals(group)) {
                    groupMatched = true;
                }
            }
            if (!groupMatched) {
                logger.error("GetCertFromRequest: RA group unmatched");
                logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_ID_NOT_FOUND", (Object[])new Object[]{requestId}));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_ID_NOT_FOUND", (String[])new String[]{requestId}));
            }
        }
        if (!r.getRequestType().equals("enrollment") && !r.getRequestType().equals("renewal")) {
            logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_NOT_ENROLLMENT_1", (Object[])new Object[]{requestId}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_NOT_ENROLLMENT", (String[])new String[]{requestId}));
        }
        RequestStatus status = r.getRequestStatus();
        if (!status.equals((Object)RequestStatus.COMPLETE)) {
            logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_NOT_COMPLETED_1", (Object[])new Object[]{requestId}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_NOT_COMPLETED", (String[])new String[]{requestId}));
        }
        Integer result = r.getExtDataInInteger("Result");
        if (result != null && !result.equals(Request.RES_SUCCESS)) {
            logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_HAD_ERROR_1", (Object[])new Object[]{requestId}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_HAD_ERROR", (String[])new String[]{requestId}));
        }
        X509CertImpl[] o = r.getExtDataInCertArray("issuedCerts");
        if (r.getExtDataInString("profile") != null) {
            X509CertImpl cert = r.getExtDataInCert("req_issued_cert");
            X509CertImpl[] certs = new X509CertImpl[]{cert};
            o = certs;
        }
        if (o == null || !(o instanceof X509CertImpl[])) {
            logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_HAD_NO_CERTS_1", (Object[])new Object[]{requestId}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_HAD_NO_CERTS", (String[])new String[]{requestId}));
        }
        if (o instanceof X509CertImpl[]) {
            X509CertImpl[] certs = o;
            if (certs == null || certs.length == 0 || certs[0] == null) {
                logger.error(CMS.getLogMessage((String)"CMSGW_REQUEST_HAD_NO_CERTS_1", (Object[])new Object[]{requestId}));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_REQUEST_HAD_NO_CERTS", (String[])new String[]{requestId}));
            }
            cmsReq.setRequest(r);
            cmsReq.setStatus(CMSRequest.SUCCESS);
            if (this.mImportCert && this.checkImportCertToNav(cmsReq.getHttpResp(), httpParams, certs[0])) {
                return;
            }
            try {
                cmsReq.setResult((Object)certs);
                this.renderTemplate(cmsReq, this.mCertFrReqSuccessTemplate, this.mCertFrReqFiller);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGE_ERROR_DISPLAY_TEMPLATE_1", (Object[])new Object[]{this.mCertFrReqSuccessTemplate, e.toString()}), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
            }
        }
    }
}

