/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.cert.RevocationProcessor;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caDoRevoke", urlPatterns={"/ee/ca/doRevoke"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/ee/ca/revocationResult.template"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="ID", value="caDoRevoke"), @WebInitParam(name="resourceID", value="certServer.ee.certificates")})
public class DoRevoke
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(DoRevoke.class);
    private static final long serialVersionUID = 1693115906265904238L;
    private static final String TPL_FILE = "revocationResult.template";
    private CertificateRepository mCertDB;
    private String mFormPath = null;
    private CAPublisherProcessor mPublisherProcessor;
    private int mTimeLimits = 30;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mFormPath = "/ca/revocationResult.template";
        this.mCertDB = engine.getCertificateRepository();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
        try {
            this.mTimeLimits = Integer.parseInt(sc.getInitParameter("timeLimits"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        String revokeAll = null;
        int totalRecordCount = -1;
        int verifiedRecordCount = -1;
        EBaseException error = null;
        int reason = -1;
        boolean authorized = true;
        Date invalidityDate = null;
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        try {
            Object serialNumber;
            long l;
            if (req.getParameter("revocationReason") != null) {
                reason = Integer.parseInt(req.getParameter("revocationReason"));
            }
            if (req.getParameter("totalRecordCount") != null) {
                totalRecordCount = Integer.parseInt(req.getParameter("totalRecordCount"));
            }
            if (req.getParameter("verifiedRecordCount") != null) {
                verifiedRecordCount = Integer.parseInt(req.getParameter("verifiedRecordCount"));
            }
            if (req.getParameter("invalidityDate") != null && (l = Long.parseLong(req.getParameter("invalidityDate"))) > 0L) {
                invalidityDate = new Date(l);
            }
            revokeAll = req.getParameter("revokeAll");
            String comments = req.getParameter("csrRequestorComments");
            String eeSubjectDN = null;
            Object eeSerialNumber = null;
            Object initiative = null;
            String authMgr = "noAuthManager";
            authToken = this.authenticate(req);
            AuthzToken authzToken = null;
            try {
                authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "revoke");
            }
            catch (EAuthzAccessDenied e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                return;
            }
            if (this.mAuthMgr != null && this.mAuthMgr.equals("certUserDBAuthMgr")) {
                if (authToken != null) {
                    serialNumber = req.getParameter("serialNumber");
                    this.getSSLClientCertificate(req);
                    if (serialNumber != null) {
                        eeSerialNumber = serialNumber;
                    }
                    authMgr = authToken.getInString("authMgrInstName");
                    String agentID = authToken.getInString("userid");
                    initiative = "fromAgent agentID: " + agentID + " authenticated by " + authMgr;
                }
            } else {
                initiative = "fromUser";
                serialNumber = req.getParameter("serialNumber");
                X509CertImpl sslCert = (X509CertImpl)this.getSSLClientCertificate(req);
                if (serialNumber == null || sslCert == null || !((String)serialNumber).equals(sslCert.getSerialNumber().toString(16))) {
                    throw new ForbiddenException("Invalid serial number.");
                }
                eeSubjectDN = sslCert.getSubjectName().toString();
                eeSerialNumber = sslCert.getSerialNumber().toString();
            }
            serialNumber = this.parseSerialNumber((String)eeSerialNumber);
            this.process(argSet, header, reason, invalidityDate, (String)initiative, req, resp, verifiedRecordCount, revokeAll, totalRecordCount, (BigInteger)serialNumber, eeSubjectDN, comments, locale[0]);
        }
        catch (NumberFormatException e) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Throwable)e);
        }
        catch (ForbiddenException e) {
            authorized = false;
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null && authorized) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else if (!authorized) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_OUT_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, int reason, Date invalidityDate, String initiative, HttpServletRequest req, HttpServletResponse resp, int verifiedRecordCount, String revokeAll, int totalRecordCount, BigInteger eeSerialNumber, String eeSubjectDN, String comments, Locale locale) throws EBaseException {
        logger.debug("DoRevoke: eeSerialNumber: " + eeSerialNumber);
        long startTime = new Date().getTime();
        CAEngine engine = CAEngine.getInstance();
        RevocationProcessor processor = new RevocationProcessor(this.servletConfig.getServletName(), this.getLocale(req));
        processor.setCMSEngine(engine);
        processor.init();
        processor.setStartTime(startTime);
        processor.setInitiative(initiative);
        processor.setSerialNumber(eeSerialNumber == null ? null : new CertId(eeSerialNumber));
        RevocationReason revReason = RevocationReason.valueOf((int)reason);
        processor.setRevocationReason(revReason);
        processor.setRequestType(processor.getRevocationReason() == RevocationReason.CERTIFICATE_HOLD ? "on-hold" : "revoke");
        processor.setInvalidityDate(invalidityDate);
        processor.setComments(comments);
        Hashtable<BigInteger, Long> nonceMap = new Hashtable<BigInteger, Long>();
        X509Certificate clientCert = this.getSSLClientCertificate(req);
        processor.setAuthority(engine.getCA());
        if (engine.getEnableNonces()) {
            String nonces = req.getParameter("nonce");
            if (nonces == null) {
                throw new ForbiddenException("Missing nonce.");
            }
            for (String s : nonces.split(",")) {
                String[] elements = s.split(":");
                BigInteger serialNumber = new BigInteger(elements[0].trim());
                Long nonce = Long.valueOf(elements[1].trim());
                nonceMap.put(serialNumber, nonce);
            }
        }
        try {
            processor.createCRLExtension();
            Enumeration<CertRecord> e = this.mCertDB.searchCertificates(revokeAll, totalRecordCount, this.mTimeLimits);
            while (e != null && e.hasMoreElements()) {
                CertRecord targetRecord = e.nextElement();
                X509CertImpl targetCert = targetRecord.getCertificate();
                if (eeSerialNumber != null && eeSerialNumber.equals(targetCert.getSerialNumber()) && targetRecord.getStatus().equals("REVOKED")) {
                    String message = CMS.getLogMessage((String)"CA_CERTIFICATE_ALREADY_REVOKED_1", (Object[])new Object[]{targetRecord.getSerialNumber().toString(16)});
                    logger.error(message);
                    throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_UNAUTHORIZED", (Object[])new Object[0]));
                }
                ArgBlock rarg = new ArgBlock();
                rarg.addStringValue("serialNumber", targetCert.getSerialNumber().toString(16));
                try {
                    if (engine.getEnableNonces() && !processor.isMemberOfSubsystemGroup(clientCert)) {
                        Long nonce = (Long)nonceMap.get(targetRecord.getSerialNumber());
                        processor.validateNonce(req, "cert-revoke", targetRecord.getSerialNumber(), nonce);
                    }
                    processor.validateCertificateToRevoke(eeSubjectDN, targetRecord, false);
                    processor.addCertificateToRevoke(targetCert);
                    rarg.addStringValue("error", null);
                }
                catch (PKIException ex) {
                    rarg.addStringValue("error", ex.getMessage());
                }
                argSet.addRepeatRecord(rarg);
            }
            int count = processor.getCertificates().size();
            if (count == 0) {
                logger.warn("Unable to pre-process revocation request: certificate not found");
                throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_REVOCATION_ERROR_CERT_NOT_FOUND", (Object[])new Object[0]));
            }
            header.addIntegerValue("totalRecordCount", count);
            processor.createRevocationRequest();
            processor.auditChangeRequest("Success");
        }
        catch (ForbiddenException e) {
            logger.warn("Unable to pre-process revocation request: " + e.getMessage());
            throw new EAuthzException(CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHORIZATION_ERROR", (String[])new String[0]));
        }
        catch (EBaseException e) {
            logger.error("Unable to pre-process revocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequest("Failure");
            throw e;
        }
        catch (IOException e) {
            logger.error("Unable to pre-process revocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequest("Failure");
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[0]));
        }
        try {
            processor.processRevocationRequest();
            Request revReq = processor.getRequest();
            RequestStatus status = revReq.getRequestStatus();
            processor.setRequestStatus(status);
            String type = revReq.getRequestType();
            if (status == RequestStatus.COMPLETE || status == RequestStatus.SVC_PENDING && type.equals("cert4crl")) {
                header.addStringValue("revoked", "yes");
                Integer updateCRLResult = revReq.getExtDataInInteger("crlUpdateStatus");
                if (updateCRLResult != null) {
                    header.addStringValue("updateCRL", "yes");
                    if (updateCRLResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue("updateCRLSuccess", "yes");
                    } else {
                        header.addStringValue("updateCRLSuccess", "no");
                        String crlError = revReq.getExtDataInString("crlUpdateError");
                        if (crlError != null) {
                            header.addStringValue("updateCRLError", crlError);
                        }
                    }
                    Integer publishCRLResult = revReq.getExtDataInInteger("crlPublishStatus");
                    if (publishCRLResult != null) {
                        if (publishCRLResult.equals(Request.RES_SUCCESS)) {
                            header.addStringValue("publishCRLSuccess", "yes");
                        } else {
                            header.addStringValue("publishCRLSuccess", "no");
                            String publError = revReq.getExtDataInString("crlPublishError");
                            if (publError != null) {
                                header.addStringValue("publishCRLError", publError);
                            }
                        }
                    }
                }
                for (CRLIssuingPoint crl : engine.getCRLIssuingPoints()) {
                    String publishStatusStr;
                    Integer publishResult;
                    String updateStatusStr;
                    Integer updateResult;
                    String crlId = crl.getId();
                    if (crlId.equals("MasterCRL") || (updateResult = revReq.getExtDataInInteger(updateStatusStr = crl.getCrlUpdateStatusStr())) == null) continue;
                    if (updateResult.equals(Request.RES_SUCCESS)) {
                        logger.debug("DoRevoke: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADDING_HEADER", (Object[])new Object[]{updateStatusStr}));
                        header.addStringValue(updateStatusStr, "yes");
                    } else {
                        String updateErrorStr = crl.getCrlUpdateErrorStr();
                        logger.debug("DoRevoke: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADDING_HEADER_NO", (Object[])new Object[]{updateStatusStr}));
                        header.addStringValue(updateStatusStr, "no");
                        String error = revReq.getExtDataInString(updateErrorStr);
                        if (error != null) {
                            header.addStringValue(updateErrorStr, error);
                        }
                    }
                    if ((publishResult = revReq.getExtDataInInteger(publishStatusStr = crl.getCrlPublishStatusStr())) == null) continue;
                    if (publishResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue(publishStatusStr, "yes");
                        continue;
                    }
                    String publishErrorStr = crl.getCrlPublishErrorStr();
                    header.addStringValue(publishStatusStr, "no");
                    String error = revReq.getExtDataInString(publishErrorStr);
                    if (error == null) continue;
                    header.addStringValue(publishErrorStr, error);
                }
                if (this.mPublisherProcessor != null && this.mPublisherProcessor.ldapEnabled()) {
                    header.addStringValue("dirEnabled", "yes");
                    Integer[] ldapPublishStatus = revReq.getExtDataInIntegerArray("ldapPublishStatus");
                    int certsToUpdate = 0;
                    int certsUpdated = 0;
                    if (ldapPublishStatus != null) {
                        certsToUpdate = ldapPublishStatus.length;
                        for (int i = 0; i < certsToUpdate; ++i) {
                            if (ldapPublishStatus[i] != Request.RES_SUCCESS) continue;
                            ++certsUpdated;
                        }
                    }
                    header.addIntegerValue("certsUpdated", certsUpdated);
                    header.addIntegerValue("certsToUpdate", certsToUpdate);
                    String publError = revReq.getExtDataInString("crlPublishError");
                    if (publError != null) {
                        header.addStringValue("crlPublishError", publError);
                    }
                } else {
                    header.addStringValue("dirEnabled", "no");
                }
                header.addStringValue("error", null);
            } else {
                if (status == RequestStatus.PENDING || status == RequestStatus.REJECTED) {
                    header.addStringValue("revoked", status.toString());
                } else {
                    header.addStringValue("revoked", "no");
                }
                Vector errors = revReq.getExtDataInStringVector("errors");
                if (errors != null) {
                    StringBuilder errInfo = new StringBuilder();
                    for (int i = 0; i < errors.size(); ++i) {
                        errInfo.append((String)errors.elementAt(i));
                        errInfo.append("\n");
                    }
                    header.addStringValue("error", errInfo.toString());
                } else if (status == RequestStatus.PENDING) {
                    header.addStringValue("error", "Request Pending");
                } else {
                    header.addStringValue("error", null);
                }
            }
            processor.auditChangeRequestProcessed("Success");
        }
        catch (EBaseException e) {
            logger.error("Unable to revoke certificate: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequestProcessed("Failure");
            throw e;
        }
    }

    private BigInteger parseSerialNumber(String serialNumber) {
        if (StringUtils.isEmpty((CharSequence)serialNumber)) {
            return null;
        }
        serialNumber = serialNumber.trim();
        try {
            return new BigInteger(serialNumber, 10);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new BigInteger(serialNumber, 16);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new NumberFormatException("Invalid serial number: " + serialNumber);
            }
        }
    }
}

