/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.ExternalAuthToken;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertRequestProcessedEvent;
import com.netscape.certsrv.profile.EDeferException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.servlet.processors.CAProcessor;
import com.netscape.cms.tomcat.ExternalPrincipal;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestNotifier;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.math.BigInteger;
import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertProcessor
extends CAProcessor {
    public static Logger logger = LoggerFactory.getLogger(CertProcessor.class);

    public CertProcessor(String id, Locale locale) {
        super(id, locale);
    }

    protected void setCredentialsIntoContext(HttpServletRequest request, AuthCredentials creds, AuthManager authenticator, Map<String, String> ctx) {
        Enumeration names = authenticator.getValueNames();
        if (names == null) {
            logger.warn("CertProcessor: No authenticator credentials required");
            return;
        }
        logger.debug("CertProcessor: Authentication credentials:");
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = creds == null ? request.getParameter(name) : creds.get(name);
            if (value == null) continue;
            ctx.put(name, value.toString());
        }
    }

    private void setInputsIntoRequest(CertEnrollmentRequest data, Profile profile, Request req) {
        HashMap<String, String> dataInputs = new HashMap<String, String>();
        for (com.netscape.certsrv.profile.ProfileInput input : data.getInputs()) {
            for (ProfileAttribute attr : input.getAttributes()) {
                dataInputs.put(attr.getName(), attr.getValue());
            }
        }
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                Enumeration<String> inputNames = profileInput.getValueNames();
                if (inputNames == null) continue;
                while (inputNames.hasMoreElements()) {
                    String inputName = inputNames.nextElement();
                    if (!dataInputs.containsKey(inputName)) continue;
                    if (inputName.matches("^sn_.*")) {
                        req.setExtData(inputName, LDAPUtil.escapeRDNValue(dataInputs.get(inputName)));
                        continue;
                    }
                    req.setExtData(inputName, (String)dataInputs.get(inputName));
                }
            }
        }
    }

    private static void setAuthTokenIntoRequest(Request req, AuthToken authToken) {
        Principal principal;
        Enumeration tokenNames = authToken.getElements();
        while (tokenNames.hasMoreElements()) {
            String tokenName = (String)tokenNames.nextElement();
            String[] tokenVals = authToken.getInStringArray(tokenName);
            if (tokenVals != null) {
                for (int i = 0; i < tokenVals.length; ++i) {
                    req.setExtData("auth_token." + tokenName + "[" + i + "]", tokenVals[i]);
                }
                continue;
            }
            String tokenVal = authToken.getInString(tokenName);
            if (tokenVal == null) continue;
            req.setExtData("auth_token." + tokenName, tokenVal);
        }
        if (authToken instanceof ExternalAuthToken && (principal = ((ExternalAuthToken)authToken).getPrincipal()) instanceof ExternalPrincipal) {
            HashMap m = ((ExternalPrincipal)principal).getAttributes();
            for (String k : m.keySet()) {
                req.setExtData("auth_token.PRINCIPAL." + k, m.get(k).toString());
            }
        }
    }

    private void setInputsIntoRequest(Request request, Profile profile, Request req, Locale locale) {
        logger.debug("CertProcessor: setInputsIntoRequest()");
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                Enumeration<String> inputNames = profileInput.getValueNames();
                while (inputNames.hasMoreElements()) {
                    String inputName = inputNames.nextElement();
                    String inputValue = "";
                    try {
                        inputValue = profileInput.getValue(inputName, locale, request);
                    }
                    catch (Exception e) {
                        logger.warn("CertProcessor: setInputsIntoRequest() getvalue() failed: " + e.toString());
                    }
                    if (inputValue == null) continue;
                    req.setExtData(inputName, inputValue);
                }
            }
        }
    }

    protected String codeToReason(Locale locale, String errorCode, String errorString, RequestId requestId) {
        if (errorCode == null) {
            return null;
        }
        if (errorCode.equals("1")) {
            return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INTERNAL_ERROR", (String[])new String[]{requestId.toString()});
        }
        if (errorCode.equals("2")) {
            return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEFERRED", (String[])new String[]{errorString});
        }
        if (errorCode.equals("3")) {
            return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_REJECTED", (String[])new String[]{requestId.toString(), errorString});
        }
        return null;
    }

    protected String submitRequests(Locale locale, Profile profile, AuthToken authToken, Request[] reqs) {
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = "$Unidentified$";
        String errorCode = null;
        String errorReason = null;
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        for (Request req : reqs) {
            try {
                ConfigStore profileConf = profile.getConfigStore().getSubStore("auth", ConfigStore.class);
                boolean explicitApprovalRequired = profileConf.getBoolean("explicitApprovalRequired", false);
                auditRequesterID = this.auditRequesterID(req);
                logger.info("CertProcessor: Processing certificate request:");
                if (req != null) {
                    Enumeration reqKeys = req.getExtDataKeys();
                    while (reqKeys.hasMoreElements()) {
                        String reqKey = (String)reqKeys.nextElement();
                        String reqVal = req.getExtDataInString(reqKey);
                        if (reqVal == null) continue;
                        logger.info("CertProcessor: - " + reqKey + ": " + reqVal);
                    }
                }
                logger.info("CertProcessor: Submitting certificate request to " + profile.getId() + " profile");
                profile.submit(authToken, req, explicitApprovalRequired);
                req.setRequestStatus(RequestStatus.COMPLETE);
                X509CertImpl x509cert = req.getExtDataInCert("req_issued_cert");
                if (x509cert != null) {
                    auditor.log((LogEvent)CertRequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (String)"certificate", (X509CertImpl)x509cert));
                }
            }
            catch (EDeferException e) {
                logger.warn("Certificate request deferred: " + e.getMessage());
                req.setRequestStatus(RequestStatus.PENDING);
                RequestNotifier notify = engine.getRequestQueue().getPendingNotify();
                if (notify != null) {
                    notify.notify(req);
                }
                errorCode = "2";
                req.setExtData("errorCode", errorCode);
            }
            catch (ERejectException e) {
                logger.warn("Certificate request rejected: " + e.getMessage(), (Throwable)e);
                req.setRequestStatus(RequestStatus.REJECTED);
                errorCode = "3";
                req.setExtData("Error", e.toString());
                req.setExtData("errorCode", errorCode);
                auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)this.codeToReason(locale, errorCode, e.toString(), req.getRequestId())));
            }
            catch (Throwable e) {
                logger.warn("Certificate request failed: " + e.getMessage(), e);
                errorCode = "1";
                errorReason = this.codeToReason(locale, errorCode, null, req.getRequestId());
                req.setExtData("Error", errorReason);
                req.setExtData("errorCode", errorCode);
                auditor.log((LogEvent)CertRequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (String)"rejectReason", (String)errorReason));
            }
            try {
                logger.info("Updating certificate request");
                if (errorCode == null) {
                    engine.getRequestQueue().markAsServiced(req);
                    continue;
                }
                engine.getRequestRepository().updateRequest(req);
            }
            catch (EBaseException e) {
                logger.warn("Unable to update certificate request: " + e.getMessage(), (Throwable)e);
            }
        }
        return errorCode;
    }

    protected void populateRequests(CertEnrollmentRequest data, boolean isRenewal, Locale locale, Date origNotAfter, String origSubjectDN, Request origReq, String profileId, Profile profile, Map<String, String> ctx, AuthManager authenticator, AuthToken authToken, Request[] reqs) throws Exception {
        for (Request req : reqs) {
            if (isRenewal) {
                this.setInputsIntoRequest(origReq, profile, req, locale);
                req.setExtData("origNotAfter", BigInteger.valueOf(origNotAfter.getTime()));
                req.setExtData("authenticatedName", origSubjectDN);
                req.setRequestType("renewal");
            } else {
                this.setInputsIntoRequest(data, profile, req);
            }
            if (authToken != null) {
                CertProcessor.setAuthTokenIntoRequest(req, authToken);
                String raGroupName = "Registration Manager Agents";
                if (raGroupName.equals(authToken.getInString("group"))) {
                    String uid = authToken.getInString("uid");
                    if (uid == null) {
                        uid = "";
                    }
                    logger.debug("CertProcessor: request from RA: " + uid);
                    req.setExtData("requestOwner", uid);
                }
            }
            req.setExtData("profile", "true");
            req.setExtData("profileId", profileId);
            if (isRenewal) {
                req.setExtData("rprofileId", data.getProfileId());
            }
            req.setExtData("profileApprovedBy", profile.getApprovedBy());
            String setId = profile.getPolicySetId(req);
            if (setId == null) {
                logger.error("CertProcessor: no profile policy set found");
                throw new EBaseException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NO_POLICY_SET_FOUND", (String[])new String[0]));
            }
            logger.debug("CertProcessor: profileSetid=" + setId);
            req.setExtData("profileSetId", setId);
            req.setExtData("profileRemoteHost", data.getRemoteHost());
            req.setExtData("profileRemoteAddr", data.getRemoteAddr());
            logger.debug("CertProcessor: request " + req.getRequestId());
            logger.debug("CertProcessor: populating request inputs");
            if (authenticator != null) {
                authenticator.populate(authToken, req);
            }
            profile.populateInput(ctx, req);
            profile.populate(req);
        }
    }
}

