/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestProcessedEvent;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caCMCRevReq", urlPatterns={"/ee/ca/CMCRevReq"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/ee/ca/revocationResult.template"), @WebInitParam(name="ID", value="caCMCRevReq"), @WebInitParam(name="AuthMgr", value="CMCAuth"), @WebInitParam(name="resourceID", value="certServer.ca.certificates"), @WebInitParam(name="interface", value="ee")})
public class CMCRevReqServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(CMCRevReqServlet.class);
    private static final long serialVersionUID = 4731070386698127770L;
    public static final String GETCERTS_FOR_CHALLENGE_REQUEST = "getCertsForChallenge";
    public static final String TOKEN_CERT_SERIAL = "certSerialToRevoke";
    private static final String TPL_FILE = "revocationResult.template";
    public static final String CRED_CMC = "cmcRequest";
    private CertificateRepository mCertDB;
    private String mFormPath = null;
    private RequestQueue mQueue;
    private CAPublisherProcessor mPublisherProcessor;
    private String mRequestID = null;
    private static final String REVOKE = "revoke";
    private static final String ON_HOLD = "on-hold";
    private static final int ON_HOLD_REASON = 6;
    public static final String SERIAL_NO = "certSerialToRevoke";
    public static final String REASON_CODE = "reasonCode";
    public static final String CHALLENGE_PHRASE = "challengePhrase";
    public static final String SERIALNO_ARRAY = "serialNoArray";

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mFormPath = "/ca/revocationResult.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        this.mCertDB = engine.getCertificateRepository();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.mQueue = engine.getRequestQueue();
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        String method = "CMCRevReqServlet: process: ";
        logger.debug(method + "begins");
        String cmcAgentSerialNumber = null;
        ArgBlock httpParams = cmsReq.getHttpParams();
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        logger.debug(method + "**** mFormPath = " + this.mFormPath);
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]));
        }
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        String cmc = (String)httpParams.get(CRED_CMC);
        if (cmc == null) {
            throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NULL_CREDENTIAL", (String[])new String[]{CRED_CMC}));
        }
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, REVOKE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String authMgr = "noAuthManager";
        BigInteger[] serialNoArray = null;
        if (authToken != null) {
            serialNoArray = authToken.getInBigIntegerArray("certSerialToRevoke");
        }
        Integer reasonCode = 0;
        if (authToken != null) {
            reasonCode = authToken.getInInteger(REASON_CODE);
        }
        String comments = "";
        Date invalidityDate = null;
        String revokeAll = null;
        int verifiedRecordCount = 0;
        int totalRecordCount = 0;
        if (serialNoArray != null) {
            totalRecordCount = serialNoArray.length;
            verifiedRecordCount = serialNoArray.length;
        }
        X509CertImpl[] certs = null;
        Object initiative = null;
        if (this.mAuthMgr != null && this.mAuthMgr.equals("CMCAuth")) {
            if (authToken != null) {
                authMgr = authToken.getInString("authMgrInstName");
                String agentID = authToken.getInString("userid");
                initiative = "fromAgent agentID: " + agentID + " authenticated by " + authMgr;
            }
        } else {
            initiative = "fromUser";
        }
        if (serialNoArray != null && serialNoArray.length > 0) {
            int i;
            certs = new X509CertImpl[serialNoArray.length];
            for (i = 0; i < serialNoArray.length; ++i) {
                certs[i] = cr.getX509Certificate(serialNoArray[i]);
            }
            header.addIntegerValue("totalRecordCount", serialNoArray.length);
            header.addIntegerValue("verifiedRecordCount", serialNoArray.length);
            for (i = 0; i < serialNoArray.length; ++i) {
                ArgBlock rarg = new ArgBlock();
                rarg.addBigIntegerValue("serialNumber", serialNoArray[i], 16);
                rarg.addStringValue("subject", certs[i].getSubjectName().toString());
                rarg.addLongValue("validNotBefore", certs[i].getNotBefore().getTime() / 1000L);
                rarg.addLongValue("validNotAfter", certs[i].getNotAfter().getTime() / 1000L);
            }
            revokeAll = "(|(certRecordId=" + serialNoArray[0].toString() + "))";
            cmcAgentSerialNumber = authToken.getInString("sslClientCert");
            this.process(argSet, header, reasonCode, invalidityDate, (String)initiative, req, resp, verifiedRecordCount, revokeAll, totalRecordCount, comments, locale[0], cmcAgentSerialNumber);
        } else {
            header.addIntegerValue("totalRecordCount", 0);
            header.addIntegerValue("verifiedRecordCount", 0);
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (serialNoArray == null || serialNoArray.length == 0) {
                cmsReq.setStatus(CMSRequest.ERROR);
                EBaseException ee = new EBaseException("No matched certificate is found");
                cmsReq.setError(ee);
            } else {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, int reason, Date invalidityDate, String initiative, HttpServletRequest req, HttpServletResponse resp, int verifiedRecordCount, String revokeAll, int totalRecordCount, String comments, Locale locale, String cmcAgentSerialNumber) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        String eeSerialNumber = null;
        if (cmcAgentSerialNumber != null) {
            eeSerialNumber = cmcAgentSerialNumber;
        } else {
            X509CertImpl sslCert = (X509CertImpl)this.getSSLClientCertificate(req);
            if (sslCert != null) {
                eeSerialNumber = sslCert.getSerialNumber().toString();
            }
        }
        Auditor auditor = engine.getAuditor();
        boolean auditRequest = true;
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID(req);
        String auditSerialNumber = this.auditSerialNumber(eeSerialNumber);
        String auditRequestType = this.auditRequestType(reason);
        RequestStatus auditApprovalStatus = null;
        String auditReasonNum = String.valueOf(reason);
        try {
            int count = 0;
            Vector<X509CertImpl> oldCertsV = new Vector<X509CertImpl>();
            Vector<RevokedCertImpl> revCertImplsV = new Vector<RevokedCertImpl>();
            RevocationReason revReason = RevocationReason.valueOf((int)reason);
            header.addIntegerValue(REASON_CODE, reason);
            if (revReason != null) {
                header.addStringValue("reason", revReason.toString());
            } else {
                header.addStringValue("error", "Invalid revocation reason: " + reason);
            }
            CRLReasonExtension crlReasonExtn = new CRLReasonExtension(revReason);
            InvalidityDateExtension invalidityDateExtn = null;
            if (invalidityDate != null) {
                invalidityDateExtn = new InvalidityDateExtension(invalidityDate);
            }
            CRLExtensions entryExtn = new CRLExtensions();
            if (crlReasonExtn != null) {
                entryExtn.set(crlReasonExtn.getName(), (Extension)crlReasonExtn);
            }
            if (invalidityDateExtn != null) {
                entryExtn.set(invalidityDateExtn.getName(), (Extension)invalidityDateExtn);
            }
            CertRecordList list = this.mCertDB.findCertRecordsInList(revokeAll, null, totalRecordCount);
            Enumeration e = list.getCertRecords(0, totalRecordCount - 1);
            while (e != null && e.hasMoreElements()) {
                CertRecord rec = (CertRecord)e.nextElement();
                X509CertImpl cert = rec.getCertificate();
                ArgBlock rarg = new ArgBlock();
                rarg.addBigIntegerValue("serialNumber", cert.getSerialNumber(), 16);
                if (rec.getStatus().equals("REVOKED") && (revReason == null || revReason != RevocationReason.REMOVE_FROM_CRL)) {
                    rarg.addStringValue("error", "Certificate " + cert.getSerialNumber().toString() + " is already revoked.");
                } else {
                    oldCertsV.addElement(cert);
                    RevokedCertImpl revCertImpl = new RevokedCertImpl(cert.getSerialNumber(), new Date(), entryExtn);
                    revCertImplsV.addElement(revCertImpl);
                    ++count;
                    rarg.addStringValue("error", null);
                }
                argSet.addRepeatRecord(rarg);
            }
            header.addIntegerValue("totalRecordCount", count);
            X509CertImpl[] oldCerts = new X509CertImpl[count];
            RevokedCertImpl[] revCertImpls = new RevokedCertImpl[count];
            BigInteger[] certSerialNumbers = new BigInteger[count];
            for (int i = 0; i < count; ++i) {
                oldCerts[i] = (X509CertImpl)oldCertsV.elementAt(i);
                revCertImpls[i] = (RevokedCertImpl)revCertImplsV.elementAt(i);
                certSerialNumbers[i] = oldCerts[i].getSerialNumber();
            }
            CertRequestRepository requestRepository = engine.getCertRequestRepository();
            Request revReq = null;
            revReq = revReason != null && revReason == RevocationReason.REMOVE_FROM_CRL ? requestRepository.createRequest("unrevocation") : requestRepository.createRequest("revocation");
            auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Success", auditRequesterID, auditSerialNumber, auditRequestType));
            revReq.setExtData("requestorType", "Agent");
            if (revReason != null && revReason == RevocationReason.REMOVE_FROM_CRL) {
                revReq.setExtData("requestType", "unrevocation");
                revReq.setExtData("OLD_SERIALS", certSerialNumbers);
            } else {
                revReq.setExtData("CERT_INFO", revCertImpls);
                revReq.setExtData("requestType", "revocation");
                revReq.setExtData("revocationReason", Integer.valueOf(reason));
                revReq.setExtData("OLD_CERTS", oldCerts);
                if (comments != null) {
                    revReq.setExtData("csrRequestorComments", comments);
                }
            }
            auditRequest = false;
            this.mQueue.processRequest(revReq);
            auditApprovalStatus = revReq.getRequestStatus();
            RequestStatus stat = revReq.getRequestStatus();
            if (stat == RequestStatus.COMPLETE) {
                Integer result = revReq.getExtDataInInteger("Result");
                if (result.equals(Request.RES_ERROR)) {
                    String[] svcErrors = revReq.getExtDataInStringArray("serviceErrors");
                    if (svcErrors != null && svcErrors.length > 0) {
                        for (int i = 0; i < svcErrors.length; ++i) {
                            String err = svcErrors[i];
                            if (err == null) continue;
                            for (int j = 0; j < count; ++j) {
                                if (oldCerts[j] == null) continue;
                                logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "completed with error: " + err, oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                            }
                        }
                    }
                    return;
                }
                for (int j = 0; j < count; ++j) {
                    if (oldCerts[j] == null) continue;
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "completed", oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                }
                header.addStringValue("revoked", "yes");
                Integer updateCRLResult = revReq.getExtDataInInteger("crlUpdateStatus");
                if (updateCRLResult != null) {
                    header.addStringValue("updateCRL", "yes");
                    if (updateCRLResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue("updateCRLSuccess", "yes");
                    } else {
                        header.addStringValue("updateCRLSuccess", "no");
                        String crlError = revReq.getExtDataInString("crlUpdateError");
                        if (crlError != null) {
                            header.addStringValue("updateCRLError", crlError);
                        }
                    }
                    Integer publishCRLResult = revReq.getExtDataInInteger("crlPublishStatus");
                    if (publishCRLResult != null) {
                        if (publishCRLResult.equals(Request.RES_SUCCESS)) {
                            header.addStringValue("publishCRLSuccess", "yes");
                        } else {
                            header.addStringValue("publishCRLSuccess", "no");
                            String publError = revReq.getExtDataInString("crlPublishError");
                            if (publError != null) {
                                header.addStringValue("publishCRLError", publError);
                            }
                        }
                    }
                }
                for (CRLIssuingPoint crl : engine.getCRLIssuingPoints()) {
                    String publishStatusStr;
                    Integer publishResult;
                    String updateStatusStr;
                    Integer updateResult;
                    String crlId = crl.getId();
                    if (crlId.equals("MasterCRL") || (updateResult = revReq.getExtDataInInteger(updateStatusStr = crl.getCrlUpdateStatusStr())) == null) continue;
                    if (updateResult.equals(Request.RES_SUCCESS)) {
                        logger.debug("CMCRevReqServlet: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADDING_HEADER", (Object[])new Object[]{updateStatusStr}));
                        header.addStringValue(updateStatusStr, "yes");
                    } else {
                        String updateErrorStr = crl.getCrlUpdateErrorStr();
                        logger.debug("CMCRevReqServlet: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADDING_HEADER_NO", (Object[])new Object[]{updateStatusStr}));
                        header.addStringValue(updateStatusStr, "no");
                        String error = revReq.getExtDataInString(updateErrorStr);
                        if (error != null) {
                            header.addStringValue(updateErrorStr, error);
                        }
                    }
                    if ((publishResult = revReq.getExtDataInInteger(publishStatusStr = crl.getCrlPublishStatusStr())) == null) continue;
                    if (publishResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue(publishStatusStr, "yes");
                        continue;
                    }
                    String publishErrorStr = crl.getCrlPublishErrorStr();
                    header.addStringValue(publishStatusStr, "no");
                    String error = revReq.getExtDataInString(publishErrorStr);
                    if (error == null) continue;
                    header.addStringValue(publishErrorStr, error);
                }
                if (this.mPublisherProcessor != null && this.mPublisherProcessor.ldapEnabled()) {
                    header.addStringValue("dirEnabled", "yes");
                    Integer[] ldapPublishStatus = revReq.getExtDataInIntegerArray("ldapPublishStatus");
                    int certsToUpdate = 0;
                    int certsUpdated = 0;
                    if (ldapPublishStatus != null) {
                        certsToUpdate = ldapPublishStatus.length;
                        for (int i = 0; i < certsToUpdate; ++i) {
                            if (ldapPublishStatus[i] != Request.RES_SUCCESS) continue;
                            ++certsUpdated;
                        }
                    }
                    header.addIntegerValue("certsUpdated", certsUpdated);
                    header.addIntegerValue("certsToUpdate", certsToUpdate);
                    String publError = revReq.getExtDataInString("crlPublishError");
                    if (publError != null) {
                        header.addStringValue("crlPublishError", publError);
                    }
                } else {
                    header.addStringValue("dirEnabled", "no");
                }
                header.addStringValue("error", null);
            } else if (stat == RequestStatus.PENDING) {
                header.addStringValue("error", "Request Pending");
                header.addStringValue("revoked", "pending");
                for (int j = 0; j < count; ++j) {
                    if (oldCerts[j] == null) continue;
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "pending", oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                }
            } else {
                Vector errors = revReq.getExtDataInStringVector("errors");
                StringBuffer errorStr = new StringBuffer();
                if (errors != null && errors.size() > 0) {
                    for (int ii = 0; ii < errors.size(); ++ii) {
                        errorStr.append((String)errors.elementAt(ii));
                    }
                }
                header.addStringValue("error", errorStr.toString());
                header.addStringValue("revoked", "no");
                for (int j = 0; j < count; ++j) {
                    if (oldCerts[j] == null) continue;
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, stat.toString(), oldCerts[j].getSubjectName(), oldCerts[j].getSerialNumber().toString(16), RevocationReason.valueOf((int)reason)});
                }
            }
            if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Success", auditRequesterID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
        }
        catch (EBaseException e) {
            logger.error("CMCRevReqServlet: " + e.getMessage(), (Throwable)e);
            if (auditRequest) {
                auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Failure", auditRequesterID, auditSerialNumber, auditRequestType));
            } else if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditRequesterID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
            throw e;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            if (auditRequest) {
                auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Failure", auditRequesterID, auditSerialNumber, auditRequestType));
            } else if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditRequesterID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_MARKING_CERT_REVOKED", (Object[])new Object[0]), (Exception)e);
        }
        catch (Exception e) {
            if (auditRequest) {
                auditor.log((LogEvent)new CertStatusChangeRequestEvent(auditSubjectID, "Failure", auditRequesterID, auditSerialNumber, auditRequestType));
            } else if (auditApprovalStatus == RequestStatus.COMPLETE || auditApprovalStatus == RequestStatus.REJECTED || auditApprovalStatus == RequestStatus.CANCELED) {
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditRequesterID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
            }
            logger.warn("CMCRevReqServlet: " + e.getMessage(), (Throwable)e);
        }
    }

    private String auditRequesterID(HttpServletRequest req) {
        String requesterID = null;
        requesterID = req.getParameter("requestId");
        requesterID = requesterID != null ? requesterID.trim() : "$Unidentified$";
        return requesterID;
    }

    private String auditSerialNumber(String eeSerialNumber) {
        Object serialNumber = null;
        if (eeSerialNumber != null) {
            serialNumber = eeSerialNumber.trim();
            serialNumber = "0x" + Integer.toHexString(Integer.valueOf((String)serialNumber));
        } else {
            serialNumber = "<null>";
        }
        return serialNumber;
    }

    private String auditRequestType(int reason) {
        String requestType = null;
        requestType = reason == 6 ? ON_HOLD : REVOKE;
        return requestType;
    }
}

