/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.publishers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Publisher;
import com.netscape.cms.publish.publishers.LdapUserCertPublisher;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCertificatePairPublisher
extends Publisher
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapCertificatePairPublisher.class);
    public static final String LDAP_CROSS_CERT_PAIR_ATTR = "crossCertificatePair;binary";
    public static final String LDAP_CA_OBJECTCLASS = "pkiCA";
    public static final String LDAP_ARL_ATTR = "authorityRevocationList;binary";
    public static final String LDAP_CRL_ATTR = "certificateRevocationList;binary";
    public static final String LDAP_CACERT_ATTR = "caCertificate;binary";
    protected String mCrossCertPairAttr = "crossCertificatePair;binary";
    protected String mCaObjectclass = "pkiCA";
    protected String mObjAdded = "";
    protected String mObjDeleted = "";
    private boolean mInited = false;
    protected ConfigStore mConfig;

    public LdapCertificatePairPublisher() {
    }

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"crossCertPairAttr;string;Name of Ldap attribute in which to store cross certificates", "caObjectClass;string;The name of the objectclasses which should be added to this entry, if they do not already exist. This can be 'certificationAuthority' (if using RFC 2256) or 'pkiCA' (if using RFC 4523)", "HELP_TOKEN;configuration-ldappublish-publisher-crosscertpairpublisher", "HELP_TEXT;This plugin knows how to publish the CA cert to 'certificateAuthority' and 'pkiCA' -type entries"};
        return s;
    }

    public String getImplName() {
        return "LdapCertificatePairPublisher";
    }

    public String getDescription() {
        return "LdapCertificatePairPublisher";
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("crossCertPairAttr=" + this.mCrossCertPairAttr);
        v.addElement("caObjectClass=" + this.mCaObjectclass);
        return v;
    }

    public Vector<String> getInstanceParamsWithExtras() {
        return this.getInstanceParams();
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("crossCertPairAttr=" + this.mCrossCertPairAttr);
        v.addElement("caObjectClass=" + this.mCaObjectclass);
        return v;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mConfig = config;
        this.mCrossCertPairAttr = this.mConfig.getString("crossCertPairAttr", LDAP_CROSS_CERT_PAIR_ATTR);
        this.mCaObjectclass = this.mConfig.getString("caObjectClass", LDAP_CA_OBJECTCLASS);
        this.mObjAdded = this.mConfig.getString("caObjectClassAdded", "");
        this.mObjDeleted = this.mConfig.getString("caObjectClassDeleted", "");
        this.mInited = true;
    }

    public LdapCertificatePairPublisher(String crossCertPairAttr, String caObjectclass) {
        this.mCrossCertPairAttr = crossCertPairAttr;
        this.mCaObjectclass = caObjectclass;
        this.mInited = true;
    }

    public String getCAObjectclass() {
        return this.mCaObjectclass;
    }

    public String getXCertAttrName() {
        return this.mCrossCertPairAttr;
    }

    public synchronized void publish(LDAPConnection conn, String dn, Object pair) throws ELdapException {
        this.publish(conn, dn, (byte[])pair);
    }

    public synchronized void publish(LDAPConnection conn, String dn, byte[] pair) throws ELdapException {
        if (conn == null) {
            logger.info("LdapCertificatePairPublisher: no LDAP connection");
            return;
        }
        try {
            this.mCrossCertPairAttr = this.mConfig.getString("crossCertPairAttr", LDAP_CROSS_CERT_PAIR_ATTR);
            this.mCaObjectclass = this.mConfig.getString("caObjectClass", LDAP_CA_OBJECTCLASS);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            LDAPSearchResults res = conn.search(dn, 0, "(objectclass=*)", new String[]{LDAP_CACERT_ATTR, LDAP_CRL_ATTR, LDAP_ARL_ATTR}, true);
            LDAPEntry entry = res.next();
            LDAPAttribute certs = entry.getAttribute(LDAP_CACERT_ATTR);
            LDAPAttribute arls = entry.getAttribute(LDAP_ARL_ATTR);
            LDAPAttribute crls = entry.getAttribute(LDAP_CRL_ATTR);
            LDAPSearchResults res1 = conn.search(dn, 0, "(objectclass=*)", new String[]{"objectclass", this.mCrossCertPairAttr}, false);
            LDAPEntry entry1 = res1.next();
            LDAPAttribute ocs = entry1.getAttribute("objectclass");
            LDAPAttribute certPairs = entry1.getAttribute("crosscertificatepair;binary");
            LDAPModificationSet modSet = new LDAPModificationSet();
            boolean hasCert = LdapUserCertPublisher.ByteValueExists(certPairs, pair);
            if (LdapUserCertPublisher.ByteValueExists(certPairs, pair)) {
                logger.debug("LdapCertificatePairPublisher: cross cert pair bytes exist in publishing directory, do not publish again.");
                return;
            }
            if (hasCert) {
                logger.info("LdapCertificatePairPublisher: CA " + dn + " already has cross cert pair bytes");
            } else {
                modSet.add(0, new LDAPAttribute(this.mCrossCertPairAttr, pair));
                logger.info("LdapCertificatePairPublisher: cross cert pair published with dn=" + dn);
            }
            String[] oclist = this.mCaObjectclass.split(",");
            boolean attrsAdded = false;
            for (int i = 0; i < oclist.length; ++i) {
                String oc = oclist[i].trim();
                boolean hasoc = LdapUserCertPublisher.StringValueExists(ocs, oc);
                if (hasoc) continue;
                logger.info("LdapCertificatePairPublisher: adding CA objectclass " + oc + " to " + dn);
                modSet.add(0, new LDAPAttribute("objectclass", oc));
                if (attrsAdded || !oc.equalsIgnoreCase("certificationAuthority")) continue;
                if (arls == null) {
                    modSet.add(0, new LDAPAttribute(LDAP_ARL_ATTR, ""));
                }
                if (crls == null) {
                    modSet.add(0, new LDAPAttribute(LDAP_CRL_ATTR, ""));
                }
                if (certs == null) {
                    modSet.add(0, new LDAPAttribute(LDAP_CACERT_ATTR, ""));
                }
                attrsAdded = true;
            }
            String[] delList = this.mObjDeleted.split(",");
            if (delList.length > 0) {
                for (int i = 0; i < delList.length; ++i) {
                    String deloc = delList[i].trim();
                    boolean hasoc = LdapUserCertPublisher.StringValueExists(ocs, deloc);
                    boolean match = false;
                    for (int j = 0; j < oclist.length; ++j) {
                        if (!oclist[j].trim().equals(deloc)) continue;
                        match = true;
                        break;
                    }
                    if (match || !hasoc) continue;
                    logger.info("LdapCertificatePairPublisher: deleting CRL objectclass " + deloc + " from " + dn);
                    modSet.add(1, new LDAPAttribute("objectclass", deloc));
                }
            }
            if (!this.mObjAdded.equals("") || !this.mObjDeleted.equals("")) {
                this.mObjAdded = "";
                this.mObjDeleted = "";
                this.mConfig.putString("caObjectClassAdded", "");
                this.mConfig.putString("caObjectClassDeleted", "");
                try {
                    this.mConfig.commit(false);
                }
                catch (Exception e) {
                    logger.info("Failure in updating mObjAdded and mObjDeleted");
                }
            }
            if (modSet.size() > 0) {
                conn.modify(dn, modSet);
            }
            logger.debug("LdapCertificatePairPublisher: in publish() just published");
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_PUBLISHER_EXCEPTION", (Object[])new Object[]{"", e.toString()}), (Throwable)e);
            throw new ELdapException("Unable to publishing cross cert pair:" + e.toString(), (Throwable)e);
        }
    }

    public void unpublish(LDAPConnection conn, String dn, Object certObj) throws ELdapException {
        logger.debug("LdapCertificatePairPublisher: unpublish() is unsupported in this revision");
    }
}

