/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.security.cert.X509Certificate;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCertExactMap
extends Mapper
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapCertExactMap.class);
    protected ConfigStore mConfig;
    boolean mInited = false;

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        if (this.mInited) {
            return;
        }
        this.mConfig = config;
        this.mInited = true;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"HELP_TOKEN;configuration-ldappublish-mapper-certexactmapper", "HELP_TEXT;Literally uses the subject name of the certificate as the DN to publish to"};
        return params;
    }

    public String getImplName() {
        return "LdapCertExactMap";
    }

    public String getDescription() {
        return "LdapCertExactMap";
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        return v;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        return v;
    }

    public String map(LDAPConnection conn, Object obj) throws ELdapException {
        if (conn == null) {
            return null;
        }
        X500Name subjectDN = null;
        try {
            X509Certificate cert = (X509Certificate)obj;
            subjectDN = (X500Name)cert.getSubjectDN();
            logger.debug("LdapCertExactMap: cert subject dn:" + subjectDN.toString());
        }
        catch (ClassCastException e) {
            try {
                X509CRLImpl crl = (X509CRLImpl)obj;
                subjectDN = (X500Name)crl.getIssuerDN();
                logger.warn("LdapCertExactMap: crl issuer dn: " + subjectDN + ": " + e.getMessage(), (Throwable)e);
            }
            catch (ClassCastException ex) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_NOT_SUPPORTED_OBJECT", (Object[])new Object[0]), (Throwable)e);
                return null;
            }
        }
        try {
            String[] attrs = new String[]{"1.1"};
            logger.info("Searching for " + subjectDN.toString());
            LDAPSearchResults results = conn.search(subjectDN.toString(), 0, "(objectclass=*)", attrs, false);
            LDAPEntry entry = results.next();
            if (results.hasMoreElements()) {
                logger.warn(CMS.getLogMessage((String)"PUBLISH_MORE_THAN_ONE_ENTRY", (Object[])new Object[]{"", subjectDN.toString()}));
            }
            if (entry != null) {
                logger.info("entry found");
                return entry.getDN();
            }
            return null;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_MAP_EXCEPTION", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public String map(LDAPConnection conn, Request req, Object obj) throws ELdapException {
        return this.map(conn, obj);
    }
}

