/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.ca.CASigningUnit;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IAttrSet;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.pattern.Pattern;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.security.SigningUnitConfig;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.extensions.KerberosName;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.CIDRNetmask;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.EDIPartyName;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.IPAddressName;
import org.mozilla.jss.netscape.security.x509.OIDName;
import org.mozilla.jss.netscape.security.x509.OtherName;
import org.mozilla.jss.netscape.security.x509.RFC822Name;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrollDefault
extends PolicyDefault {
    public static Logger logger = LoggerFactory.getLogger(EnrollDefault.class);
    public static final String PROP_NAME = "name";
    public static final String GN_RFC822_NAME = "RFC822Name";
    public static final String GN_DNS_NAME = "DNSName";
    public static final String GN_URI_NAME = "URIName";
    public static final String GN_IP_NAME = "IPAddressName";
    public static final String GN_DIRECTORY_NAME = "DirectoryName";
    public static final String GN_EDI_NAME = "EDIPartyName";
    public static final String GN_ANY_NAME = "OtherName";
    public static final String GN_OID_NAME = "OIDName";
    protected Vector<String> mConfigNames = new Vector();
    protected Vector<String> mValueNames = new Vector();

    public Enumeration<String> getConfigNames() {
        return this.mConfigNames.elements();
    }

    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        return null;
    }

    public void addConfigName(String name) {
        this.mConfigNames.addElement(name);
    }

    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore("params") != null) {
            this.mConfig.getSubStore("params").putString(name, value);
        }
    }

    public String getConfig(String name) {
        return this.getConfig(name, "");
    }

    public String getConfig(String name, String defval) {
        if (this.mConfig == null) {
            logger.warn("Missing profile default configuration");
            return null;
        }
        ConfigStore params = this.mConfig.getSubStore("params", ConfigStore.class);
        if (params == null) {
            logger.warn("Missing profile default parameters");
            return null;
        }
        try {
            return params.getString(name, defval);
        }
        catch (EBaseException e) {
            logger.warn("Unable to get profile default " + name + " parameter: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public abstract String getText(Locale var1);

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    @Override
    public String getName(Locale locale) {
        try {
            return this.mConfig.getString(PROP_NAME);
        }
        catch (EBaseException e) {
            return null;
        }
    }

    public abstract void populate(Request var1, X509CertInfo var2) throws EProfileException;

    public abstract void setValue(String var1, Locale var2, X509CertInfo var3, String var4) throws EPropertyException;

    public abstract String getValue(String var1, Locale var2, X509CertInfo var3) throws EPropertyException;

    @Override
    public void populate(Request request) throws EProfileException {
        String method = "EnrollDefault: populate: ";
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        logger.debug(method + name + ": start");
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        this.populate(request, info);
        request.setExtData("req_x509info", info);
        logger.debug(method + name + ": end");
    }

    public void addValueName(String name) {
        this.mValueNames.addElement(name);
    }

    @Override
    public Enumeration<String> getValueNames() {
        return this.mValueNames.elements();
    }

    public IDescriptor getValueDescriptor(String name) {
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, Request request, String value) throws EPropertyException {
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        this.setValue(name, locale, info, value);
        boolean ret = request.setExtData("req_x509info", info);
        if (!ret) {
            logger.error("EnrollDefault: setValue(): request.setExtData() returned false");
            throw new EPropertyException("EnrollDefault: setValue(): request.setExtData() failed");
        }
    }

    @Override
    public String getValue(String name, Locale locale, Request request) throws EPropertyException {
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        String value = this.getValue(name, locale, info);
        request.setExtData("req_x509info", info);
        return value;
    }

    public String toHexString(byte[] data) {
        PrettyPrintFormat pp = new PrettyPrintFormat(":");
        String s = pp.toHexString(data, 0, 16);
        StringTokenizer st = new StringTokenizer(s, "\n");
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            buffer.append(st.nextToken());
            buffer.append("\\n");
        }
        return buffer.toString();
    }

    protected void refreshConfigAndValueNames() {
        this.mConfigNames.removeAllElements();
        this.mValueNames.removeAllElements();
    }

    protected void deleteExtension(String extID, X509CertInfo info) throws Exception {
        CertificateExtensions exts = (CertificateExtensions)info.get("extensions");
        if (exts == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        Enumeration e = exts.getNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Extension ext = (Extension)exts.get(name);
            if (!ext.getExtensionId().toString().equals(extID)) continue;
            names.add(name);
        }
        for (String name : names) {
            exts.delete(name);
        }
    }

    protected Extension getExtension(String name, X509CertInfo info) {
        if (info == null) {
            logger.error("Missing certificate info");
            return null;
        }
        CertificateExtensions exts = null;
        try {
            exts = (CertificateExtensions)info.get("extensions");
        }
        catch (Exception e) {
            logger.warn("EnrollDefault: getExtension " + e.getMessage(), (Throwable)e);
        }
        if (exts == null) {
            logger.debug("EnrollDefault: Unable to find extensions");
            return null;
        }
        return this.getExtension(name, exts);
    }

    protected Extension getExtension(String name, CertificateExtensions exts) {
        logger.debug("EnrollDefault: Searching for " + name + " extension");
        if (exts == null) {
            logger.error("Missing certificate extensions");
            return null;
        }
        Enumeration e = exts.getAttributes();
        logger.debug("EnrollDefault: Extensions:");
        while (e.hasMoreElements()) {
            Extension ext = (Extension)e.nextElement();
            logger.debug("EnrollDefault: - " + ext.getExtensionId());
            if (!ext.getExtensionId().toString().equals(name)) continue;
            logger.debug("EnrollDefault: Found extension " + name);
            return ext;
        }
        logger.debug("EnrollDefault: Extension " + name + " not found");
        return null;
    }

    protected void addExtension(String name, Extension ext, X509CertInfo info) throws EProfileException {
        if (ext == null) {
            throw new EProfileException("addExtension: extension '" + name + "' is null");
        }
        CertificateExtensions exts = null;
        Extension alreadyPresentExtension = this.getExtension(name, info);
        if (alreadyPresentExtension != null) {
            String eName = ext.toString();
            logger.error("Duplicate extension: " + eName);
            throw new EProfileException(CMS.getUserMessage((String)"CMS_PROFILE_DUPLICATE_EXTENSION", (String[])new String[]{eName}));
        }
        try {
            exts = (CertificateExtensions)info.get("extensions");
        }
        catch (Exception e) {
            logger.warn("EnrollDefault: " + e.getMessage(), (Throwable)e);
        }
        if (exts == null) {
            throw new EProfileException("extensions not found");
        }
        try {
            exts.set(name, (Object)ext);
        }
        catch (IOException e) {
            logger.warn("EnrollDefault: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void replaceExtension(String name, Extension ext, X509CertInfo info) throws EProfileException {
        try {
            this.deleteExtension(name, info);
        }
        catch (Exception e) {
            throw new EProfileException((Throwable)e);
        }
        this.addExtension(name, ext, info);
    }

    protected boolean isOptional(String value) {
        return value.equals("");
    }

    protected boolean getBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    protected int getInt(String value) {
        return Integer.parseInt(value);
    }

    protected boolean getConfigBoolean(String value) {
        return this.getBoolean(this.getConfig(value));
    }

    protected int getConfigInt(String value) {
        return this.getInt(this.getConfig(value));
    }

    protected boolean isGeneralNameValid(String name) {
        if (name == null) {
            return false;
        }
        int pos = name.indexOf(58);
        if (pos == -1) {
            return false;
        }
        String nameValue = name.substring(pos + 1).trim();
        return !nameValue.equals("");
    }

    protected GeneralNameInterface parseGeneralName(String name) throws IOException {
        int pos = name.indexOf(58);
        if (pos == -1) {
            return null;
        }
        String nameType = name.substring(0, pos).trim();
        String nameValue = name.substring(pos + 1).trim();
        return this.parseGeneralName(nameType, nameValue);
    }

    protected boolean isGeneralNameType(String nameType) {
        if (nameType.equalsIgnoreCase(GN_RFC822_NAME)) {
            return true;
        }
        if (nameType.equalsIgnoreCase(GN_DNS_NAME)) {
            return true;
        }
        if (nameType.equalsIgnoreCase("x400")) {
            return true;
        }
        if (nameType.equalsIgnoreCase(GN_DIRECTORY_NAME)) {
            return true;
        }
        if (nameType.equalsIgnoreCase(GN_EDI_NAME)) {
            return true;
        }
        if (nameType.equalsIgnoreCase(GN_URI_NAME)) {
            return true;
        }
        if (nameType.equalsIgnoreCase("IPAddress")) {
            return true;
        }
        if (nameType.equalsIgnoreCase(GN_OID_NAME)) {
            return true;
        }
        return nameType.equalsIgnoreCase(GN_ANY_NAME);
    }

    protected GeneralNameInterface parseGeneralName(String nameType, String nameValue) throws IOException {
        if (nameType.equalsIgnoreCase(GN_RFC822_NAME)) {
            return new RFC822Name(nameValue);
        }
        if (nameType.equalsIgnoreCase(GN_DNS_NAME)) {
            return new DNSName(nameValue);
        }
        if (nameType.equalsIgnoreCase("x400")) {
            // empty if block
        }
        if (nameType.equalsIgnoreCase(GN_DIRECTORY_NAME)) {
            return new X500Name(nameValue);
        }
        if (nameType.equalsIgnoreCase(GN_EDI_NAME)) {
            return new EDIPartyName(nameValue);
        }
        if (nameType.equalsIgnoreCase(GN_URI_NAME)) {
            return new URIName(nameValue);
        }
        if (nameType.equalsIgnoreCase("IPAddress")) {
            logger.debug("IP Value:" + nameValue);
            if (nameValue.indexOf(47) != -1) {
                StringTokenizer st = new StringTokenizer(nameValue, "/");
                String addr = st.nextToken();
                CIDRNetmask netmask = new CIDRNetmask(st.nextToken());
                logger.debug("addr:" + addr + " CIDR netmask: " + netmask);
                return new IPAddressName(addr, netmask);
            }
            if (nameValue.indexOf(44) != -1) {
                StringTokenizer st = new StringTokenizer(nameValue, ",");
                String addr = st.nextToken();
                String netmask = st.nextToken();
                logger.debug("addr:" + addr + " netmask: " + netmask);
                return new IPAddressName(addr, netmask);
            }
            return new IPAddressName(nameValue);
        }
        if (nameType.equalsIgnoreCase(GN_OID_NAME)) {
            try {
                new ObjectIdentifier(nameValue);
            }
            catch (Exception e) {
                return null;
            }
            return new OIDName(nameValue);
        }
        if (nameType.equals(GN_ANY_NAME)) {
            if (nameValue == null || nameValue.length() == 0) {
                nameValue = " ";
            }
            if (nameValue.startsWith("(PrintableString)")) {
                int pos0 = nameValue.indexOf(41);
                int pos1 = nameValue.indexOf(44);
                if (pos1 == -1) {
                    return null;
                }
                String on_oid = nameValue.substring(pos0 + 1, pos1).trim();
                String on_value = nameValue.substring(pos1 + 1).trim();
                if (this.isValidOID(on_oid)) {
                    logger.debug("OtherName about to create OtherName object:");
                    logger.debug("OID: " + on_oid + " Value:" + on_value);
                    return new OtherName(new ObjectIdentifier(on_oid), 19, on_value);
                }
                return null;
            }
            if (nameValue.startsWith("(KerberosName)")) {
                int pos0 = nameValue.indexOf(41);
                int pos1 = nameValue.indexOf(124);
                int pos2 = nameValue.lastIndexOf(124);
                String realm = nameValue.substring(pos0 + 1, pos1).trim();
                String name_type = nameValue.substring(pos1 + 1, pos2).trim();
                String name_strings = nameValue.substring(pos2 + 1).trim();
                Vector<String> strings = new Vector<String>();
                StringTokenizer st = new StringTokenizer(name_strings, ",");
                while (st.hasMoreTokens()) {
                    strings.addElement(st.nextToken());
                }
                KerberosName name = new KerberosName(realm, Integer.parseInt(name_type), strings);
                return new OtherName(KerberosName.KRB5_PRINCIPAL_NAME, name.toByteArray());
            }
            if (nameValue.startsWith("(IA5String)")) {
                int pos0 = nameValue.indexOf(41);
                int pos1 = nameValue.indexOf(44);
                if (pos1 == -1) {
                    return null;
                }
                String on_oid = nameValue.substring(pos0 + 1, pos1).trim();
                String on_value = nameValue.substring(pos1 + 1).trim();
                if (this.isValidOID(on_oid)) {
                    return new OtherName(new ObjectIdentifier(on_oid), 22, on_value);
                }
                return null;
            }
            if (nameValue.startsWith("(UTF8String)")) {
                int pos0 = nameValue.indexOf(41);
                int pos1 = nameValue.indexOf(44);
                if (pos1 == -1) {
                    return null;
                }
                String on_oid = nameValue.substring(pos0 + 1, pos1).trim();
                String on_value = nameValue.substring(pos1 + 1).trim();
                if (this.isValidOID(on_oid)) {
                    return new OtherName(new ObjectIdentifier(on_oid), 12, on_value);
                }
                return null;
            }
            if (nameValue.startsWith("(BMPString)")) {
                int pos0 = nameValue.indexOf(41);
                int pos1 = nameValue.indexOf(44);
                if (pos1 == -1) {
                    return null;
                }
                String on_oid = nameValue.substring(pos0 + 1, pos1).trim();
                String on_value = nameValue.substring(pos1 + 1).trim();
                if (this.isValidOID(on_oid)) {
                    return new OtherName(new ObjectIdentifier(on_oid), 30, on_value);
                }
                return null;
            }
            if (nameValue.startsWith("(Any)")) {
                int pos0 = nameValue.indexOf(41);
                int pos1 = nameValue.indexOf(44);
                if (pos1 == -1) {
                    return null;
                }
                String on_oid = nameValue.substring(pos0 + 1, pos1).trim();
                String on_value = nameValue.substring(pos1 + 1).trim();
                if (this.isValidOID(on_oid)) {
                    logger.debug("OID: " + on_oid + " Value:" + on_value);
                    return new OtherName(new ObjectIdentifier(on_oid), this.getBytes(on_value));
                }
                logger.error("Invalid OID: " + on_oid);
                return null;
            }
            return null;
        }
        return null;
    }

    public byte[] getBytes(String string) {
        if (string == null) {
            return null;
        }
        int stringLength = string.length();
        if (stringLength == 0 || stringLength % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[stringLength / 2];
        int i = 0;
        int b = 0;
        while (i < stringLength) {
            String nextByte = string.substring(i, i + 2);
            bytes[b] = (byte)Integer.parseInt(nextByte, 16);
            i += 2;
            ++b;
        }
        return bytes;
    }

    public boolean isValidOID(String oid) {
        ObjectIdentifier v = null;
        try {
            v = ObjectIdentifier.getObjectIdentifier((String)oid);
        }
        catch (Exception e) {
            return false;
        }
        if (v == null) {
            return false;
        }
        try (DerOutputStream derOut = new DerOutputStream();){
            derOut.putOID(v);
            new ObjectIdentifier(new DerInputStream(derOut.toByteArray()));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static String buildRecords(Vector<NameValuePairs> recs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < recs.size(); ++i) {
            NameValuePairs pairs = recs.elementAt(i);
            sb.append("Record #");
            sb.append(i);
            sb.append("\r\n");
            for (String key : pairs.keySet()) {
                String val = (String)pairs.get((Object)key);
                sb.append(key);
                sb.append(":");
                sb.append(val);
                sb.append("\r\n");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    protected Vector<NameValuePairs> parseRecords(String value) throws EPropertyException {
        StringTokenizer st = new StringTokenizer(value, "\r\n");
        int num = 0;
        Vector<NameValuePairs> v = new Vector<NameValuePairs>();
        NameValuePairs nvps = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("Record #" + num)) {
                logger.debug("parseRecords: Record" + num);
                nvps = new NameValuePairs();
                v.addElement(nvps);
                try {
                    token = st.nextToken();
                }
                catch (NoSuchElementException e) {
                    v.removeElementAt(num);
                    logger.warn("EnrollDefault: " + e.getMessage());
                    return v;
                }
                ++num;
            }
            if (nvps == null) {
                throw new EPropertyException("Bad Input Format");
            }
            int pos = token.indexOf(":");
            if (pos <= 0) {
                logger.error("Missing colon");
                throw new EPropertyException("Missing colon");
            }
            if (pos == token.length() - 1) {
                nvps.put((Object)token.substring(0, pos), (Object)"");
                continue;
            }
            nvps.put((Object)token.substring(0, pos), (Object)token.substring(pos + 1));
        }
        return v;
    }

    protected static String getGeneralNameType(GeneralName gn) throws EPropertyException {
        int type = gn.getType();
        if (type == 1) {
            return GN_RFC822_NAME;
        }
        if (type == 2) {
            return GN_DNS_NAME;
        }
        if (type == 6) {
            return GN_URI_NAME;
        }
        if (type == 7) {
            return "IPAddress";
        }
        if (type == 4) {
            return GN_DIRECTORY_NAME;
        }
        if (type == 5) {
            return GN_EDI_NAME;
        }
        if (type == 0) {
            return GN_ANY_NAME;
        }
        if (type == 8) {
            return GN_OID_NAME;
        }
        throw new EPropertyException("Unsupported type: " + type);
    }

    protected static String getGeneralNameValue(GeneralName gn) throws EPropertyException {
        String s = gn.toString();
        int type = gn.getType();
        if (type == 4) {
            return s;
        }
        int pos = s.indexOf(":");
        if (pos <= 0) {
            throw new EPropertyException("Badly formatted general name: " + s);
        }
        return s.substring(pos + 1).trim();
    }

    public Locale getLocale(Request request) {
        Locale locale = null;
        if (request == null) {
            return null;
        }
        String language = request.getExtDataInString("req_locale");
        if (language != null) {
            locale = new Locale(language);
        }
        return locale;
    }

    public String toGeneralNameString(GeneralNameInterface gn) {
        int type = gn.getType();
        if (type == 4) {
            return "DirectoryName: " + gn.toString();
        }
        return gn.toString();
    }

    protected String mapPattern(Request request, String pattern) throws IOException {
        Pattern p = new Pattern(pattern);
        IAttrSet attrSet = null;
        if (request != null) {
            attrSet = request.asIAttrSet();
        }
        return p.substitute2("request", attrSet);
    }

    public X509CertImpl getSigningCert() throws EBaseException, NotInitializedException, TokenException, CertificateException {
        return this.getSigningCert(null);
    }

    public X509CertImpl getSigningCert(String authorityID) throws EBaseException, NotInitializedException, TokenException, CertificateException {
        CAEngine engine = CAEngine.getInstance();
        if (engine == null) {
            logger.info("Getting signing cert from CA config");
            CAConfig caConfig = this.engineConfig.getCAConfig();
            SigningUnitConfig signingUnitConfig = caConfig.getSigningUnitConfig();
            String fullName = signingUnitConfig.getFullName();
            try {
                CryptoManager cm = CryptoManager.getInstance();
                X509Certificate cert = cm.findCertByNickname(fullName);
                return new X509CertImpl(cert.getEncoded());
            }
            catch (ObjectNotFoundException e) {
                logger.info("Signing cert does not exist: " + fullName);
                return null;
            }
        }
        if (authorityID == null) {
            logger.info("Getting signing cert from host CA");
            CertificateAuthority ca = engine.getCA();
            if (ca == null) {
                throw new EProfileException("Unable to find host CA");
            }
            CASigningUnit signingUnit = ca.getSigningUnit();
            if (signingUnit == null) {
                logger.warn("Unable to find signing unit of host CA");
                return null;
            }
            return signingUnit.getCertImpl();
        }
        logger.info("Getting signing cert from CA " + authorityID);
        CertificateAuthority ca = engine.getCA(new AuthorityID(authorityID));
        if (ca == null) {
            throw new EProfileException("Unable to find CA " + authorityID);
        }
        CASigningUnit signingUnit = ca.getSigningUnit();
        if (signingUnit == null) {
            logger.warn("Unable to find signing unit of CA " + authorityID);
            return null;
        }
        return signingUnit.getCertImpl();
    }
}

