/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.listeners;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.listeners.EListenersException;
import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cms.notification.MailNotification;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.notification.EmailFormProcessor;
import com.netscape.cmscore.notification.EmailTemplate;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Hashtable;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInQListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(RequestInQListener.class);
    protected static final String PROP_ENABLED = "enabled";
    protected static final String PROP_SENDER_EMAIL = "senderEmail";
    protected static final String PROP_RECVR_EMAIL = "recipientEmail";
    public static final String PROP_EMAIL_TEMPLATE = "emailTemplate";
    protected static final String PROP_EMAIL_SUBJECT = "emailSubject";
    protected static final String PROP_NOTIFY_SUBSTORE = "notification";
    protected static final String PROP_REQ_IN_Q_SUBSTORE = "requestInQ";
    private boolean mEnabled = false;
    private String mSenderEmail = null;
    private String mRecipientEmail = null;
    private String mEmailSubject = null;
    private String mFormPath = null;
    private ConfigStore mConfig;
    private Hashtable<String, Object> mContentParams = new Hashtable();
    private String mId = "RequestInQListener";
    private CertificateAuthority mSubsystem = null;
    private String mHttpHost = null;
    private String mAgentPort = null;

    public void init(Subsystem sub, ConfigStore config) throws EListenersException, EPropertyNotFound, EBaseException {
        logger.info("RequestInQListener: Initializing RequestInQListener");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mSubsystem = (CertificateAuthority)sub;
        this.mConfig = this.mSubsystem.getConfigStore();
        ConfigStore nc = this.mConfig.getSubStore(PROP_NOTIFY_SUBSTORE, ConfigStore.class);
        ConfigStore rq = nc.getSubStore(PROP_REQ_IN_Q_SUBSTORE, ConfigStore.class);
        this.mEnabled = rq.getBoolean(PROP_ENABLED, false);
        logger.info("RequestInQListener: - enabled: " + this.mEnabled);
        this.mSenderEmail = rq.getString(PROP_SENDER_EMAIL);
        logger.info("RequestInQListener: - sender email: " + this.mSenderEmail);
        if (this.mSenderEmail == null) {
            throw new EListenersException(CMS.getLogMessage((String)"NO_NOTIFY_SENDER_EMAIL_CONFIG_FOUND", (Object[])new Object[0]));
        }
        this.mRecipientEmail = rq.getString(PROP_RECVR_EMAIL);
        logger.info("RequestInQListener: - recipient email: " + this.mRecipientEmail);
        if (this.mRecipientEmail == null) {
            throw new EListenersException(CMS.getLogMessage((String)"NO_NOTIFY_RECVR_EMAIL_CONFIG_FOUND", (Object[])new Object[0]));
        }
        this.mEmailSubject = rq.getString(PROP_EMAIL_SUBJECT);
        if (this.mEmailSubject == null) {
            this.mEmailSubject = "Request in Queue";
        }
        logger.info("RequestInQListener: - email subject: " + this.mEmailSubject);
        this.mFormPath = rq.getString(PROP_EMAIL_TEMPLATE);
        logger.info("RequestInQListener: - email template: " + this.mFormPath);
        this.mHttpHost = cs.getHostname();
        this.mAgentPort = engine.getAgentPort();
        if (this.mAgentPort == null) {
            logger.error(CMS.getLogMessage((String)"LISTENERS_REQUEST_PORT_NOT_FOUND", (Object[])new Object[0]));
        } else {
            logger.debug("RequestInQuListener: agentport = " + this.mAgentPort);
        }
        engine.registerPendingListener(this);
    }

    public void accept(Request r) {
        logger.info("RequestInQListener: Accepting request " + r.getRequestId().toHexString());
        if (!this.mEnabled) {
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        MailNotification mn = engine.getMailNotification();
        mn.setFrom(this.mSenderEmail);
        mn.setTo(this.mRecipientEmail);
        mn.setSubject(this.mEmailSubject + " (request id: " + r.getRequestId().toHexString() + ")");
        EmailTemplate template = new EmailTemplate(this.mFormPath);
        if (!template.init()) {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_TEMPLATE_NOT_INIT", (Object[])new Object[0]));
            return;
        }
        this.buildContentParams(r);
        EmailFormProcessor et = new EmailFormProcessor();
        String c = et.getEmailContent(template.toString(), this.mContentParams);
        if (template.isHTML()) {
            mn.setContentType("text/html");
        }
        mn.setContent(c);
        logger.info("RequestInQListener: Sending notification to " + this.mRecipientEmail);
        try {
            mn.sendNotification();
        }
        catch (ENotificationException e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"LISTENERS_SEND_FAILED", (Object[])new Object[]{e.toString()}));
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_SEND_FAILED", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
    }

    private void buildContentParams(Request r) {
        this.mContentParams.clear();
        this.mContentParams.put("InstanceID", this.mConfig.getName());
        String val = null;
        String profileId = r.getExtDataInString("profileId");
        if (profileId == null) {
            val = r.getExtDataInString("HTTP_PARAMS", "csrRequestorEmail");
        } else {
            val = r.getExtDataInString("requestor_email");
            if (val == null || val.compareTo("") == 0) {
                val = r.getExtDataInString("sn_e");
            }
        }
        if (val != null) {
            this.mContentParams.put("RequestorEmail", val);
        }
        if ((val = profileId == null ? r.getExtDataInString("HTTP_PARAMS", "certType") : profileId) != null) {
            this.mContentParams.put("CertType", val);
        }
        RequestId reqId = r.getRequestId();
        this.mContentParams.put("RequestId", reqId.toHexString());
        this.mContentParams.put("InstanceID", this.mId);
        val = r.getRequestType();
        if (val != null) {
            this.mContentParams.put("RequestType", val);
        }
        this.mContentParams.put("HttpHost", this.mHttpHost);
        this.mContentParams.put("HttpPort", this.mAgentPort);
        this.mContentParams.put("SenderEmail", this.mSenderEmail);
        this.mContentParams.put("RecipientEmail", this.mRecipientEmail);
    }

    public void set(String name, String val) {
        if (name.equalsIgnoreCase(PROP_ENABLED)) {
            this.mEnabled = val.equalsIgnoreCase("true");
        } else if (name.equalsIgnoreCase(PROP_SENDER_EMAIL)) {
            this.mSenderEmail = val;
        } else if (name.equalsIgnoreCase(PROP_RECVR_EMAIL)) {
            this.mRecipientEmail = val;
        } else if (name.equalsIgnoreCase(PROP_EMAIL_SUBJECT)) {
            this.mEmailSubject = val;
        } else if (name.equalsIgnoreCase(PROP_EMAIL_TEMPLATE)) {
            this.mFormPath = val;
        } else {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_SET", (Object[])new Object[0]));
        }
    }
}

