/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.math.BigInteger;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemRangeUpdateCLI
extends SubsystemCLI {
    public static final Logger logger = LoggerFactory.getLogger(SubsystemRangeUpdateCLI.class);

    public SubsystemRangeUpdateCLI(CLI parent) {
        super("update", "Update " + parent.getParent().getName().toUpperCase() + " ranges", parent);
    }

    public void createOptions() {
        Option option = new Option("d", true, "NSS database location");
        option.setArgName("database");
        this.options.addOption(option);
        option = new Option("f", true, "NSS database password configuration");
        option.setArgName("password config");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        this.initializeTomcatJSS();
        String subsystem = this.parent.getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        String baseDN = ldapConfig.getBaseDN();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LdapAuthInfo authInfo = this.getAuthInfo(passwordStore, connInfo, ldapConfig);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setSecure(connInfo.getSecure());
        if (authInfo.getAuthType() == 2) {
            socketFactory.setClientCertNickname(authInfo.getClientCertNickname());
        }
        socketFactory.init(socketConfig);
        DatabaseConfig dbConfig = cs.getDatabaseConfig();
        this.updateSerialNumberRange(socketFactory, connInfo, authInfo, dbConfig, baseDN);
        this.updateRequestNumberRange(socketFactory, connInfo, authInfo, dbConfig, baseDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSerialNumberRange(PKISocketFactory socketFactory, LdapConnInfo connInfo, LdapAuthInfo authInfo, DatabaseConfig dbConfig, String baseDN) throws Exception {
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        try {
            BigInteger endSerialNumber = new BigInteger(dbConfig.getEndSerialNumber());
            BigInteger nextSerialNumber = endSerialNumber.add(BigInteger.ONE);
            String serialDN = dbConfig.getSerialDN() + "," + baseDN;
            LDAPAttribute attrSerialNextRange = new LDAPAttribute("nextRange", nextSerialNumber.toString());
            LDAPModification serialmod = new LDAPModification(2, attrSerialNextRange);
            conn.modify(serialDN, serialmod);
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRequestNumberRange(PKISocketFactory socketFactory, LdapConnInfo connInfo, LdapAuthInfo authInfo, DatabaseConfig dbConfig, String baseDN) throws Exception {
        String value = dbConfig.getString("request.id.generator", "legacy");
        Repository.IDGenerator idGenerator = Repository.IDGenerator.fromString(value);
        if (idGenerator != Repository.IDGenerator.LEGACY) {
            logger.info("No need to update request ID range");
            return;
        }
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        try {
            logger.info("Updating request ID range");
            BigInteger endRequestNumber = new BigInteger(dbConfig.getEndRequestNumber());
            BigInteger nextRequestNumber = endRequestNumber.add(BigInteger.ONE);
            String requestDN = dbConfig.getRequestDN() + "," + baseDN;
            LDAPAttribute attrRequestNextRange = new LDAPAttribute("nextRange", nextRequestNumber.toString());
            LDAPModification requestmod = new LDAPModification(2, attrRequestNextRange);
            conn.modify(requestDN, requestmod);
        }
        finally {
            conn.disconnect();
        }
    }
}

