/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.request.IRequestVirtualList;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.dbs.RepositoryRecord;
import com.netscape.cmscore.request.ListEnumeration;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestRecord;
import com.netscape.cmscore.request.SearchEnumeration;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestRepository
extends Repository {
    public static Logger logger = LoggerFactory.getLogger(RequestRepository.class);
    public static final String PROP_REQUEST_ID_GENERATOR = "request.id.generator";
    public static final String DEFAULT_REQUEST_ID_GENERATOR = "legacy";
    public static final String PROP_REQUEST_ID_LENGTH = "request.id.length";
    protected String filter;

    public RequestRepository(SecureRandom secureRandom, DBSubsystem dbSubsystem, String filter) {
        super(dbSubsystem, 10);
        this.secureRandom = secureRandom;
        this.filter = filter;
    }

    @Override
    public void init() throws Exception {
        logger.debug("RequestRepository: Initializing request repository");
        logger.debug("RequestRepository: - filter: " + this.filter);
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        this.mBaseDN = dbConfig.getRequestDN() + "," + this.dbSubsystem.getBaseDN();
        logger.debug("RequestRepository: - base DN: " + this.mBaseDN);
        String value = dbConfig.getString(PROP_REQUEST_ID_GENERATOR, DEFAULT_REQUEST_ID_GENERATOR);
        logger.debug("RequestRepository: - request ID generator: " + value);
        this.setIDGenerator(value);
        if (this.idGenerator == Repository.IDGenerator.RANDOM) {
            this.idLength = dbConfig.getInteger(PROP_REQUEST_ID_LENGTH);
            logger.debug("RequestRepository: - request ID length: " + this.idLength);
        } else {
            this.initLegacyGenerator();
        }
        RequestRecord.register(this.dbSubsystem);
    }

    public void initLegacyGenerator() throws Exception {
        String incrementNo;
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        this.rangeDN = dbConfig.getRequestRangeDN() + "," + this.dbSubsystem.getBaseDN();
        logger.debug("RequestRepository: - range DN: " + this.rangeDN);
        this.minSerialName = "beginRequestNumber";
        String minSerial = dbConfig.getBeginRequestNumber();
        if (minSerial != null) {
            this.mMinSerialNo = new BigInteger(minSerial, this.mRadix);
        }
        logger.debug("RequestRepository: - min serial: " + this.mMinSerialNo);
        this.maxSerialName = "endRequestNumber";
        String maxSerial = dbConfig.getEndRequestNumber();
        if (maxSerial != null) {
            this.mMaxSerialNo = new BigInteger(maxSerial, this.mRadix);
        }
        logger.debug("RequestRepository: - max serial: " + this.mMaxSerialNo);
        this.nextMinSerialName = "nextBeginRequestNumber";
        String nextMinSerial = dbConfig.getNextBeginRequestNumber();
        this.mNextMinSerialNo = nextMinSerial == null || nextMinSerial.equals("-1") ? null : new BigInteger(nextMinSerial, this.mRadix);
        logger.debug("RequestRepository: - next min serial: " + this.mNextMinSerialNo);
        this.nextMaxSerialName = "nextEndRequestNumber";
        String nextMaxSerial = dbConfig.getNextEndRequestNumber();
        this.mNextMaxSerialNo = nextMaxSerial == null || nextMaxSerial.equals("-1") ? null : new BigInteger(nextMaxSerial, this.mRadix);
        logger.debug("RequestRepository: - next max serial: " + this.mNextMaxSerialNo);
        String lowWaterMark = dbConfig.getRequestLowWaterMark();
        if (lowWaterMark != null) {
            this.mLowWaterMarkNo = new BigInteger(lowWaterMark, this.mRadix);
        }
        if ((incrementNo = dbConfig.getRequestIncrement()) != null) {
            this.mIncrementNo = new BigInteger(incrementNo, this.mRadix);
        }
    }

    public void init(Hashtable<String, String> repositoryConfig) throws Exception {
        this.repositoryConfig = repositoryConfig;
        RequestRecord.register(this.dbSubsystem);
    }

    public RequestId createRequestID() throws EBaseException {
        BigInteger nextSerialNumber = this.getNextSerialNumber();
        return new RequestId(nextSerialNumber);
    }

    public Request createRequest(RequestId requestID, String requestType) throws EBaseException {
        if (requestType == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_REQUEST_TYPE", "null"));
        }
        Request request = new Request(requestID);
        request.setRequestType(requestType);
        request.setExtData("requestVersion", "1.0.0");
        request.setExtData("dbStatus", "NOT_UPDATED");
        request.setExtData("requestId", requestID.toString());
        return request;
    }

    public Request createRequest(String requestType) throws EBaseException {
        RequestId requestID = this.createRequestID();
        return this.createRequest(requestID, requestType);
    }

    public void addRequest(Request request) throws EBaseException {
        Set<String> excludedLdapAttrs = this.dbSubsystem.getExcludedLdapAttr();
        RequestRecord requestRecord = new RequestRecord();
        requestRecord.add(request, excludedLdapAttrs);
        try (DBSSession dbs = this.dbSubsystem.createSession();){
            String dn = "cn=" + requestRecord.mRequestId + "," + this.mBaseDN;
            dbs.add(dn, requestRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request readRequest(RequestId id) throws EBaseException {
        RequestRecord record;
        String name = "cn=" + id + "," + this.mBaseDN;
        try (DBSSession dbs = this.dbSubsystem.createSession();){
            record = (RequestRecord)dbs.read(name);
        }
        return record.toRequest();
    }

    public String getUserIdentity() {
        SessionContext s = SessionContext.getContext();
        return (String)s.get((Object)"userid");
    }

    public void updateRequest(Request request) throws EBaseException {
        String name = this.getUserIdentity();
        if (name != null) {
            request.setExtData("updatedBy", name);
        }
        String delayLDAPCommit = request.getExtDataInString("delayLDAPCommit");
        request.mModificationTime = new Date();
        if (delayLDAPCommit != null && delayLDAPCommit.equals("true")) {
            return;
        }
        String dbStatus = request.getExtDataInString("dbStatus");
        if (dbStatus.equals("UPDATED")) {
            this.modifyRequest(request);
            return;
        }
        request.setExtData("dbStatus", "UPDATED");
        this.addRequest(request);
    }

    public void modifyRequest(Request request) throws EBaseException {
        Set<String> excludedLdapAttrs = this.dbSubsystem.getExcludedLdapAttr();
        ModificationSet mods = new ModificationSet();
        RequestRecord.mod(mods, request, excludedLdapAttrs);
        try (DBSSession dbs = this.dbSubsystem.createSession();){
            String dn = "cn=" + request.getRequestId() + "," + this.mBaseDN;
            dbs.modify(dn, mods);
        }
    }

    public void removeRequest(RequestId requestID) throws EBaseException {
        try (DBSSession dbs = this.dbSubsystem.createSession();){
            String name = "cn=" + requestID + "," + this.mBaseDN;
            dbs.delete(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllObjects() throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search(this.mBaseDN, "(requestId=*)");
            while (sr.hasMoreElements()) {
                RequestRecord r = (RequestRecord)sr.nextElement();
                String name = "cn=" + r.getRequestId() + "," + this.mBaseDN;
                s.delete(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestList listRequestsByFilter(String filter) throws EBaseException {
        DBSearchResults results = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            results = s.search(this.mBaseDN, filter);
        }
        if (results == null) {
            return null;
        }
        return new SearchEnumeration(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestList listRequestsByFilter(String filter, int maxSize) throws EBaseException {
        DBSearchResults results = null;
        try (DBSSession dbs = this.dbSubsystem.createSession();){
            results = dbs.search(this.mBaseDN, filter, maxSize);
        }
        if (results == null) {
            return null;
        }
        return new SearchEnumeration(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestList listRequestsByFilter(String filter, int maxSize, int timeLimit) throws EBaseException {
        DBSearchResults results = null;
        try (DBSSession dbs = this.dbSubsystem.createSession();){
            results = dbs.search(this.mBaseDN, filter, maxSize, timeLimit);
        }
        if (results == null) {
            return null;
        }
        return new SearchEnumeration(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRequestVirtualList getPagedRequestsByFilter(RequestId fromID, boolean jumpToEnd, String filter, int pageSize, String sortKey) throws EBaseException {
        DBVirtualList<IDBObj> results;
        try (DBSSession session = this.dbSubsystem.createSession();){
            if (fromID == null) {
                results = session.createVirtualList(this.mBaseDN, filter, (String[])null, sortKey, pageSize);
            } else {
                int length;
                Object internalRequestID = jumpToEnd ? "99" : ((length = fromID.toString().length()) > 9 ? "" + length + fromID : "0" + length + fromID);
                results = session.createVirtualList(this.mBaseDN, filter, null, (String)internalRequestID, sortKey, pageSize);
            }
        }
        results.setSortKey(sortKey);
        return new ListEnumeration(results);
    }

    @Override
    public BigInteger getLastSerialNumberInRange(BigInteger min, BigInteger max) throws EBaseException {
        logger.debug("RequestRepository: Getting last serial number in range");
        logger.debug("RequestRepository: - min: " + min);
        logger.debug("RequestRepository: - max: " + max);
        if (min == null || max == null || min.compareTo(max) >= 0) {
            logger.warn("RequestRepository: Bad upper and lower bound range");
            return null;
        }
        RequestId fromID = new RequestId(max);
        logger.debug("RequestRepository: - from ID: " + fromID);
        logger.debug("RequestRepository: Searching for requests");
        ListEnumeration recList = (ListEnumeration)this.getPagedRequestsByFilter(fromID, false, this.filter, -5, "requestId");
        int size = recList.getSize();
        logger.debug("RequestRepository: - size: " + size);
        int ltSize = recList.getSizeBeforeJumpTo();
        logger.debug("RequestRepository: - size before jump: " + ltSize);
        if (size <= 0) {
            BigInteger requestID = min.subtract(BigInteger.ONE);
            logger.debug("RequestRepository: There are no requests, returning " + requestID);
            return requestID;
        }
        logger.debug("RequestRepository: Requests:");
        for (int i = 0; i < 5; ++i) {
            Request request = recList.getElementAt(i);
            if (request == null) continue;
            BigInteger requestID = request.getRequestId().toBigInteger();
            logger.debug("RequestRepository: - request ID: " + requestID);
            if (requestID.compareTo(min) < 0 || requestID.compareTo(max) > 0) continue;
            logger.debug("RequestRepository: Found last request ID: " + requestID);
            return requestID;
        }
        BigInteger requestID = min.subtract(BigInteger.ONE);
        logger.debug("RequestRepository: No request found, returning " + requestID);
        return requestID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublishingStatus() {
        RepositoryRecord record = null;
        IDBObj obj = null;
        DBSSession dbs = null;
        String status = null;
        try {
            dbs = this.dbSubsystem.createSession();
            obj = dbs.read(this.mBaseDN);
        }
        catch (Exception e) {
            logger.error("RequestRepository:  getPublishingStatus:  Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (dbs != null) {
                try {
                    dbs.close();
                }
                catch (Exception ex) {
                    logger.warn("RequestRepository:  getPublishingStatus:  Error: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (obj != null && obj instanceof RepositoryRecord) {
            record = (RepositoryRecord)obj;
            status = record.getPublishingStatus();
        } else {
            logger.debug("RequestRepository:  obj is NOT instanceof RepositoryRecord");
        }
        logger.debug("RequestRepository:  getPublishingStatus  mBaseDN: " + this.mBaseDN + "  status: " + (status != null ? status : "null"));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublishingStatus(String status) {
        DBSSession dbs = null;
        logger.debug("RequestRepository:  setPublishingStatus  mBaseDN: " + this.mBaseDN + "  status: " + status);
        ModificationSet mods = new ModificationSet();
        if (status != null && status.length() > 0) {
            mods.add("publishingStatus", 2, (Object)status);
            try {
                dbs = this.dbSubsystem.createSession();
                dbs.modify(this.mBaseDN, mods);
            }
            catch (Exception e) {
                logger.error("RequestRepository:  setPublishingStatus:  Error: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (dbs != null) {
                    try {
                        dbs.close();
                    }
                    catch (Exception ex) {
                        logger.warn("RequestRepository:  setPublishingStatus:  Error: " + ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
    }
}

