/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.dbs.DBRegistry;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.DateMapper;
import com.netscape.cmscore.dbs.StringMapper;
import com.netscape.cmscore.request.ExtAttrDynMapper;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestAttr;
import com.netscape.cmscore.request.RequestIdMapper;
import com.netscape.cmscore.request.RequestStateMapper;
import com.netscape.cmscore.request.RequestType;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestRecord
implements IDBObj {
    public static Logger logger = LoggerFactory.getLogger(RequestRecord.class);
    public static final String ATTR_REQUEST_ID = "requestId";
    public static final String ATTR_REQUEST_STATE = "requestState";
    public static final String ATTR_CREATE_TIME = "requestCreateTime";
    public static final String ATTR_MODIFY_TIME = "requestModifyTime";
    public static final String ATTR_SOURCE_ID = "requestSourceId";
    public static final String ATTR_REQUEST_OWNER = "requestOwner";
    public static final String ATTR_REQUEST_TYPE = "requestType";
    public static final String ATTR_EXT_DATA = "requestExtData";
    public static final String ATTR_REALM = "realm";
    RequestId mRequestId;
    RequestStatus mRequestState;
    Date mCreateTime;
    Date mModifyTime;
    String mSourceId;
    String mOwner;
    String mRequestType;
    Hashtable<String, Object> mExtData;
    String realm;
    protected static final String[] mOC = new String[]{"top", "request", "extensibleObject"};
    protected static Vector<String> mAttrs = new Vector();
    static Hashtable<String, RequestAttr> mAttrTable = new Hashtable();
    static RequestAttr[] mRequestA = new RequestAttr[]{new RequestType()};

    public RequestId getRequestId() {
        return this.mRequestId;
    }

    public Enumeration<String> getAttrNames() {
        return mAttrTable.keys();
    }

    public Object get(String name) {
        if (name.equals(ATTR_REQUEST_ID)) {
            return this.mRequestId;
        }
        if (name.equals(ATTR_REQUEST_STATE)) {
            return this.mRequestState;
        }
        if (name.equals(ATTR_REQUEST_TYPE)) {
            return this.mRequestType;
        }
        if (name.equals(ATTR_MODIFY_TIME)) {
            return this.mModifyTime;
        }
        if (name.equals(ATTR_CREATE_TIME)) {
            return this.mCreateTime;
        }
        if (name.equals(ATTR_SOURCE_ID)) {
            return this.mSourceId;
        }
        if (name.equals(ATTR_REQUEST_OWNER)) {
            return this.mOwner;
        }
        if (name.equals(ATTR_EXT_DATA)) {
            return this.mExtData;
        }
        if (name.equals(ATTR_REALM)) {
            return this.realm;
        }
        RequestAttr ra = mAttrTable.get(name);
        if (ra != null) {
            return ra.get(this);
        }
        return null;
    }

    public void set(String name, Object o) {
        if (name.equals(ATTR_REQUEST_ID)) {
            this.mRequestId = (RequestId)o;
        } else if (name.equals(ATTR_REQUEST_STATE)) {
            this.mRequestState = (RequestStatus)o;
        } else if (name.equals(ATTR_REQUEST_TYPE)) {
            this.mRequestType = (String)o;
        } else if (name.equals(ATTR_CREATE_TIME)) {
            this.mCreateTime = (Date)o;
        } else if (name.equals(ATTR_MODIFY_TIME)) {
            this.mModifyTime = (Date)o;
        } else if (name.equals(ATTR_SOURCE_ID)) {
            this.mSourceId = (String)o;
        } else if (name.equals(ATTR_REQUEST_OWNER)) {
            this.mOwner = (String)o;
        } else if (name.equals(ATTR_REALM)) {
            this.realm = (String)o;
        } else if (name.equals(ATTR_EXT_DATA)) {
            this.mExtData = (Hashtable)o;
        } else {
            RequestAttr ra = mAttrTable.get(name);
            if (ra != null) {
                ra.set(this, o);
            }
        }
    }

    public void delete(String name) throws EBaseException {
        throw new EBaseException("Invalid call to delete");
    }

    public Enumeration<String> getElements() {
        return mAttrs.elements();
    }

    @Override
    public Enumeration<String> getSerializableAttrNames() {
        return mAttrs.elements();
    }

    void add(Request r) throws EBaseException {
        this.add(r, null);
    }

    void add(Request r, Set<String> excludedLdapAttrs) throws EBaseException {
        this.mRequestId = r.getRequestId();
        this.mRequestType = r.getRequestType();
        this.mRequestState = r.getRequestStatus();
        this.mSourceId = r.getSourceId();
        this.mOwner = r.getRequestOwner();
        this.mCreateTime = r.getCreationTime();
        this.mModifyTime = r.getModificationTime();
        this.realm = r.getRealm();
        this.mExtData = RequestRecord.loadExtDataFromRequest(r, excludedLdapAttrs);
        for (int i = 0; i < mRequestA.length; ++i) {
            mRequestA[i].add(r, this);
        }
    }

    void read(Request r) throws EBaseException {
        r.setRequestStatus(this.mRequestState);
        r.setSourceId(this.mSourceId);
        r.setRequestOwner(this.mOwner);
        r.setModificationTime(this.mModifyTime);
        r.setCreationTime(this.mCreateTime);
        r.setRealm(this.realm);
        this.storeExtDataIntoRequest(r);
        for (int i = 0; i < mRequestA.length; ++i) {
            mRequestA[i].read(r, this);
        }
    }

    static void mod(ModificationSet mods, Request r) throws EBaseException {
        RequestRecord.mod(mods, r, null);
    }

    static void mod(ModificationSet mods, Request r, Set<String> excludedLdapAttrs) throws EBaseException {
        mods.add(ATTR_REQUEST_STATE, 2, (Object)r.getRequestStatus());
        mods.add(ATTR_SOURCE_ID, 2, (Object)r.getSourceId());
        mods.add(ATTR_REQUEST_OWNER, 2, (Object)r.getRequestOwner());
        mods.add(ATTR_MODIFY_TIME, 2, (Object)r.getModificationTime());
        mods.add(ATTR_EXT_DATA, 2, RequestRecord.loadExtDataFromRequest(r, excludedLdapAttrs));
        if (r.getRealm() != null) {
            mods.add(ATTR_REALM, 2, (Object)r.getRealm());
        }
        for (int i = 0; i < mRequestA.length; ++i) {
            mRequestA[i].mod(mods, r);
        }
    }

    static void register(DBSubsystem dbSubsystem) throws EDBException {
        DBRegistry reg = dbSubsystem.getRegistry();
        reg.registerObjectClass(RequestRecord.class.getName(), mOC);
        reg.registerAttribute(ATTR_REQUEST_ID, new RequestIdMapper());
        reg.registerAttribute(ATTR_REQUEST_STATE, new RequestStateMapper());
        reg.registerAttribute(ATTR_CREATE_TIME, new DateMapper("dateOfCreate"));
        reg.registerAttribute(ATTR_MODIFY_TIME, new DateMapper("dateOfModify"));
        reg.registerAttribute(ATTR_SOURCE_ID, new StringMapper(ATTR_SOURCE_ID));
        reg.registerAttribute(ATTR_REQUEST_OWNER, new StringMapper(ATTR_REQUEST_OWNER));
        reg.registerAttribute(ATTR_REALM, new StringMapper(ATTR_REALM));
        ExtAttrDynMapper extAttrMapper = new ExtAttrDynMapper();
        reg.registerAttribute(ATTR_EXT_DATA, extAttrMapper);
        reg.registerDynamicMapper(extAttrMapper);
        for (int i = 0; i < mRequestA.length; ++i) {
            RequestAttr ra = mRequestA[i];
            reg.registerAttribute(ra.mAttrName, ra.mMapper);
        }
    }

    protected static Hashtable<String, Object> loadExtDataFromRequest(Request r, Set<String> excludedLdapAttrs) throws EBaseException {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        String reqType = r.getExtDataInString("cert_request_type");
        if (reqType == null || reqType.equals("")) {
            reqType = r.getExtDataInString("auth_token.cert_request_type");
        }
        Enumeration<String> e = r.getExtDataKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (r.isSimpleExtDataValue(key)) {
                String subjectName;
                if (key.equals("req_x509info") && ((subjectName = r.getExtDataInString("req_subject_name")) == null || subjectName.equals(""))) {
                    X509CertInfo info = r.getExtDataInCertInfo("CERT_INFO");
                    logger.debug("RequestRecord.loadExtDataFromRequest: missing subject name. Processing extracting subjectName from req_x509info");
                    try {
                        CertificateSubjectName subjName = (CertificateSubjectName)info.get("subject");
                        if (subjName != null) {
                            logger.debug("RequestRecord.loadExtDataFromRequest: got subjName");
                            h.put("req_subject_name", subjName.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (reqType != null && (reqType.equals("crmf") || reqType.equals("cmc-crmf")) && excludedLdapAttrs != null && excludedLdapAttrs.contains(key)) continue;
                h.put(key, r.getExtDataInString(key));
                continue;
            }
            h.put(key, r.getExtDataInHashtable(key));
        }
        return h;
    }

    protected void storeExtDataIntoRequest(Request r) throws EBaseException {
        Enumeration<String> e = this.mExtData.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object value = this.mExtData.get(key);
            if (value instanceof String) {
                r.setExtData(key, (String)value);
                continue;
            }
            if (value instanceof Hashtable) {
                r.setExtData(key, (Hashtable)value);
                continue;
            }
            throw new EDBException("Illegal data value in RequestRecord: " + r.toString());
        }
    }

    public Request toRequest() throws EBaseException {
        Request record = new Request(this.mRequestId);
        this.read(record);
        return record;
    }

    static {
        mAttrs.add(ATTR_REQUEST_ID);
        mAttrs.add(ATTR_REQUEST_STATE);
        mAttrs.add(ATTR_CREATE_TIME);
        mAttrs.add(ATTR_MODIFY_TIME);
        mAttrs.add(ATTR_SOURCE_ID);
        mAttrs.add(ATTR_REQUEST_OWNER);
        mAttrs.add(ATTR_REALM);
        mAttrs.add(ATTR_EXT_DATA);
        for (int i = 0; i < mRequestA.length; ++i) {
            RequestAttr ra = mRequestA[i];
            mAttrs.add(ra.mAttrName);
            mAttrTable.put(ra.mAttrName, ra);
        }
    }
}

