/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.notification;

import com.netscape.cmscore.apps.CMS;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailFormProcessor {
    public static Logger logger = LoggerFactory.getLogger(EmailFormProcessor.class);
    public static final String TOKEN_ID = "InstanceID";
    public static final String TOKEN_SERIAL_NUM = "SerialNumber";
    public static final String TOKEN_HEX_SERIAL_NUM = "HexSerialNumber";
    public static final String TOKEN_REQUEST_ID = "RequestId";
    public static final String TOKEN_HTTP_HOST = "HttpHost";
    public static final String TOKEN_HTTP_PORT = "HttpPort";
    public static final String TOKEN_ISSUER_DN = "IssuerDN";
    public static final String TOKEN_SUBJECT_DN = "SubjectDN";
    public static final String TOKEN_REQUESTOR_EMAIL = "RequestorEmail";
    public static final String TOKEN_CERT_TYPE = "CertType";
    public static final String TOKEN_REQUEST_TYPE = "RequestType";
    public static final String TOKEN_STATUS = "Status";
    public static final String TOKEN_NOT_AFTER = "NotAfter";
    public static final String TOKEN_NOT_BEFORE = "NotBefore";
    public static final String TOKEN_SENDER_EMAIL = "SenderEmail";
    public static final String TOKEN_RECIPIENT_EMAIL = "RecipientEmail";
    public static final String TOKEN_SUMMARY_ITEM_LIST = "SummaryItemList";
    public static final String TOKEN_SUMMARY_TOTAL_NUM = "SummaryTotalNum";
    public static final String TOKEN_SUMMARY_SUCCESS_NUM = "SummaryTotalSuccess";
    public static final String TOKEN_SUMMARY_FAILURE_NUM = "SummaryTotalFailure";
    public static final String TOKEN_EXECUTION_TIME = "ExecutionTime";
    public static final String TOKEN_REVOCATION_DATE = "RevocationDate";
    protected static final String TOK_PREFIX = "$";
    protected static final String TOK_ESC = "\\";
    protected static final char TOK_END = ' ';
    protected static final String TOK_VALUE_UNKNOWN = "VALUE UNKNOWN";
    protected static final String TOK_TOKEN_UNKNOWN = "UNKNOWN TOKEN:";
    protected static String[] token_keys = new String[]{"InstanceID", "SerialNumber", "HttpHost", "HttpPort", "IssuerDN", "SubjectDN", "RequestorEmail", "CertType", "RequestType", "Status", "NotAfter", "NotBefore", "SenderEmail", "RecipientEmail", "SummaryItemList", "SummaryTotalNum", "SummaryTotalSuccess", "SummaryTotalFailure", "ExecutionTime"};
    Vector<String> mContent = new Vector();
    Hashtable<String, Object> mTok2vals = null;

    public String getEmailContent(String form, Hashtable<String, Object> tok2vals) {
        this.mTok2vals = tok2vals;
        if (form == null) {
            logger.warn(CMS.getLogMessage("CMSCORE_NOTIFY_TEMPLATE_NULL", new Object[0]));
            return null;
        }
        if (this.mTok2vals == null) {
            logger.warn(CMS.getLogMessage("CMSCORE_NOTIFY_TOKEN_NULL", new Object[0]));
            return null;
        }
        StringTokenizer es = new StringTokenizer(form, TOK_ESC);
        if (es.hasMoreTokens() && !form.startsWith(TOK_ESC)) {
            this.dollarProcess(es.nextToken());
        }
        while (es.hasMoreTokens()) {
            String t = es.nextToken();
            char c = t.charAt(0);
            Character ch = Character.valueOf(c);
            this.mContent.add(ch.toString());
            String r = t.substring(1);
            this.dollarProcess(r);
        }
        return this.formContent(this.mContent);
    }

    private void dollarProcess(String sub) {
        StringTokenizer st = new StringTokenizer(sub, TOK_PREFIX);
        if (st.hasMoreTokens() && !sub.startsWith(TOK_PREFIX)) {
            String a = st.nextToken();
            this.mContent.add(a);
        }
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            boolean matched = false;
            String tok = null;
            Enumeration<String> e = this.mTok2vals.keys();
            while (e.hasMoreElements()) {
                String s;
                tok = e.nextElement();
                if (!t.startsWith(tok)) continue;
                Object o = this.mTok2vals.get(tok);
                if (o == null || (s = (String)o).equals("")) break;
                this.mContent.add(s);
                if (t.length() != tok.length()) {
                    this.mContent.add(t.substring(tok.length()));
                }
                matched = true;
                break;
            }
            if (matched) continue;
            boolean keyFound = false;
            for (int i = 0; i < token_keys.length; ++i) {
                if (!t.startsWith(token_keys[i])) continue;
                this.mContent.add(TOK_VALUE_UNKNOWN);
                if (t.length() != token_keys[i].length()) {
                    this.mContent.add(t.substring(token_keys[i].length()));
                }
                keyFound = true;
                break;
            }
            if (keyFound) continue;
            this.mContent.add("UNKNOWN TOKEN:$" + t);
        }
    }

    public String formContent(Vector<String> vec) {
        StringBuffer content = new StringBuffer();
        Enumeration<String> e = vec.elements();
        if (e.hasMoreElements()) {
            content.append(e.nextElement());
        }
        while (e.hasMoreElements()) {
            String v = e.nextElement();
            content.append(v);
        }
        return content.toString();
    }

    public void log(int level, String msg) {
    }
}

