/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.base;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmsutil.ldap.LDAPPostReadControl;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.io.ByteArrayOutputStream;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPConfigStorage
extends ConfigStorage {
    public static Logger logger = LoggerFactory.getLogger(LDAPConfigStorage.class);
    private LDAPConnection conn;
    private String dn;
    private String attr;
    private LDAPAttribute[] createAttrs;

    public LDAPConfigStorage(LDAPConnection conn, String dn, LDAPAttribute[] createAttrs, String attr) throws Exception {
        this.conn = conn;
        this.dn = dn;
        this.createAttrs = createAttrs;
        this.attr = attr;
    }

    @Override
    public void commit(ConfigStore config, boolean createBackup) throws EBaseException {
        String[] attrs = new String[]{};
        this.commitReturn(config, createBackup, attrs);
    }

    public LDAPEntry commitReturn(ConfigStore config, boolean createBackup, String[] attrs) throws EBaseException {
        LDAPControl[] responseControls;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            config.store(data);
        }
        catch (Exception e) {
            throw new EBaseException(e);
        }
        LDAPAttribute configAttr = new LDAPAttribute(this.attr, data.toByteArray());
        LDAPConstraints cons = new LDAPConstraints();
        cons.setServerControls((LDAPControl)new LDAPPostReadControl(true, attrs));
        try {
            try {
                this.commitModify(configAttr, cons);
            }
            catch (LDAPException e) {
                if (e.getLDAPResultCode() == 32) {
                    this.commitAdd(configAttr, cons);
                }
                throw e;
            }
            responseControls = this.conn.getResponseControls();
        }
        catch (LDAPException e) {
            throw new ELdapException("Unable to store " + this.dn + ": " + e, (Throwable)e);
        }
        LDAPPostReadControl control = (LDAPPostReadControl)LDAPUtil.getControl(LDAPPostReadControl.class, (LDAPControl[])responseControls);
        return control.getEntry();
    }

    private void commitModify(LDAPAttribute configAttr, LDAPConstraints cons) throws LDAPException {
        LDAPModification ldapMod = new LDAPModification(2, configAttr);
        this.conn.modify(this.dn, ldapMod, cons);
    }

    private void commitAdd(LDAPAttribute configAttr, LDAPConstraints cons) throws LDAPException {
        LDAPAttributeSet attrSet = new LDAPAttributeSet(this.createAttrs);
        attrSet.add(configAttr);
        LDAPEntry ldapEntry = new LDAPEntry(this.dn, attrSet);
        this.conn.add(ldapEntry, cons);
    }
}

