/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.base;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotDefined;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.SimpleProperties;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.util.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStore
implements Cloneable {
    public static final Logger logger = LoggerFactory.getLogger(ConfigStore.class);
    protected static final String PROP_SUBSTORES = "substores";
    protected String mStoreName;
    protected SimpleProperties mSource;
    protected ConfigStorage storage;

    public ConfigStore() {
        this.mSource = new SimpleProperties();
    }

    public ConfigStore(ConfigStorage storage) {
        this.mSource = new SimpleProperties();
        this.storage = storage;
    }

    public ConfigStore(String storeName) {
        this.mSource = new SimpleProperties();
        this.mStoreName = storeName;
    }

    protected ConfigStore(String name, SimpleProperties source) {
        this.mStoreName = name;
        this.mSource = source;
    }

    public String getName() {
        return this.mStoreName;
    }

    public ConfigStorage getStorage() {
        return this.storage;
    }

    public String get(String name) {
        return (String)this.mSource.get(this.getFullName(name));
    }

    private String nakedGet(String name) {
        return (String)this.mSource.get(name);
    }

    public String put(String name, String value) {
        String property = this.getFullName(name);
        logger.debug("Setting " + property + "=" + value);
        return this.mSource.put(property, value);
    }

    public void remove(String name) {
        this.mSource.remove(this.getFullName(name));
    }

    public Enumeration<String> keys() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        this.enumerate(h);
        return h.keys();
    }

    public Map<String, String> getProperties() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        this.enumerate(map);
        return map;
    }

    public int size() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        this.enumerate(h);
        return h.size();
    }

    private synchronized void enumerate(Map<String, String> map) {
        Enumeration e = this.mSource.keys();
        String fullName = this.getFullName("");
        int kIndex = fullName.length();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(fullName)) continue;
            map.put(key.substring(kIndex), this.nakedGet(key));
        }
    }

    public synchronized void clear() {
        this.mSource.clear();
    }

    public void load() throws Exception {
        if (this.storage != null) {
            this.storage.load(this);
        }
    }

    public void commit(boolean createBackup) throws EBaseException {
        if (this.storage != null) {
            this.storage.commit(this, createBackup);
        }
    }

    public synchronized void load(InputStream in) throws IOException {
        this.mSource.load(in);
    }

    public synchronized void store(OutputStream out) throws Exception {
        try (PrintWriter pw = new PrintWriter(out);){
            Map<String, String> map = this.getProperties();
            for (String name : map.keySet()) {
                String value = map.get(name);
                pw.println(name + "=" + value);
            }
        }
    }

    public String getString(String name) throws EBaseException {
        String str = this.get(name);
        if (str == null) {
            logger.trace("Property {} not found", (Object)this.getFullName(name));
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", this.getFullName(name)));
        }
        String ret = null;
        try {
            ret = new String(str.getBytes(), "UTF8").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_UTF8_NOT_SUPPORTED", new String[0]));
        }
        logger.trace("Getting {}={}", (Object)this.getFullName(name), (Object)ret);
        return ret;
    }

    public String getString(String name, String defval) throws EBaseException {
        String val;
        try {
            val = this.getString(name);
        }
        catch (EPropertyNotFound e) {
            val = defval;
        }
        logger.trace("Getting {}={}", (Object)this.getFullName(name), (Object)val);
        return val;
    }

    public void putString(String name, String value) {
        this.put(name, value);
    }

    public byte[] getByteArray(String name) throws EBaseException {
        byte[] arr = this.getByteArray(name, new byte[0]);
        if (arr.length == 0) {
            logger.trace("Property {} not found", (Object)this.getFullName(name));
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", this.getName() + "." + name));
        }
        return arr;
    }

    public byte[] getByteArray(String name, byte[] defval) throws EBaseException {
        String str = this.get(name);
        byte[] value = str == null || str.length() == 0 ? defval : Utils.base64decode((String)str);
        logger.trace("Getting {}={}", (Object)this.getFullName(name), (Object)"<bytearray>");
        return value;
    }

    public void putByteArray(String name, byte[] value) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(value);
            b64.flush();
            this.put(name, output.toString("8859_1"));
        }
        catch (IOException e) {
            logger.warn("Base-64 encoding of configuration information failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean getBoolean(String name) throws EBaseException {
        String value = this.get(name);
        if (value == null) {
            logger.trace("Property {} not found", (Object)this.getFullName(name));
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", this.getName() + "." + name));
        }
        if (value.length() == 0) {
            throw new EPropertyNotDefined(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_NOVALUE", this.getName() + "." + name));
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_PROPERTY_1", this.getName() + "." + name, "boolean", "\"true\" or \"false\""));
    }

    public boolean getBoolean(String name, boolean defval) throws EBaseException {
        boolean val;
        try {
            val = this.getBoolean(name);
        }
        catch (EPropertyNotFound e) {
            val = defval;
        }
        catch (EPropertyNotDefined e) {
            val = defval;
        }
        logger.trace("Getting {}={}", (Object)this.getFullName(name), (Object)val);
        return val;
    }

    public void putBoolean(String name, boolean value) {
        if (value) {
            this.put(name, "true");
        } else {
            this.put(name, "false");
        }
    }

    public int getInteger(String name) throws EBaseException {
        String value = this.get(name);
        if (value == null) {
            logger.trace("Property {} not found", (Object)this.getFullName(name));
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", this.getName() + "." + name));
        }
        if (value.length() == 0) {
            throw new EPropertyNotDefined(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_NOVALUE", this.getName() + "." + name));
        }
        try {
            logger.trace("Getting {}={}", (Object)this.getFullName(name), (Object)value);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_PROPERTY_1", this.getName() + "." + name, "int", "number"));
        }
    }

    public int getInteger(String name, int defval) throws EBaseException {
        int val;
        try {
            val = this.getInteger(name);
        }
        catch (EPropertyNotFound e) {
            val = defval;
        }
        catch (EPropertyNotDefined e) {
            val = defval;
        }
        logger.trace("Getting {}={}", (Object)this.getFullName(name), (Object)val);
        return val;
    }

    public void putInteger(String name, int val) {
        this.put(name, Integer.toString(val));
    }

    public BigInteger getBigInteger(String name) throws EBaseException {
        String value = this.get(name);
        if (value == null) {
            logger.trace("Property {} not found", (Object)this.getFullName(name));
            throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", this.getName() + "." + name));
        }
        if (value.length() == 0) {
            throw new EPropertyNotDefined(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_NOVALUE", this.getName() + "." + name));
        }
        try {
            if (value.startsWith("0x") || value.startsWith("0X")) {
                String val = value.substring(2);
                return new BigInteger(val, 16);
            }
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_PROPERTY_1", this.getName() + "." + name, "BigInteger", "number"));
        }
    }

    public BigInteger getBigInteger(String name, BigInteger defval) throws EBaseException {
        BigInteger val;
        try {
            val = this.getBigInteger(name);
        }
        catch (EPropertyNotFound e) {
            val = defval;
        }
        catch (EPropertyNotDefined e) {
            val = defval;
        }
        return val;
    }

    public void putBigInteger(String name, BigInteger val) {
        this.put(name, val.toString());
    }

    public ConfigStore makeSubStore(String name) {
        return this.makeSubStore(name, ConfigStore.class);
    }

    public <T extends ConfigStore> T makeSubStore(String name, Class<T> clazz) {
        String fullname = this.getFullName(name);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(String.class, SimpleProperties.class);
            return (T)((ConfigStore)constructor.newInstance(fullname, this.mSource));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeSubStore(String name) {
        Enumeration e = this.mSource.keys();
        String fullName = this.getFullName(name);
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(fullName + ".")) continue;
            this.mSource.remove(key);
        }
    }

    public ConfigStore getSubStore(String name) {
        return this.getSubStore(name, ConfigStore.class);
    }

    public <T extends ConfigStore> T getSubStore(String name, Class<T> clazz) {
        String fullname = this.getFullName(name);
        String reference = (String)this.mSource.get(fullname);
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(String.class, SimpleProperties.class);
            return (T)(reference == null ? (ConfigStore)constructor.newInstance(fullname, this.mSource) : (ConfigStore)constructor.newInstance(reference, this.mSource));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Enumeration<String> getPropertyNames() {
        Map<String, String> map = this.getProperties();
        Vector<String> v = new Vector<String>();
        for (String name : map.keySet()) {
            int i = name.indexOf(46);
            if (i >= 0 || v.contains(name)) continue;
            v.addElement(name);
        }
        return v.elements();
    }

    public Vector<String> getSubStoreNames() {
        Map<String, String> map = this.getProperties();
        Vector<String> v = new Vector<String>();
        for (String name : map.keySet()) {
            int i = name.indexOf(46);
            if (i < 0 || v.contains(name = name.substring(0, i))) continue;
            v.addElement(name);
        }
        return v;
    }

    public SimpleProperties getSource() {
        return this.mSource;
    }

    public void printProperties() {
        Enumeration keys = this.mSource.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.mStoreName == null) {
                System.out.println(key);
                continue;
            }
            if (!key.startsWith(this.mStoreName)) continue;
            System.out.println(key);
        }
    }

    protected String getFullName(String name) {
        return this.mStoreName == null ? name : this.mStoreName + "." + name;
    }

    public Object clone() {
        try {
            ConfigStore that = (ConfigStore)super.clone();
            this.mStoreName = this.getName();
            this.mSource = new SimpleProperties();
            Enumeration<String> subs = this.getSubStoreNames().elements();
            while (subs.hasMoreElements()) {
                String name = subs.nextElement();
                ConfigStore sub = this.getSubStore(name, ConfigStore.class);
                ConfigStore newSub = that.makeSubStore(sub.getName());
                Enumeration<String> props = sub.getPropertyNames();
                while (props.hasMoreElements()) {
                    String n = props.nextElement();
                    try {
                        newSub.putString(n, sub.getString(n));
                    }
                    catch (EBaseException eBaseException) {}
                }
            }
            return that;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

