/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.processors;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.processors.PKIProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRMFProcessor
extends PKIProcessor {
    public static Logger logger = LoggerFactory.getLogger(CRMFProcessor.class);
    private CMSRequest mRequest;
    private boolean enforcePop = false;

    public CRMFProcessor() {
    }

    public CRMFProcessor(CMSRequest cmsReq, CMSServlet servlet, boolean doEnforcePop) {
        super(cmsReq, servlet);
        this.enforcePop = doEnforcePop;
        this.mRequest = cmsReq;
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
    }

    private void verifyPOP(CertReqMsg certReqMsg) throws EBaseException {
        block6: {
            String method = "CRMFProcessor: verifyPOP: ";
            Auditor auditor = this.engine.getAuditor();
            String auditMessage = null;
            String auditSubjectID = this.auditSubjectID();
            try {
                logger.debug("CRMFProcessor: verifyPOP");
                if (certReqMsg.hasPop()) {
                    ProofOfPossession pop = certReqMsg.getPop();
                    ProofOfPossession.Type popType = pop.getType();
                    if (popType != ProofOfPossession.SIGNATURE) break block6;
                    logger.debug("CRMFProcessor: Request has pop.");
                    try {
                        certReqMsg.verify();
                        auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", auditSubjectID, "Success", "method=" + method);
                        auditor.log(auditMessage);
                        break block6;
                    }
                    catch (Exception e) {
                        logger.error("CRMFProcessor: Failed POP verify: " + e.getMessage(), (Throwable)e);
                        logger.error(CMS.getLogMessage("CMSGW_ERROR_POP_VERIFY", new Object[0]));
                        auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", auditSubjectID, "Failure", method + e.toString());
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_POP_VERIFY", new Object[0]));
                    }
                }
                if (this.enforcePop) {
                    logger.error(CMS.getLogMessage("CMSGW_ERROR_NO_POP", new Object[0]));
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", auditSubjectID, "Failure", method + "required POP missing");
                    auditor.log(auditMessage);
                    throw new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_NO_POP", new Object[0]));
                }
            }
            catch (EBaseException eAudit1) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", auditSubjectID, "Failure", method + eAudit1.toString());
                auditor.log(auditMessage);
            }
        }
    }

    public X509CertInfo processIndividualRequest(CertReqMsg certReqMsg, AuthToken authToken, ArgBlock httpParams) throws EBaseException {
        logger.debug("CRMFProcessor::processIndividualRequest!");
        try {
            this.verifyPOP(certReqMsg);
            CertRequest certReq = certReqMsg.getCertReq();
            CertTemplate certTemplate = certReq.getCertTemplate();
            CertInfo certInfo = new CertInfo();
            SubjectPublicKeyInfo spki = certTemplate.getPublicKey();
            ByteArrayOutputStream keyout = new ByteArrayOutputStream();
            spki.encode((OutputStream)keyout);
            byte[] keybytes = keyout.toByteArray();
            X509Key key = new X509Key();
            key.decode(keybytes);
            certInfo.set("key", (Object)new CertificateX509Key(key));
            if (certTemplate.getNotBefore() != null || certTemplate.getNotAfter() != null) {
                CertificateValidity certValidity = new CertificateValidity(certTemplate.getNotBefore(), certTemplate.getNotAfter());
                certInfo.set("validity", (Object)certValidity);
            }
            if (certTemplate.hasSubject()) {
                Name subjectdn = certTemplate.getSubject();
                ByteArrayOutputStream subjectEncStream = new ByteArrayOutputStream();
                subjectdn.encode((OutputStream)subjectEncStream);
                byte[] subjectEnc = subjectEncStream.toByteArray();
                X500Name subject = new X500Name(subjectEnc);
                certInfo.set("subject", (Object)new CertificateSubjectName(subject));
            } else if (authToken == null || authToken.getInString("tokenCertSubject") == null) {
                logger.error(CMS.getLogMessage("CMSGW_MISSING_SUBJECT_NAME_FROM_AUTHTOKEN", new Object[0]));
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_MISSING_SUBJECT_NAME_FROM_AUTHTOKEN", new String[0]));
            }
            CertificateExtensions extensions = null;
            try {
                extensions = (CertificateExtensions)certInfo.get("extensions");
            }
            catch (CertificateException e) {
                extensions = null;
            }
            catch (IOException e) {
                extensions = null;
            }
            if (certTemplate.hasExtensions()) {
                if (extensions == null) {
                    extensions = new CertificateExtensions();
                }
                int numexts = certTemplate.numExtensions();
                for (int j = 0; j < numexts; ++j) {
                    org.mozilla.jss.pkix.cert.Extension jssext = certTemplate.extensionAt(j);
                    boolean isCritical = jssext.getCritical();
                    OBJECT_IDENTIFIER jssoid = jssext.getExtnId();
                    long[] numbers = jssoid.getNumbers();
                    int[] oidNumbers = new int[numbers.length];
                    for (int k = numbers.length - 1; k >= 0; --k) {
                        oidNumbers[k] = (int)numbers[k];
                    }
                    ObjectIdentifier oid = new ObjectIdentifier(oidNumbers);
                    OCTET_STRING jssvalue = jssext.getExtnValue();
                    ByteArrayOutputStream jssvalueout = new ByteArrayOutputStream();
                    jssvalue.encode((OutputStream)jssvalueout);
                    byte[] extValue = jssvalueout.toByteArray();
                    Extension ext = new Extension(oid, isCritical, extValue);
                    extensions.parseExtension(ext);
                }
                certInfo.set("version", (Object)new CertificateVersion(2));
                certInfo.set("extensions", (Object)extensions);
            }
            if (authToken != null && authToken.getInString("tokenCertSubject") != null) {
                CRMFProcessor.fillCertInfoFromAuthToken((X509CertInfo)certInfo, authToken);
            }
            if (this.mServletId.equals("caadminEnroll")) {
                CRMFProcessor.fillValidityFromForm((X509CertInfo)certInfo, httpParams);
            }
            return certInfo;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CRMF_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CRMF_TO_CERTINFO_ERROR", new String[0]), e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CRMF_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CRMF_TO_CERTINFO_ERROR", new String[0]), e);
        }
        catch (InvalidKeyException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CRMF_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CRMF_TO_CERTINFO_ERROR", new String[0]), e);
        }
    }

    @Override
    public X509CertInfo[] fillCertInfoArray(byte[] bytes, AuthToken authToken, ArgBlock httpParams, Request req) throws EBaseException {
        logger.debug("CRMFProcessor.fillCertInfoArray!");
        try {
            ByteArrayInputStream crmfBlobIn = new ByteArrayInputStream(bytes);
            SEQUENCE crmfMsgs = (SEQUENCE)new SEQUENCE.OF_Template((ASN1Template)new CertReqMsg.Template()).decode((InputStream)crmfBlobIn);
            int nummsgs = crmfMsgs.size();
            X509CertInfo[] certInfoArray = new X509CertInfo[nummsgs];
            for (int i = 0; i < nummsgs; ++i) {
                CertReqMsg certReqMsg = (CertReqMsg)crmfMsgs.elementAt(i);
                CertRequest certReq = certReqMsg.getCertReq();
                INTEGER certReqId = certReq.getCertReqId();
                int srcId = certReqId.intValue();
                req.setExtData("crmfReqId", String.valueOf(srcId));
                certInfoArray[i] = this.processIndividualRequest(certReqMsg, authToken, httpParams);
            }
            return certInfoArray;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CRMF_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CRMF_TO_CERTINFO_ERROR", new String[0]), e);
        }
        catch (InvalidBERException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CRMF_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CRMF_TO_CERTINFO_ERROR", new String[0]), (Exception)((Object)e));
        }
    }
}

