/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIService {
    public static Logger logger = LoggerFactory.getLogger(PKIService.class);
    public static final int DEFAULT_LONG_CACHE_LIFETIME = 1000;
    public static List<MediaType> MESSAGE_FORMATS = Arrays.asList(MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_FORM_URLENCODED_TYPE, MediaType.APPLICATION_OCTET_STREAM_TYPE, MediaType.valueOf((String)"application/pkix-cert"), MediaType.valueOf((String)"application/pkcs7-mime"), MediaType.valueOf((String)"application/x-pem-file"));
    public static final int MIN_FILTER_LENGTH = 3;
    public static final int DEFAULT_SIZE = 20;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected Request request;
    @Context
    protected HttpServletRequest servletRequest;
    @Context
    protected ServletContext servletContext;
    public static final Path bannerFile = Paths.get(CMS.getInstanceDir(), "conf", "banner.txt");

    public static boolean isBannerEnabled() {
        return Files.exists(bannerFile, new LinkOption[0]);
    }

    public static String getBanner() throws IOException {
        return new String(Files.readAllBytes(bannerFile), "UTF-8").trim();
    }

    public static MediaType resolveFormat(MediaType format) {
        return PKIService.resolveFormat(format, MESSAGE_FORMATS);
    }

    public static MediaType resolveFormat(MediaType candidate, List<MediaType> validTypes) {
        if (candidate == null) {
            return null;
        }
        for (MediaType validType : validTypes) {
            if (!candidate.isCompatible(validType)) continue;
            return validType;
        }
        return null;
    }

    public static MediaType resolveFormat(List<MediaType> formats) {
        return PKIService.resolveFormat(formats, MESSAGE_FORMATS);
    }

    public static MediaType resolveFormat(List<MediaType> candidates, List<MediaType> validTypes) {
        if (candidates == null) {
            return null;
        }
        for (MediaType candidate : candidates) {
            MediaType match = PKIService.resolveFormat(candidate, validTypes);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public static MediaType getResponseFormat(HttpHeaders headers) {
        MediaType contentType = headers.getMediaType();
        List acceptableFormats = headers.getAcceptableMediaTypes();
        MediaType responseFormat = acceptableFormats == null || acceptableFormats.isEmpty() ? (contentType == null ? MESSAGE_FORMATS.get(0) : PKIService.resolveFormat(contentType)) : PKIService.resolveFormat(acceptableFormats);
        if (responseFormat == null) {
            throw new PKIException(Response.Status.NOT_ACCEPTABLE);
        }
        return responseFormat;
    }

    public MediaType getResponseFormat() {
        return PKIService.getResponseFormat(this.headers);
    }

    public Response createOKResponse() {
        return Response.ok().type(this.getResponseFormat()).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object marshall(Object response) {
        MediaType responseFormat = this.getResponseFormat();
        logger.info("PKIService: Response format: " + responseFormat);
        Class<?> clazz = response.getClass();
        logger.info("PKIService: Response class: " + clazz.getSimpleName());
        try {
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(responseFormat)) {
                Method method = clazz.getMethod("toXML", new Class[0]);
                response = method.invoke(response, new Object[0]);
                logger.info("PKIService: XML response:\n" + response);
                return response;
            }
            if (!MediaType.APPLICATION_JSON_TYPE.isCompatible(responseFormat)) return response;
        }
        catch (NoSuchMethodException e) {
            logger.info("PKIService: " + clazz.getSimpleName() + " has no custom mapping for " + responseFormat);
            return response;
        }
        catch (Exception e) {
            logger.error("PKIService: Unable to marshall response: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return response;
    }

    public <T> T unmarshall(Object request, Class<T> clazz) {
        logger.info("PKIService: Request class: " + clazz.getSimpleName());
        MediaType requestFormat = this.headers.getMediaType();
        logger.info("PKIService: Request format: " + requestFormat);
        try {
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(requestFormat)) {
                logger.info("PKIService: XML request:\n" + request);
                Method method = clazz.getMethod("fromXML", String.class);
                return (T)method.invoke(null, request);
            }
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(requestFormat)) {
                logger.info("PKIService: JSON request:\n" + request);
                return (T)JSONSerializer.fromJSON((String)((String)request), clazz);
            }
        }
        catch (NoSuchMethodException e) {
            logger.info("PKIService: " + clazz.getSimpleName() + " has no custom mapping for " + requestFormat);
        }
        catch (Exception e) {
            logger.error("PKIService: Unable to unmarshall request: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)request;
    }

    public Response createOKResponse(Object entity) {
        entity = this.marshall(entity);
        return Response.ok((Object)entity).type(this.getResponseFormat()).build();
    }

    public Response createCreatedResponse(Object entity, URI link) {
        entity = this.marshall(entity);
        return Response.created((URI)link).entity(entity).type(this.getResponseFormat()).build();
    }

    public Response createNoContentResponse() {
        return Response.noContent().type(this.getResponseFormat()).build();
    }

    public Response sendConditionalGetResponse(int ctime, Object entity, Request request) {
        entity = this.marshall(entity);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(ctime);
        EntityTag tag = new EntityTag(Integer.toString(entity.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(tag);
        if (builder != null) {
            builder.cacheControl(cc);
            return builder.build();
        }
        builder = Response.ok((Object)entity);
        builder.cacheControl(cc);
        builder.tag(tag);
        builder.type(this.getResponseFormat());
        return builder.build();
    }

    public Locale getLocale(HttpHeaders headers) {
        if (headers == null) {
            return Locale.getDefault();
        }
        List locales = headers.getAcceptableLanguages();
        if (locales == null || locales.isEmpty()) {
            return Locale.getDefault();
        }
        return (Locale)locales.get(0);
    }

    public Map<String, String> getParams(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Method method : object.getClass().getMethods()) {
            FormParam element = method.getAnnotation(FormParam.class);
            if (element == null) continue;
            String name = element.value();
            try {
                Object value = method.invoke(object, new Object[0]);
                map.put(name, value == null ? null : value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public CMSEngine getCMSEngine() {
        return (CMSEngine)this.servletContext.getAttribute("engine");
    }
}

