/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.logging.event.AuthEvent;
import com.netscape.certsrv.logging.event.AuthzEvent;
import com.netscape.certsrv.logging.event.RoleAssumeEvent;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthorizationConfig;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServlet
extends HttpServlet {
    public static Logger logger = LoggerFactory.getLogger(AdminServlet.class);
    private static final long serialVersionUID = 7740464244137421542L;
    private static final String HDR_AUTHORIZATION = "Authorization";
    private static final String HDR_LANG = "accept-language";
    protected ServletConfig servletConfig;
    protected ServletContext servletContext;
    protected EngineConfig mConfig = null;
    protected AuthzSubsystem mAuthz;
    protected String mAclMethod = null;
    protected String mOp = "";
    protected static String AUTHZ_RES_NAME = "certServer";
    protected AuthzToken mToken;
    private String mServletID = null;
    public static final String PROP_AUTHZ_MGR = "AuthzMgr";
    public static final String PROP_ACL = "ACLinfo";
    public static final String AUTHZ_MGR_BASIC = "BasicAclAuthz";
    public static final String AUTHZ_MGR_LDAP = "DirAclAuthz";
    public static final String PROP_ID = "ID";
    public static final String CERT_ATTR = "javax.servlet.request.X509Certificate";
    private static final String CERTUSERDB = "certUserDBAuthMgr";
    private static final String PASSWDUSERDB = "passwdUserDBAuthMgr";
    public static int SUCCESS = 0;
    public static int ERROR = 1;
    public static int RESTART = -1;

    public CMSEngine getCMSEngine() {
        return (CMSEngine)this.servletContext.getAttribute("engine");
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.servletConfig = sc;
        this.servletContext = sc.getServletContext();
        CMSEngine engine = this.getCMSEngine();
        this.mConfig = engine.getConfig();
        String srcType = "ldap";
        try {
            AuthorizationConfig authzConfig = this.mConfig.getAuthorizationConfig();
            srcType = authzConfig.getSourceType();
        }
        catch (EBaseException e) {
            logger.warn("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_FAIL_SRC_TYPE", new Object[0]) + ": " + e.getMessage(), (Throwable)e);
        }
        this.mAuthz = engine.getAuthzSubsystem();
        this.mServletID = this.getSCparam(sc, PROP_ID, "servlet id unknown");
        logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTHZ_INITED", this.mServletID));
        if (srcType.equalsIgnoreCase("web.xml")) {
            logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTHZ_INITED", ""));
            this.mAclMethod = this.getSCparam(sc, PROP_AUTHZ_MGR, AUTHZ_MGR_LDAP);
            if (this.mAclMethod.equalsIgnoreCase(AUTHZ_MGR_BASIC)) {
                String aclInfo = sc.getInitParameter(PROP_ACL);
                if (aclInfo != null) {
                    try {
                        this.mAuthz.addACLInfo(this.mAclMethod, aclInfo);
                    }
                    catch (EBaseException e) {
                        logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTHZ_MGR_INIT_FAIL", new Object[0]), (Throwable)e);
                        throw new ServletException("failed to init authz info from xml config file", (Throwable)e);
                    }
                    logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTHZ_MGR_INIT_DONE", this.mServletID));
                } else {
                    logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_PROP_ACL_NOT_SPEC", PROP_ACL, this.mServletID, AUTHZ_MGR_LDAP));
                }
            } else {
                logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_PROP_ACL_NOT_SPEC", PROP_AUTHZ_MGR, this.mServletID, AUTHZ_MGR_LDAP));
            }
        } else {
            this.mAclMethod = AUTHZ_MGR_LDAP;
            logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTH_LDAP_NOT_XML", this.mServletID));
        }
    }

    public void outputHttpParameters(HttpServletRequest httpReq) {
        logger.debug("AdminServlet:service() uri = " + httpReq.getRequestURI());
        Enumeration paramNames = httpReq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String pn = (String)paramNames.nextElement();
            if (CMS.isSensitive(pn)) {
                logger.debug("AdminServlet::service() param name='" + pn + "' value='(sensitive)'");
                continue;
            }
            logger.debug("AdminServlet::service() param name='" + pn + "' value='" + httpReq.getParameter(pn) + "'");
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        boolean running_state = engine.isInRunningState();
        if (!running_state) {
            throw new IOException("CMS server is not ready to serve.");
        }
        if (logger.isErrorEnabled()) {
            this.outputHttpParameters(req);
        }
    }

    private String getSCparam(ServletConfig sc, String param, String defVal) {
        String val = sc.getInitParameter(param);
        return val == null ? defVal : val;
    }

    protected void authenticate(HttpServletRequest req) throws IOException {
        CMSEngine engine = this.getCMSEngine();
        UGSubsystem mUG = engine.getUGSubsystem();
        EngineConfig configStore = engine.getConfig();
        Auditor auditor = engine.getAuditor();
        String auditUID = "$Unidentified$";
        String authType = "";
        try {
            try {
                authType = configStore.getString("authType");
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
            AuthSubsystem auth = engine.getAuthSubsystem();
            X509Certificate cert = null;
            if (authType.equals("sslclientauth")) {
                X509Certificate[] allCerts = (X509Certificate[])req.getAttribute(CERT_ATTR);
                if (allCerts == null || allCerts.length == 0) {
                    auditor.log(AuthEvent.createFailureEvent("$Unidentified$", CERTUSERDB, auditUID));
                    throw new IOException("No certificate");
                }
                cert = allCerts[0];
                try {
                    byte[] certEncoded = cert.getEncoded();
                    cert = new X509CertImpl(certEncoded);
                    String certUID = cert.getSubjectDN().getName();
                    if (certUID != null && !(certUID = certUID.trim()).equals("")) {
                        auditUID = certUID;
                    }
                }
                catch (Exception certEncoded) {
                    // empty catch block
                }
            }
            SessionContext sc = SessionContext.getContext();
            AuthToken token = null;
            logger.debug(CMS.getLogMessage("ADMIN_SRVLT_ABOUT_AUTH", this.mServletID));
            try {
                if (authType.equals("sslclientauth")) {
                    AuthManager authMgr = auth.get(CERTUSERDB);
                    AuthCredentials authCreds = AdminServlet.getAuthCreds(authMgr, cert);
                    token = authMgr.authenticate(authCreds);
                } else {
                    String authToken = req.getHeader(HDR_AUTHORIZATION);
                    String b64s = authToken.substring(authToken.lastIndexOf(32) + 1);
                    String authCode = new String(Utils.base64decode((String)b64s));
                    String userid = authCode.substring(0, authCode.indexOf(58));
                    String password = authCode.substring(authCode.indexOf(58) + 1);
                    AuthCredentials cred = new AuthCredentials();
                    String pwdUID = userid;
                    if (pwdUID != null && !(pwdUID = pwdUID.trim()).equals("")) {
                        auditUID = pwdUID;
                    }
                    cred.set("uid", userid);
                    cred.set("pwd", password);
                    token = auth.authenticate(cred, PASSWDUSERDB);
                    logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_AUTH_FOR_SRVLT", this.mServletID));
                }
            }
            catch (EBaseException e) {
                if (authType.equals("sslclientauth")) {
                    auditor.log(AuthEvent.createFailureEvent("$Unidentified$", CERTUSERDB, auditUID));
                } else {
                    auditor.log(AuthEvent.createFailureEvent("$Unidentified$", PASSWDUSERDB, auditUID));
                }
                throw new IOException("authentication failed");
            }
            try {
                String tuserid = token.getInString("userid");
                if (tuserid == null) {
                    logger.error(CMS.getLogMessage("ADMIN_SRVLT_NO_AUTH_TOKEN", tuserid));
                    if (authType.equals("sslclientauth")) {
                        auditor.log(AuthEvent.createFailureEvent("$Unidentified$", CERTUSERDB, auditUID));
                    } else {
                        auditor.log(AuthEvent.createFailureEvent("$Unidentified$", PASSWDUSERDB, auditUID));
                    }
                    throw new IOException("authentication failed");
                }
                User user = mUG.getUser(tuserid);
                if (user == null) {
                    logger.error(CMS.getLogMessage("ADMIN_SRVLT_USER_NOT_FOUND", tuserid));
                    if (authType.equals("sslclientauth")) {
                        auditor.log(AuthEvent.createFailureEvent("$Unidentified$", CERTUSERDB, auditUID));
                    } else {
                        auditor.log(AuthEvent.createFailureEvent("$Unidentified$", PASSWDUSERDB, auditUID));
                    }
                    throw new IOException("authentication failed");
                }
                SessionContext sessionContext = SessionContext.getContext();
                sessionContext.put((Object)"AuthToken", (Object)token);
                sessionContext.put((Object)"userid", (Object)tuserid);
                sessionContext.put((Object)"user", (Object)user);
            }
            catch (EUsrGrpException e) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_USR_GRP_ERR", e.toString()), (Throwable)e);
                if (authType.equals("sslclientauth")) {
                    auditor.log(AuthEvent.createFailureEvent("$Unidentified$", CERTUSERDB, auditUID));
                } else {
                    auditor.log(AuthEvent.createFailureEvent("$Unidentified$", PASSWDUSERDB, auditUID));
                }
                throw new IOException("authentication failed");
            }
            Locale locale = this.getLocale(req);
            sc.put((Object)"locale", (Object)locale);
            if (authType.equals("sslclientauth")) {
                auditor.log(AuthEvent.createSuccessEvent(this.auditSubjectID(), CERTUSERDB));
            } else {
                auditor.log(AuthEvent.createSuccessEvent(this.auditSubjectID(), PASSWDUSERDB));
            }
        }
        catch (IOException eAudit1) {
            if (authType.equals("sslclientauth")) {
                auditor.log(AuthEvent.createFailureEvent("$Unidentified$", CERTUSERDB, auditUID));
            } else {
                auditor.log(AuthEvent.createFailureEvent("$Unidentified$", PASSWDUSERDB, auditUID));
            }
            throw eAudit1;
        }
    }

    public static AuthCredentials getAuthCreds(AuthManager authMgr, X509Certificate clientCert) throws EBaseException {
        String[] reqCreds = authMgr.getRequiredCreds();
        AuthCredentials creds = new AuthCredentials();
        for (int i = 0; i < reqCreds.length; ++i) {
            String reqCred = reqCreds[i];
            if (!reqCred.equals("sslClientCert")) continue;
            creds.set(reqCred, new X509Certificate[]{clientCert});
        }
        return creds;
    }

    protected AuthzToken authorize(HttpServletRequest req) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditACLResource = "<null>";
        String auditOperation = "<null>";
        String resource = null;
        String operation = null;
        SessionContext sc = SessionContext.getContext();
        AuthToken authToken = (AuthToken)sc.get((Object)"AuthToken");
        AuthzToken authzTok = null;
        logger.debug("AdminServlet: " + CMS.getLogMessage("ADMIN_SRVLT_CHECK_AUTHZ_AUTH", this.mServletID));
        try {
            authzTok = this.mAuthz.authorize(this.mAclMethod, authToken, AUTHZ_RES_NAME, this.mOp);
            resource = (String)authzTok.get("authzRes");
            if (resource != null) {
                auditACLResource = resource.trim();
            }
            if ((operation = (String)authzTok.get("authzOp")) != null) {
                auditOperation = operation.trim();
            }
            logger.debug(CMS.getLogMessage("ADMIN_SRVLT_AUTH_SUCCEED", this.mServletID));
        }
        catch (EAuthzAccessDenied e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
            auditor.log(RoleAssumeEvent.createFailureEvent(auditSubjectID, this.auditGroups(auditSubjectID)));
            return null;
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
            auditor.log(RoleAssumeEvent.createFailureEvent(auditSubjectID, this.auditGroups(auditSubjectID)));
            return null;
        }
        catch (Exception e) {
            auditor.log(AuthzEvent.createFailureEvent(auditSubjectID, auditACLResource, auditOperation));
            auditor.log(RoleAssumeEvent.createFailureEvent(auditSubjectID, this.auditGroups(auditSubjectID)));
            return null;
        }
        auditor.log(AuthzEvent.createSuccessEvent(auditSubjectID, auditACLResource, auditOperation));
        auditor.log(RoleAssumeEvent.createSuccessEvent(auditSubjectID, this.auditGroups(auditSubjectID)));
        return authzTok;
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader(HDR_LANG);
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }

    protected void sendResponse(int returnCode, String errorMsg, NameValuePairs params, HttpServletResponse resp) throws IOException {
        Set names;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(returnCode);
        if (errorMsg != null) {
            dos.writeUTF(errorMsg);
        }
        StringBuffer buf = new StringBuffer();
        if (params != null && !(names = params.keySet()).isEmpty()) {
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = URLEncoder.encode((String)params.get((Object)name), "UTF-8");
                buf.append(URLEncoder.encode(name, "UTF-8") + "=" + value);
                if (!i.hasNext()) continue;
                buf.append("&");
            }
            byte[] content = buf.toString().getBytes();
            dos.write(content, 0, content.length);
        }
        byte[] msg = bos.toByteArray();
        resp.setContentLength(msg.length);
        resp.getOutputStream().write(msg);
        resp.getOutputStream().flush();
    }

    protected String URLdecode(String s) {
        if (s == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+') {
                out.write(32);
                continue;
            }
            if (c == '%') {
                int c1 = Character.digit(s.charAt(++i), 16);
                int c2 = Character.digit(s.charAt(++i), 16);
                out.write((char)(c1 * 16 + c2));
                continue;
            }
            out.write(c);
        }
        return out.toString();
    }

    protected String getParameter(HttpServletRequest req, String name) {
        return req.getParameter(name);
    }

    protected synchronized void getConfig(ConfigStore config, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE")) continue;
            params.put((Object)name, (Object)config.getString(name));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    protected synchronized void setConfig(ConfigStore config, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE")) continue;
            config.putString(name, req.getParameter(name));
        }
        this.commit(true);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    protected synchronized void listConfig(ConfigStore config, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        Enumeration<String> e = config.getPropertyNames();
        NameValuePairs params = new NameValuePairs();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            params.put((Object)s, (Object)config.getString(s));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    public boolean authorize(AuthToken token) throws EBaseException {
        String[] mGroupNames = new String[]{"Administrators"};
        boolean mAnd = true;
        try {
            String userid = token.getInString("userid");
            if (userid == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_GRP_AUTHZ_FAIL", userid));
                return false;
            }
            CMSEngine engine = this.getCMSEngine();
            UGSubsystem mUG = engine.getUGSubsystem();
            User user = mUG.getUser(userid);
            if (user == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_USER_NOT_IN_DB", userid));
                return false;
            }
            SessionContext sessionContext = SessionContext.getContext();
            sessionContext.put((Object)"AuthToken", (Object)token);
            sessionContext.put((Object)"userid", (Object)userid);
            sessionContext.put((Object)"user", (Object)user);
            if (mAnd) {
                for (int i = 0; i < mGroupNames.length; ++i) {
                    if (mUG.isMemberOf(user, mGroupNames[i])) continue;
                    logger.error(CMS.getLogMessage("ADMIN_SRVLT_USER_NOT_IN_GRP", userid, mGroupNames[i]));
                    return false;
                }
                return true;
            }
            for (int i = 0; i < mGroupNames.length; ++i) {
                if (!mUG.isMemberOf(user, mGroupNames[i])) continue;
                logger.info(CMS.getLogMessage("ADMIN_SRVLT_GRP_AUTH_SUCC_USER", userid, mGroupNames[i]));
                return true;
            }
            StringBuffer groups = new StringBuffer();
            groups.append(mGroupNames[0]);
            for (int j = 1; j < mGroupNames.length; ++j) {
                groups.append(",");
                groups.append(mGroupNames[j]);
            }
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_USER_NOT_ANY_GRP", userid, groups.toString()));
            return false;
        }
        catch (EUsrGrpException e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_USR_GRP_ERR", e.toString()), (Throwable)e);
            return false;
        }
    }

    protected void commit(boolean createBackup) throws EBaseException {
        this.mConfig.commit(createBackup);
    }

    protected String auditSubjectID() {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        if (auditor == null) {
            return null;
        }
        return auditor.getSubjectID();
    }

    protected String auditParams(HttpServletRequest req) {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        if (auditor == null) {
            return null;
        }
        String scope = req.getParameter("OP_SCOPE");
        String type = req.getParameter("OP_TYPE");
        String id = req.getParameter("RS_ID");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("OP_SCOPE") || name.equals("OP_TYPE") || name.equals("RS_ID")) continue;
            String value = null;
            value = CMS.isSensitive(name) ? "(sensitive)" : req.getParameter(name);
            params.put(name, value);
        }
        return auditor.getParamString(scope, type, id, params);
    }

    private String auditGroups(String subjectID) {
        CMSEngine engine = this.getCMSEngine();
        return engine.getAuditGroups(subjectID);
    }

    protected NameValuePairs convertStringArrayToNVPairs(String[] s) {
        if (s == null) {
            return null;
        }
        NameValuePairs nvps = new NameValuePairs();
        for (int i = 0; i < s.length; ++i) {
            int j = s[i].indexOf(";");
            String paramName = s[i].substring(0, j);
            String args = s[i].substring(j + 1);
            nvps.put((Object)paramName, (Object)args);
        }
        return nvps;
    }

    protected static IExtendedPluginInfo getClassByNameAsExtendedPluginInfo(String className) {
        IExtendedPluginInfo epi = null;
        try {
            Object o = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            epi = (IExtendedPluginInfo)o;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return epi;
    }
}

