/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.logging;

import com.netscape.certsrv.logging.ILogger;
import com.netscape.certsrv.logging.LogCategory;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.LogSource;
import com.netscape.cms.logging.AuditEventFactory;
import com.netscape.cms.logging.LogEventFactory;
import com.netscape.cms.logging.LogQueue;
import java.util.Hashtable;

public class Logger
implements ILogger {
    protected LogQueue logQueue = LogQueue.getInstance();
    protected static Hashtable<LogCategory, LogEventFactory> mFactories = new Hashtable();
    LogEventFactory factory;
    LogCategory category;
    LogSource source;
    int level = 1;

    public Logger() {
    }

    public Logger(LogEventFactory factory, LogCategory category, LogSource source) {
        this.factory = factory;
        this.category = category;
        this.source = source;
    }

    public Logger(LogEventFactory factory, LogCategory category, LogSource source, int level) {
        this.factory = factory;
        this.category = category;
        this.source = source;
        this.level = level;
    }

    public static Logger getLogger(LogCategory category, LogSource source) {
        LogEventFactory factory = mFactories.get(category);
        if (factory == null) {
            throw new RuntimeException("Unknown logger category: " + category);
        }
        return factory.createLogger(category, source);
    }

    public static void register(LogCategory evtClass, LogEventFactory f) {
        mFactories.put(evtClass, f);
    }

    public void log(String msg) {
        this.log(this.category, this.source, this.level, msg, null, false);
    }

    public void log(LogEvent event) {
        this.log(this.category, this.source, this.level, event.getMessage(), event.getParameters(), false);
    }

    @Override
    public void log(LogCategory evtClass, LogSource source, String msg) {
        this.log(evtClass, source, this.level, msg, null, false);
    }

    public void log(int level, String msg) {
        this.log(this.category, this.source, level, msg, null, false);
    }

    @Override
    public void log(LogCategory evtClass, LogSource source, int level, String msg) {
        this.log(evtClass, source, level, msg, null, false);
    }

    @Override
    public void log(LogCategory evtClass, LogSource source, int level, String msg, Object param) {
        Object[] o = new Object[]{param};
        this.log(evtClass, source, level, msg, o, false);
    }

    public void log(int level, String msg, Object[] params) {
        this.log(this.category, this.source, level, msg, params, false);
    }

    @Override
    public void log(LogCategory evtClass, LogSource source, int level, String msg, Object[] params) {
        this.log(evtClass, source, level, msg, params, false);
    }

    @Override
    public void log(LogCategory evtClass, LogSource source, String msg, boolean multiline) {
        this.log(evtClass, source, this.level, msg, null, multiline);
    }

    public void log(int level, String msg, boolean multiline) {
        this.log(this.category, this.source, level, msg, null, multiline);
    }

    @Override
    public void log(LogCategory evtClass, LogSource source, int level, String msg, boolean multiline) {
        this.log(evtClass, source, level, msg, null, multiline);
    }

    @Override
    public void log(LogCategory evtClass, LogSource source, int level, String msg, Object param, boolean multiline) {
        Object[] o = new Object[]{param};
        this.log(evtClass, source, level, msg, o, multiline);
    }

    public void log(int level, String msg, Object[] params, boolean multiline) {
        this.log(this.category, this.source, level, msg, params, multiline);
    }

    public void log(LogCategory evtClass, LogSource source, int level, String msg, Object[] params, boolean multiline) {
        LogEvent iLEvent = this.create(evtClass, source, level, msg, params, multiline);
        if (iLEvent != null) {
            this.logQueue.log(iLEvent);
        }
    }

    public LogEvent create(int level, String msg, Object[] params, boolean multiline) {
        return this.create(this.category, this.source, level, msg, params, multiline);
    }

    @Override
    public LogEvent create(LogCategory evtClass, LogSource source, int level, String msg, Object[] params, boolean multiline) {
        LogEventFactory f;
        LogEventFactory logEventFactory = f = this.factory == null ? mFactories.get(evtClass) : this.factory;
        if (f == null) {
            throw new RuntimeException("Unknown logger category: " + evtClass);
        }
        LogEvent event = f.create();
        this.update(event, source, level, msg, params, multiline);
        return event;
    }

    public void update(LogEvent event, LogSource source, int level, String message, Object[] params, boolean multiline) {
        event.setSource(source);
        event.setLevel(level);
        event.setMessage(message);
        event.setParameters(params);
        event.setMultiline(multiline);
    }

    public void release(LogEvent event) {
    }

    static {
        Logger.register(EV_AUDIT, new AuditEventFactory());
    }
}

