/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authorization;

import com.netscape.certsrv.acls.ACLEntry;
import com.netscape.certsrv.acls.EACLsException;
import com.netscape.cmscore.apps.CMS;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class ACL
implements Serializable {
    private static final long serialVersionUID = -1867465948611161868L;
    protected Vector<ACLEntry> entries = new Vector();
    protected TreeSet<String> rights = null;
    protected String name = null;
    protected String description = null;
    protected TreeSet<String> resourceACLs = new TreeSet();

    private ACL(String name, Collection<String> rights, String desc, String resourceACLs) {
        if (name == null) {
            throw new IllegalArgumentException("ACL name cannot be null");
        }
        this.name = name;
        this.rights = rights != null ? new TreeSet<String>(rights) : new TreeSet();
        this.resourceACLs.add(resourceACLs);
        this.description = desc;
    }

    public void merge(ACL other) {
        if (!this.name.equals(other.name)) {
            throw new IllegalArgumentException("Cannot merge ACLs; names do not match.");
        }
        this.rights.addAll(other.rights);
        this.entries.addAll(other.entries);
        this.resourceACLs.addAll(other.resourceACLs);
    }

    public String getName() {
        return this.name;
    }

    public Iterable<String> getResourceACLs() {
        return this.resourceACLs;
    }

    public String getDescription() {
        return this.description;
    }

    public Enumeration<ACLEntry> entries() {
        return this.entries.elements();
    }

    public String toString() {
        StringBuilder entries = new StringBuilder();
        Enumeration<ACLEntry> e = this.entries();
        while (e.hasMoreElements()) {
            ACLEntry entry = e.nextElement();
            entries.append(entry);
            if (!e.hasMoreElements()) continue;
            entries.append(",");
        }
        return this.getName() + "[" + entries + "]";
    }

    public boolean checkRight(String permission) {
        return this.rights.contains(permission);
    }

    public Enumeration<String> rights() {
        return Collections.enumeration(this.rights);
    }

    public static ACL parseACL(String resACLs) throws EACLsException {
        if (resACLs == null) {
            throw new EACLsException(CMS.getUserMessage("CMS_ACL_NULL_VALUE", "resACLs"));
        }
        ACL acl = null;
        Vector<String> rights = null;
        int idx1 = resACLs.indexOf(":");
        if (idx1 <= 0) {
            acl = new ACL(resACLs, rights, null, resACLs);
        } else {
            String resource = resACLs.substring(0, idx1);
            if (resource == null) {
                String infoMsg = "resource not specified in resourceACLS attribute:" + resACLs;
                String[] params = new String[]{resACLs, infoMsg};
                throw new EACLsException(CMS.getUserMessage("CMS_ACL_PARSING_ERROR", params));
            }
            String st = resACLs.substring(idx1 + 1);
            int idx2 = st.indexOf(":");
            String rightsString = null;
            if (idx2 == -1) {
                String infoMsg = "rights not specified in resourceACLS attribute:" + resACLs;
                String[] params = new String[]{resACLs, infoMsg};
                throw new EACLsException(CMS.getUserMessage("CMS_ACL_PARSING_ERROR", params));
            }
            rightsString = st.substring(0, idx2);
            if (rightsString != null) {
                rights = new Vector<String>();
                StringTokenizer rtok = new StringTokenizer(rightsString, ",");
                while (rtok.hasMoreTokens()) {
                    rights.addElement(rtok.nextToken());
                }
            }
            String stx = st.substring(idx2 + 1);
            int idx3 = stx.lastIndexOf(":");
            String aclStr = stx.substring(0, idx3);
            String desc = stx.substring(idx3 + 1);
            acl = new ACL(resource, rights, desc, resACLs);
            if (aclStr != null) {
                StringTokenizer atok = new StringTokenizer(aclStr, ";");
                while (atok.hasMoreTokens()) {
                    String acs = atok.nextToken();
                    ACLEntry entry = ACLEntry.parseACLEntry(acl, acs);
                    if (entry == null) {
                        String infoMsg = "parseACLEntry() call failed";
                        String[] params = new String[]{"ACLEntry = " + acs, infoMsg};
                        throw new EACLsException(CMS.getUserMessage("CMS_ACL_PARSING_ERROR", params));
                    }
                    entry.setACLEntryString(acs);
                    acl.entries.add(entry);
                }
            } else {
                String infoMsg = "acls not specified in resourceACLS attribute:" + resACLs;
                String[] params = new String[]{resACLs, infoMsg};
                throw new EACLsException(CMS.getUserMessage("CMS_ACL_PARSING_ERROR", params));
            }
        }
        return acl;
    }
}

