/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.database;

import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.NotImplementedException;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMECertificate;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.database.ACMEDatabaseConfig;

public abstract class ACMEDatabase {
    protected ACMEDatabaseConfig config;

    public ACMEDatabaseConfig getConfig() {
        return this.config;
    }

    public void setConfig(ACMEDatabaseConfig config) {
        this.config = config;
    }

    public void init() throws Exception {
    }

    public void close() throws Exception {
    }

    public Boolean getEnabled() throws Exception {
        return null;
    }

    public void setEnabled(Boolean enabled) throws Exception {
    }

    public abstract void addNonce(ACMENonce var1) throws Exception;

    public abstract ACMENonce removeNonce(String var1) throws Exception;

    public abstract void removeExpiredNonces(Date var1) throws Exception;

    public abstract ACMEAccount getAccount(String var1) throws Exception;

    public abstract void addAccount(ACMEAccount var1) throws Exception;

    public abstract void updateAccount(ACMEAccount var1) throws Exception;

    public abstract ACMEOrder getOrder(String var1) throws Exception;

    public Collection<ACMEOrder> getOrdersByAccount(String accountID) throws Exception {
        throw new NotImplementedException("ACMEDatabase.getOrdersByAccount() must be overridden by specific implementation");
    }

    public abstract Collection<ACMEOrder> getOrdersByAuthorizationAndStatus(String var1, String var2) throws Exception;

    public abstract ACMEOrder getOrderByCertificate(String var1) throws Exception;

    public abstract void addOrder(ACMEOrder var1) throws Exception;

    public abstract void updateOrder(ACMEOrder var1) throws Exception;

    public void removeExpiredOrders(Date currentTime) throws Exception {
        throw new NotImplementedException("ACMEDatabase.removeExpiredOrders() must be overridden by specific implementation");
    }

    public abstract ACMEAuthorization getAuthorization(String var1) throws Exception;

    public abstract ACMEAuthorization getAuthorizationByChallenge(String var1) throws Exception;

    public Collection<ACMEAuthorization> getRevocationAuthorizations(String accountID, Date time) throws Exception {
        throw new NotImplementedException("ACMEDatabase.getRevocationAuthorizations() must be overridden by specific implementation");
    }

    public boolean hasRevocationAuthorization(String accountID, Date time, ACMEIdentifier identifier) throws Exception {
        throw new NotImplementedException("ACMEDatabase.hasRevocationAuthorization() must be overridden by specific implementation");
    }

    public abstract void addAuthorization(ACMEAuthorization var1) throws Exception;

    public abstract void updateAuthorization(ACMEAuthorization var1) throws Exception;

    public void removeExpiredAuthorizations(Date currentTime) throws Exception {
        throw new NotImplementedException("ACMEDatabase.removeExpiredAuthorizations() must be overridden by specific implementation");
    }

    public ACMECertificate getCertificate(String certID) throws Exception {
        throw new NotImplementedException("ACMEDatabase.getCertificate() must be overridden by specific implementation");
    }

    public void addCertificate(String certID, ACMECertificate certificate) throws Exception {
        throw new NotImplementedException("ACMEDatabase.addCertificate() must be overridden by specific implementation");
    }

    public void removeExpiredCertificates(Date currentTime) throws Exception {
        throw new NotImplementedException("ACMEDatabase.removeExpiredCertificates() must be overridden by specific implementation");
    }
}

