/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.EncryptionUnit;
import java.security.PublicKey;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportKeyUnit
extends EncryptionUnit {
    public static Logger logger = LoggerFactory.getLogger(TransportKeyUnit.class);
    public static final String PROP_NICKNAME = "nickName";
    public static final String PROP_NEW_NICKNAME = "newNickName";
    public static final String PROP_SIGNING_ALGORITHM = "signingAlgorithm";
    private ConfigStore mConfig;
    private X509Certificate mCert = null;
    private X509Certificate[] chain;
    private X509Certificate mNewCert = null;
    private CryptoManager mManager = null;
    private KeyWrapAlgorithm rsaKeyWrapAlg = KeyWrapAlgorithm.RSA;

    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        try {
            String nickname = this.getNickName();
            logger.info("TransportKeyUnit: Loading " + nickname + " certificate");
            this.mManager = CryptoManager.getInstance();
            this.mCert = this.mManager.findCertByNickname(nickname);
            this.chain = this.mManager.buildCertificateChain(this.mCert);
            String algo = config.getString(PROP_SIGNING_ALGORITHM, "SHA256withRSA");
            KRAEngine engine = KRAEngine.getInstance();
            KRAEngineConfig kraCfg = null;
            kraCfg = engine.getConfig();
            boolean useOAEPKeyWrap = kraCfg.getUseOAEPKeyWrap();
            logger.debug("TransportKeyUnit: keyWrap.useOAEP:  " + useOAEPKeyWrap);
            if (useOAEPKeyWrap) {
                this.rsaKeyWrapAlg = KeyWrapAlgorithm.RSA_OAEP;
            }
            CryptoToken token = this.getToken();
            SignatureAlgorithm sigalg = Cert.mapAlgorithmToJss((String)algo);
            Signature signer = token.getSignatureContext(sigalg);
            signer.initSign(this.getPrivateKey());
            String newNickName = this.getNewNickName();
            if (newNickName != null && newNickName.length() > 0) {
                this.mNewCert = this.mManager.findCertByNickname(newNickName);
            }
        }
        catch (NotInitializedException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (TokenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    @Override
    public CryptoToken getInternalToken() {
        try {
            return CryptoManager.getInstance().getInternalKeyStorageToken();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public CryptoToken getToken() {
        return this.getPrivateKey().getOwningToken();
    }

    @Override
    public CryptoToken getToken(X509Certificate cert) {
        return this.getPrivateKey(cert).getOwningToken();
    }

    public String getNickName() throws EBaseException {
        return this.mConfig.getString(PROP_NICKNAME);
    }

    public void setNickName(String str) throws EBaseException {
        this.mConfig.putString(PROP_NICKNAME, str);
    }

    private String getNewNickName() {
        String newNickName = null;
        try {
            newNickName = this.mConfig.getString(PROP_NEW_NICKNAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newNickName;
    }

    public String getSigningAlgorithm() throws EBaseException {
        return this.mConfig.getString(PROP_SIGNING_ALGORITHM);
    }

    public void setSigningAlgorithm(String str) throws EBaseException {
        this.mConfig.putString(PROP_SIGNING_ALGORITHM, str);
    }

    public void login(String pin) throws EBaseException {
    }

    public void logout() {
    }

    public X509Certificate getCertificate() {
        return this.mCert;
    }

    public X509Certificate[] getChain() {
        return this.chain;
    }

    public X509Certificate getNewCertificate() {
        return this.mNewCert;
    }

    public X509Certificate verifyCertificate(String transportCert) {
        X509Certificate cert = null;
        if (transportCert != null && transportCert.length() > 0) {
            String certB64 = null;
            if (this.mCert != null) {
                try {
                    certB64 = Utils.base64encode((byte[])this.mCert.getEncoded(), (boolean)true).replaceAll("\n", "").replaceAll("\r", "");
                    if (transportCert.equals(certB64)) {
                        cert = this.mCert;
                        logger.debug("TransportKeyUnit:  Transport certificate verified");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cert == null && this.mNewCert != null) {
                try {
                    certB64 = Utils.base64encode((byte[])this.mNewCert.getEncoded(), (boolean)true).replaceAll("\n", "").replaceAll("\r", "");
                    if (transportCert.equals(certB64)) {
                        cert = this.mNewCert;
                        logger.debug("TransportKeyUnit:  New transport certificate verified");
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            cert = this.mCert;
        }
        return cert;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.mCert.getPublicKey();
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.getPrivateKey(this.mCert);
    }

    @Override
    public PrivateKey getPrivateKey(X509Certificate cert) {
        if (cert == null) {
            cert = this.mCert;
        }
        try {
            return this.mManager.findPrivKeyByCert(cert);
        }
        catch (TokenException e) {
            return null;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public void verify(byte[] publicKey, PrivateKey privateKey) throws EBaseException {
    }

    public SymmetricKey unwrap_sym(byte[] encSymmKey, WrappingParams params) throws Exception {
        return this.unwrap_session_key(this.getToken(), encSymmKey, SymmetricKey.Usage.WRAP, params);
    }

    public byte[] decryptExternalPrivate(byte[] encSymmKey, String wrapOID, byte[] wrapIV, byte[] encValue, X509Certificate transCert) throws Exception {
        logger.debug("TransportKeyUnit.decryptExternalPrivate");
        if (transCert == null) {
            transCert = this.mCert;
        }
        CryptoToken token = this.getToken(transCert);
        PrivateKey wrappingKey = this.getPrivateKey(transCert);
        String priKeyAlgo = wrappingKey.getAlgorithm();
        WrappingParams params = WrappingParams.getWrappingParamsFromArchiveOptions((String)wrapOID, (String)priKeyAlgo, (IVParameterSpec)new IVParameterSpec(wrapIV));
        KeyWrapAlgorithm skWrapAlgorithm = null;
        skWrapAlgorithm = priKeyAlgo == "RSA" ? this.rsaKeyWrapAlg : params.getSkWrapAlgorithm();
        SymmetricKey sk = CryptoUtil.unwrap((CryptoToken)token, (SymmetricKey.Type)params.getSkType(), (int)(params.getSkType().equals(SymmetricKey.DES3) ? 0 : params.getSkLength()), (SymmetricKey.Usage)SymmetricKey.Usage.DECRYPT, (PrivateKey)wrappingKey, (byte[])encSymmKey, (KeyWrapAlgorithm)skWrapAlgorithm);
        return CryptoUtil.decryptUsingSymmetricKey((CryptoToken)token, (IVParameterSpec)params.getPayloadEncryptionIV(), (byte[])encValue, (SymmetricKey)sk, (EncryptionAlgorithm)params.getPayloadEncryptionAlgorithm());
    }

    public SymmetricKey unwrap_symmetric(byte[] encSymmKey, String symmAlgOID, byte[] symmAlgParams, byte[] encValue, SymmetricKey.Type algorithm, int strength) throws Exception {
        CryptoToken token = this.getToken();
        PrivateKey wrappingKey = this.getPrivateKey(this.mCert);
        String priKeyAlgo = wrappingKey.getAlgorithm();
        WrappingParams params = new WrappingParams(symmAlgOID, null, priKeyAlgo, new IVParameterSpec(symmAlgParams), null);
        SymmetricKey sk = this.unwrap_session_key(token, encSymmKey, SymmetricKey.Usage.UNWRAP, params);
        return CryptoUtil.unwrap((CryptoToken)token, (SymmetricKey.Type)algorithm, (int)strength, (SymmetricKey.Usage)SymmetricKey.Usage.DECRYPT, (SymmetricKey)sk, (byte[])encValue, (KeyWrapAlgorithm)params.getPayloadWrapAlgorithm(), (IVParameterSpec)params.getPayloadEncryptionIV());
    }

    public PrivateKey unwrap(byte[] encSymmKey, String wrapOID, byte[] wrapIV, byte[] encValue, PublicKey pubKey, X509Certificate transCert) throws Exception {
        CryptoToken token = this.getToken(transCert);
        PrivateKey wrappingKey = this.getPrivateKey(transCert);
        String priKeyAlgo = wrappingKey.getAlgorithm();
        WrappingParams params = WrappingParams.getWrappingParamsFromArchiveOptions((String)wrapOID, (String)priKeyAlgo, (IVParameterSpec)new IVParameterSpec(wrapIV));
        KeyWrapAlgorithm skWrapAlgorithm = null;
        skWrapAlgorithm = priKeyAlgo == "RSA" ? this.rsaKeyWrapAlg : params.getSkWrapAlgorithm();
        SymmetricKey sk = CryptoUtil.unwrap((CryptoToken)token, (SymmetricKey.Type)params.getSkType(), (int)(params.getSkType().equals(SymmetricKey.DES3) ? 0 : params.getSkLength()), (SymmetricKey.Usage)SymmetricKey.Usage.UNWRAP, (PrivateKey)wrappingKey, (byte[])encSymmKey, (KeyWrapAlgorithm)skWrapAlgorithm);
        return CryptoUtil.unwrap((CryptoToken)token, (PublicKey)pubKey, (boolean)true, (SymmetricKey)sk, (byte[])encValue, (KeyWrapAlgorithm)params.getPayloadWrapAlgorithm(), (IVParameterSpec)params.getPayloadWrappingIV());
    }
}

