/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.kra.EKRAException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryProcessedEvent;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.EncryptionUnit;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.TransportKeyUnit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.util.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenKeyRecoveryService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(TokenKeyRecoveryService.class);
    public static final String ATTR_NICKNAME = "nickname";
    public static final String ATTR_OWNER_NAME = "ownerName";
    public static final String ATTR_PUBLIC_KEY_DATA = "publicKeyData";
    public static final String ATTR_PRIVATE_KEY_DATA = "privateKeyData";
    public static final String ATTR_TRANSPORT_CERT = "transportCert";
    public static final String ATTR_TRANSPORT_PWD = "transportPwd";
    public static final String ATTR_SIGNING_CERT = "signingCert";
    public static final String ATTR_PKCS12 = "pkcs12";
    public static final String ATTR_ENCRYPTION_CERTS = "encryptionCerts";
    public static final String ATTR_AGENT_CREDENTIALS = "agentCredentials";
    public static final String ATTR_USER_CERT = "cert";
    public static final String ATTR_DELIVERY = "delivery";
    private KeyRecoveryAuthority mKRA;
    private KeyRepository mStorage;
    private IStorageKeyUnit mStorageUnit = null;
    private TransportKeyUnit mTransportUnit;

    public TokenKeyRecoveryService(KeyRecoveryAuthority kra) {
        this.mKRA = kra;
        this.mStorage = this.mKRA.getKeyRepository();
        this.mStorageUnit = this.mKRA.getStorageKeyUnit();
        this.mTransportUnit = kra.getTransportKeyUnit();
    }

    protected String URLdecode(String s) {
        if (s == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+') {
                out.write(32);
                continue;
            }
            if (c == '%') {
                int c1 = Character.digit(s.charAt(++i), 16);
                int c2 = Character.digit(s.charAt(++i), 16);
                out.write((char)(c1 * 16 + c2));
                continue;
            }
            out.write(c);
        }
        return out.toString();
    }

    public static String normalizeCertStr(String s) {
        StringBuffer val = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (s.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (s.charAt(i) == '\"' || s.charAt(i) == ' ') continue;
            val.append(s.charAt(i));
        }
        return val.toString();
    }

    private static String base64Encode(byte[] bytes) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(bytes);
            b64.flush();
            String string = output.toString("8859_1");
            return string;
        }
    }

    public synchronized boolean serviceRequest(Request request) throws EBaseException {
        X509CertImpl x509cert;
        BigInteger keyid;
        String cert;
        KeyId keyId;
        String auditSubjectID;
        Auditor auditor;
        String rUserid;
        String rCUID;
        PK11SymKey sk;
        Hashtable<String, Object> params;
        String agentId;
        RequestId auditRequestID;
        byte[] iv;
        Boolean allowEncDecrypt_recovery;
        JssSubsystem jssSubsystem;
        String iv_s;
        block40: {
            iv_s = "";
            logger.debug("KRA services token key recovery request");
            KRAEngine engine = KRAEngine.getInstance();
            jssSubsystem = engine.getJSSSubsystem();
            KRAEngineConfig config = null;
            allowEncDecrypt_recovery = false;
            boolean useOAEPKeyWrap = false;
            try {
                config = engine.getConfig();
                allowEncDecrypt_recovery = config.getBoolean("kra.allowEncDecrypt.recovery", false);
                useOAEPKeyWrap = config.getUseOAEPKeyWrap();
            }
            catch (Exception e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
            }
            iv = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
            try {
                SecureRandom random = jssSubsystem.getRandomNumberGenerator();
                random.nextBytes(iv);
            }
            catch (Exception e) {
                logger.error("TokenKeyRecoveryService.serviceRequest: " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
            auditRequestID = request.getRequestId();
            SessionContext sContext = SessionContext.getContext();
            agentId = "";
            if (sContext != null) {
                agentId = (String)sContext.get((Object)"userid");
            }
            if ((params = this.mKRA.getVolatileRequest(request.getRequestId())) == null) {
                logger.warn("getVolatileRequest params null");
            }
            byte[] wrapped_des_key = null;
            sk = null;
            rCUID = request.getExtDataInString("CUID");
            rUserid = request.getExtDataInString("USERID");
            String rWrappedDesKeyString = request.getExtDataInString("drm_trans_desKey");
            request.setExtData("delayLDAPCommit", "true");
            request.setExtData("drm_trans_desKey", "");
            auditor = engine.getAuditor();
            auditSubjectID = rCUID + ":" + rUserid;
            logger.debug("TokenKeyRecoveryService: received DRM-trans-wrapped des key");
            wrapped_des_key = Utils.SpecialDecode((String)rWrappedDesKeyString);
            logger.debug("TokenKeyRecoveryService: wrapped_des_key specialDecoded");
            if (wrapped_des_key != null && wrapped_des_key.length > 0) {
                KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
                if (useOAEPKeyWrap) {
                    wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
                }
                WrappingParams wrapParams = new WrappingParams(SymmetricKey.DES3, KeyGenAlgorithm.DES3, 0, wrapAlg, EncryptionAlgorithm.DES3_CBC_PAD, KeyWrapAlgorithm.DES3_CBC_PAD, EncryptionUnit.IV, EncryptionUnit.IV);
                try {
                    sk = (PK11SymKey)this.mTransportUnit.unwrap_sym(wrapped_des_key, wrapParams);
                    logger.debug("TokenKeyRecoveryService: received des key");
                }
                catch (Exception e) {
                    logger.debug("TokenKeyRecoveryService: no des key");
                    request.setExtData("Result", Integer.valueOf(4));
                }
            } else {
                logger.warn("TokenKeyRecoveryService: not receive des key");
                request.setExtData("Result", Integer.valueOf(4));
                auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, null, "TokenRecoveryService: Did not receive DES key", agentId));
                return false;
            }
            String cert_s = request.getExtDataInString(ATTR_USER_CERT);
            String keyid_s = request.getExtDataInString("keyid");
            KeyId keyId2 = keyId = keyid_s != null ? new KeyId(keyid_s) : null;
            if (cert_s == null && keyid_s == null) {
                logger.warn("TokenKeyRecoveryService: not receive cert or keyid");
                request.setExtData("Result", Integer.valueOf(3));
                auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenRecoveryService: Did not receive cert or keyid", agentId));
                return false;
            }
            cert = null;
            keyid = null;
            x509cert = null;
            if (keyid_s == null) {
                cert = TokenKeyRecoveryService.normalizeCertStr(cert_s);
                try {
                    x509cert = Cert.mapCert((String)cert);
                    if (x509cert == null) {
                        logger.warn("cert mapping failed");
                        request.setExtData("Result", Integer.valueOf(5));
                        auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenRecoveryService: cert mapping failed", agentId));
                        return false;
                    }
                    break block40;
                }
                catch (IOException e) {
                    logger.warn("TokenKeyRecoveryService: mapCert failed");
                    request.setExtData("Result", Integer.valueOf(6));
                    auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenRecoveryService: mapCert failed: " + e.getMessage(), agentId));
                    return false;
                }
            }
            keyid = new BigInteger(keyid_s);
        }
        try {
            byte[] wrapped;
            Boolean encrypted;
            CryptoToken token = this.mStorageUnit.getToken();
            logger.debug("TokenKeyRecoveryService: got token slot:" + token.getName());
            IVParameterSpec algParam = new IVParameterSpec(iv);
            KeyRecord keyRecord = null;
            logger.debug("KRA reading key record");
            try {
                if (keyid != null) {
                    logger.debug("TokenKeyRecoveryService: recover by keyid");
                    keyRecord = this.mStorage.readKeyRecord(keyid);
                } else {
                    logger.debug("TokenKeyRecoveryService: recover by cert");
                    keyRecord = this.mStorage.readKeyRecord(cert);
                }
                if (keyRecord == null) {
                    logger.warn("key record not found");
                    request.setExtData("Result", Integer.valueOf(8));
                    auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenRecoveryService: key record not found", agentId));
                    return false;
                }
                logger.debug("read key record");
            }
            catch (Exception e) {
                logger.warn("TokenKeyRecoveryService: " + e.getMessage(), (Throwable)e);
                request.setExtData("Result", Integer.valueOf(9));
                auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenRecoveryService: error reading key record: " + e.getMessage(), agentId));
                return false;
            }
            String owner = keyRecord.getOwnerName();
            logger.debug("TokenKeyRecoveryService: owner name on record =" + owner);
            logger.debug("TokenKeyRecoveryService: owner name from TPS =" + rCUID + ":" + rUserid);
            if (owner != null) {
                if (owner.equals(rCUID + ":" + rUserid)) {
                    logger.debug("TokenKeyRecoveryService: owner name matches");
                } else {
                    logger.debug("TokenKeyRecoveryService: owner name mismatches");
                }
            }
            byte[] pubData = null;
            pubData = keyRecord.getPublicKeyData();
            if (keyid == null) {
                byte[] inputPubData = x509cert.getPublicKey().getEncoded();
                if (inputPubData.length != pubData.length) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_KEY_LEN", (Object[])new Object[0]));
                    auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_KEY_LEN", (Object[])new Object[0]), agentId));
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PUBLIC_KEY_NOT_MATCHED", (String[])new String[0]));
                }
                for (int i = 0; i < pubData.length; ++i) {
                    if (pubData[i] == inputPubData[i]) continue;
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_KEY_LEN", (Object[])new Object[0]));
                    auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_KEY_LEN", (Object[])new Object[0]), agentId));
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_PUBLIC_KEY_NOT_MATCHED", (String[])new String[0]));
                }
            }
            if ((encrypted = keyRecord.isEncrypted()) == null) {
                encrypted = allowEncDecrypt_recovery;
            }
            PrivateKey.Type keyType = PrivateKey.RSA;
            if (encrypted.booleanValue()) {
                byte[] privateKeyData = null;
                privateKeyData = this.recoverKey(params, keyRecord);
                if (privateKeyData == null) {
                    request.setExtData("Result", Integer.valueOf(4));
                    logger.warn("TokenKeyRecoveryService: failed getting private key");
                    auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenKeyRecoveryService: failed getting private key", agentId));
                    return false;
                }
                logger.debug("TokenKeyRecoveryService: got private key...about to verify");
                iv_s = Utils.SpecialEncode((byte[])iv);
                request.setExtData("iv_s", iv_s);
                logger.debug("request.setExtData: iv_s: " + iv_s);
                ByteArrayInputStream dis = new ByteArrayInputStream(privateKeyData);
                DerValue dv = new DerValue((InputStream)dis);
                byte[] p = dv.toByteArray();
                int l = p.length;
                logger.debug("length different data length=" + l + " real length=" + privateKeyData.length);
                if (l != privateKeyData.length) {
                    privateKeyData = p;
                }
                if (!this.verifyKeyPair(pubData, privateKeyData)) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_NOT_FOUND", (Object[])new Object[0]));
                    auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, CMS.getLogMessage((String)"CMSCORE_KRA_PUBLIC_NOT_FOUND", (Object[])new Object[0]), agentId));
                    jssSubsystem.obscureBytes(privateKeyData);
                    jssSubsystem.obscureBytes(p);
                    throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PUBLIC_KEY", (String[])new String[0]));
                }
                logger.debug("TokenKeyRecoveryService: private key verified with public key");
                wrapped = CryptoUtil.encryptUsingSymmetricKey((CryptoToken)token, (SymmetricKey)sk, (byte[])privateKeyData, (EncryptionAlgorithm)EncryptionAlgorithm.DES3_CBC_PAD, (IVParameterSpec)algParam);
                jssSubsystem.obscureBytes(privateKeyData);
                jssSubsystem.obscureBytes(p);
            } else {
                PrivateKey privKey = this.recoverKey(params, keyRecord, allowEncDecrypt_recovery);
                if (privKey == null) {
                    request.setExtData("Result", Integer.valueOf(4));
                    logger.warn("TokenKeyRecoveryService: failed getting private key");
                    auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenKeyRecoveryService: failed getting private key", agentId));
                    return false;
                }
                logger.debug("TokenKeyRecoveryService: about to wrap...");
                wrapped = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)token, (SymmetricKey)sk, (PrivateKey)privKey, (IVParameterSpec)algParam, (KeyWrapAlgorithm)KeyWrapAlgorithm.DES3_CBC_PAD);
                iv_s = Utils.SpecialEncode((byte[])iv);
                request.setExtData("iv_s", iv_s);
            }
            String wrappedPrivKeyString = Utils.SpecialEncode((byte[])wrapped);
            if (wrappedPrivKeyString == null) {
                request.setExtData("Result", Integer.valueOf(4));
                logger.warn("TokenKeyRecoveryService: failed generating wrapped private key");
                auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenKeyRecoveryService: failed generating wrapped private key", agentId));
                return false;
            }
            logger.debug("TokenKeyRecoveryService: got private key data wrapped");
            request.setExtData("wrappedUserPrivate", wrappedPrivKeyString);
            request.setExtData("Result", Integer.valueOf(1));
            logger.debug("TokenKeyRecoveryService: key for " + rCUID + ":" + rUserid + " recovered");
            String PubKey = "";
            if (keyType == PrivateKey.EC) {
                PubKey = Utils.SpecialEncode((byte[])pubData);
                logger.debug("TokenKeyRecoveryService: EC PubKey special encoded");
            } else {
                PubKey = TokenKeyRecoveryService.base64Encode(pubData);
                logger.debug("TokenKeyRecoveryService: RSA PubKey base64 encoded");
            }
            auditor.log((LogEvent)new SecurityDataRecoveryEvent(auditSubjectID, "Success", auditRequestID, null, PubKey));
            if (PubKey == null) {
                request.setExtData("Result", Integer.valueOf(4));
                logger.warn("TokenKeyRecoveryService: failed getting publickey encoded");
                auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRequestID, keyId, "TokenKeyRecoveryService: failed getting publickey encoded", agentId));
                return false;
            }
            logger.debug("TokenKeyRecoveryService: got publicKeyData");
            request.setExtData("public_key", PubKey);
            auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Success", auditRequestID, keyId, null, agentId));
            return true;
        }
        catch (Exception e) {
            logger.warn("TokenKeyRecoveryService: " + e.getMessage(), (Throwable)e);
            request.setExtData("Result", Integer.valueOf(4));
            return true;
        }
    }

    public boolean verifyKeyPair(byte[] publicKeyData, byte[] privateKeyData) {
        try {
            DerValue publicKeyVal = new DerValue(publicKeyData);
            DerInputStream publicKeyIn = publicKeyVal.data;
            publicKeyIn.getSequence(0);
            DerValue publicKeyDer = new DerValue(publicKeyIn.getBitString());
            DerInputStream publicKeyDerIn = publicKeyDer.data;
            BigInt publicKeyModulus = publicKeyDerIn.getInteger();
            BigInt publicKeyExponent = publicKeyDerIn.getInteger();
            DerValue privateKeyVal = new DerValue(privateKeyData);
            if (privateKeyVal.tag != 48) {
                return false;
            }
            DerInputStream privateKeyIn = privateKeyVal.data;
            privateKeyIn.getInteger();
            privateKeyIn.getSequence(0);
            DerValue privateKeyDer = new DerValue(privateKeyIn.getOctetString());
            DerInputStream privateKeyDerIn = privateKeyDer.data;
            BigInt privateKeyVersion = privateKeyDerIn.getInteger();
            BigInt privateKeyModulus = privateKeyDerIn.getInteger();
            BigInt privateKeyExponent = privateKeyDerIn.getInteger();
            if (!publicKeyModulus.equals(privateKeyModulus)) {
                logger.warn("verifyKeyPair modulus mismatch publicKeyModulus=" + publicKeyModulus + " privateKeyModulus=" + privateKeyModulus);
                return false;
            }
            if (!publicKeyExponent.equals(privateKeyExponent)) {
                logger.warn("verifyKeyPair exponent mismatch publicKeyExponent=" + publicKeyExponent + " privateKeyExponent=" + privateKeyExponent);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("verifyKeyPair error " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public synchronized PrivateKey recoverKey(Hashtable<String, Object> request, KeyRecord keyRecord, boolean allowEncDecrypt_archival) throws EBaseException {
        logger.debug("TokenKeyRecoveryService: recoverKey() - with allowEncDecrypt_archival being false");
        if (allowEncDecrypt_archival) {
            logger.error("TokenKeyRecoveryService: recoverKey() - allowEncDecrypt_archival needs to be false for this call");
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"recoverKey, allowEncDecrypt_archival needs to be false for this call"}));
        }
        try {
            PublicKey pubkey = null;
            try {
                pubkey = X509Key.parsePublicKey((DerValue)new DerValue(keyRecord.getPublicKeyData()));
            }
            catch (Exception e) {
                logger.error("TokenKeyRecoverService: after parsePublicKey: " + e.getMessage(), (Throwable)e);
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"public key parsing failure"}));
            }
            PrivateKey privKey = null;
            try {
                privKey = this.mStorageUnit.unwrap(keyRecord.getPrivateKeyData(), pubkey, true, keyRecord.getWrappingParams(this.mStorageUnit.getOldWrappingParams()));
            }
            catch (Exception e) {
                logger.error("TokenKeyRecoveryService: recovery failure: " + e.getMessage(), (Throwable)e);
                throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"private key recovery/unwrapping failure"}), e);
            }
            logger.debug("TokenKeyRecoveryService: recoverKey() - recovery completed, returning privKey");
            return privKey;
        }
        catch (Exception e) {
            logger.error("TokenKeyRecoverService: failed with allowEncDecrypt_recovery=false: " + e.getMessage(), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"Exception:" + e.toString()}));
        }
    }

    public synchronized byte[] recoverKey(Hashtable<String, Object> request, KeyRecord keyRecord) throws EBaseException {
        logger.debug("TokenKeyRecoveryService: recoverKey() - with allowEncDecrypt_archival being true");
        try {
            return this.mStorageUnit.decryptInternalPrivate(keyRecord.getPrivateKeyData(), keyRecord.getWrappingParams(this.mStorageUnit.getOldWrappingParams()));
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_PRIVATE_KEY_NOT_FOUND", (Object[])new Object[0]), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"no private key"}), e);
        }
    }
}

