/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.connector;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.request.KeyRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="kraGenerateKeyPair", urlPatterns={"/agent/kra/GenerateKeyPair"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="ID", value="kraGenerateKeyPair"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.GenerateKeyPair")})
public class GenerateKeyPairServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GenerateKeyPairServlet.class);
    private static final long serialVersionUID = 4308385291961910458L;
    private static final String INFO = "GenerateKeyPairServlet";
    public static final String PROP_AUTHORITY = "authority";
    protected ServletConfig mConfig = null;
    protected IAuthority mAuthority = null;
    public static int ERROR = 1;
    PrettyPrintFormat pp = new PrettyPrintFormat(":");
    protected AuthSubsystem mAuthSubsystem;
    private Hashtable<String, String> supportedECCurves_ht = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mConfig = config;
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig sconfig = engine.getConfig();
        String authority = config.getInitParameter(PROP_AUTHORITY);
        if (authority != null) {
            this.mAuthority = (IAuthority)engine.getSubsystem(authority);
        }
        this.mAuthSubsystem = engine.getAuthSubsystem();
        String curveList = null;
        try {
            curveList = sconfig.getString("kra.keygen.curvelist", "nistp256,nistp384,nistp521");
        }
        catch (EBaseException e) {
            curveList = "nistp256,nistp384,nistp521";
        }
        this.supportedECCurves_ht = new Hashtable();
        String[] supportedECCurves = curveList.split(",");
        for (int i = 0; i < supportedECCurves.length; ++i) {
            this.supportedECCurves_ht.put(supportedECCurves[i], supportedECCurves[i]);
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    private void processServerSideKeyGen(HttpServletRequest req, HttpServletResponse resp) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        RequestQueue queue = engine.getRequestQueue();
        Request thisreq = null;
        boolean missingParam = false;
        String status = "0";
        logger.debug("processServerSideKeyGen begins:");
        String rCUID = req.getParameter("tokencuid");
        String rUserid = req.getParameter("userid");
        String rdesKeyString = req.getParameter("drm_trans_desKey");
        String rArchive = req.getParameter("archive");
        String rKeysize = req.getParameter("keysize");
        String rKeytype = req.getParameter("keytype");
        String rKeycurve = req.getParameter("eckeycurve");
        if (rCUID == null || rCUID.equals("")) {
            logger.warn("GenerateKeyPairServlet: processServerSideKeygen(): missing request parameter: CUID");
            missingParam = true;
        }
        if (rUserid == null || rUserid.equals("")) {
            logger.warn("GenerateKeyPairServlet: processServerSideKeygen(): missing request parameter: userid");
            missingParam = true;
        }
        if (rKeytype == null || rKeytype.equals("")) {
            rKeytype = "RSA";
        }
        if (!rKeytype.equals("EC") && (rKeysize == null || rKeysize.equals(""))) {
            rKeysize = "1024";
        }
        if (rKeytype.equals("EC")) {
            boolean isSupportedCurve;
            if (rKeycurve == null || rKeycurve.equals("")) {
                rKeycurve = "nistp256";
            }
            if (!(isSupportedCurve = this.supportedECCurves_ht.containsKey(rKeycurve))) {
                logger.warn("GenerateKeyPairServlet: processServerSideKeygen(): unsupported curve:" + rKeycurve);
                missingParam = true;
            } else {
                logger.debug("GenerateKeyPairServlet: processServerSideKeygen(): curve to be generated:" + rKeycurve);
            }
        }
        if (rdesKeyString == null || rdesKeyString.equals("")) {
            logger.warn("GenerateKeyPairServlet: processServerSideKeygen(): missing request parameter: DRM-transportKey-wrapped DES key");
            missingParam = true;
        }
        if (rArchive == null || rArchive.equals("")) {
            logger.debug("GenerateKeyPairServlet: processServerSideKeygen(): missing key archival flag 'archive' ,default to true");
            rArchive = "true";
        }
        if (!missingParam) {
            thisreq = requestRepository.createRequest("netkeyKeygen");
            thisreq.setExtData("requestorType", "NETKEY_RA");
            thisreq.setExtData("CUID", rCUID);
            thisreq.setExtData("USERID", rUserid);
            thisreq.setExtData("drm_trans_desKey", rdesKeyString);
            thisreq.setExtData("archive", rArchive);
            thisreq.setExtData("keysize", rKeysize);
            thisreq.setExtData("keytype", rKeytype);
            thisreq.setExtData("eckeycurve", rKeycurve);
            queue.processRequest(thisreq);
            Integer result = thisreq.getExtDataInInteger("Result");
            status = result != null ? (result == 1 ? "0" : result.toString()) : "7";
            logger.debug("processServerSideKeygen finished");
        }
        Object value = "";
        resp.setContentType("application/x-www-form-urlencoded");
        String wrappedPrivKeyString = "";
        String publicKeyString = "";
        if (thisreq == null) {
            logger.error("GenerateKeyPairServlet::processServerSideKeyGen() - thisreq is null!");
            throw new EBaseException("thisreq is null");
        }
        publicKeyString = thisreq.getExtDataInString("public_key");
        wrappedPrivKeyString = thisreq.getExtDataInString("wrappedUserPrivate");
        String ivString = thisreq.getExtDataInString("iv_s");
        thisreq.setExtData("wrappedUserPrivate", "");
        thisreq.setExtData("public_key", "");
        thisreq.setExtData("iv_s", "");
        thisreq.setExtData("drm_trans_desKey", "");
        thisreq.deleteExtData("wrappedUserPrivate");
        thisreq.deleteExtData("public_key");
        thisreq.deleteExtData("iv_s");
        thisreq.deleteExtData("drm_trans_desKey");
        thisreq.setExtData("delayLDAPCommit", "false");
        requestRepository.updateRequest(thisreq);
        if (!status.equals("0")) {
            value = "status=" + status;
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("status=0&");
            sb.append("wrapped_priv_key=");
            sb.append(wrappedPrivKeyString);
            sb.append("&iv_param=");
            sb.append(ivString);
            sb.append("&public_key=");
            sb.append(publicKeyString);
            value = sb.toString();
        }
        try {
            resp.setContentLength(((String)value).length());
            logger.debug("GenerateKeyPairServlet:outputString.length " + ((String)value).length());
            ServletOutputStream ooss = resp.getOutputStream();
            ooss.write(((String)value).getBytes());
            ooss.flush();
            this.mRenderResult = false;
        }
        catch (IOException e) {
            logger.warn("GenerateKeyPairServlet: " + e.getMessage(), (Throwable)e);
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "execute");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            try {
                resp.setContentType("application/x-www-form-urlencoded");
                String value = "unauthorized=";
                logger.warn("GenerateKeyPairServlet: Unauthorized");
                resp.setContentLength(value.length());
                ServletOutputStream ooss = resp.getOutputStream();
                ooss.write(value.getBytes());
                ooss.flush();
                this.mRenderResult = false;
            }
            catch (Exception e) {
                logger.warn("GenerateKeyPairServlet: " + e.getMessage(), (Throwable)e);
            }
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        logger.debug("GenerateKeyPairServlet: processServerSideKeyGen would be called");
        this.processServerSideKeyGen(req, resp);
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }
}

