/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.http;

import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.http.ConnectAsync;
import com.netscape.cmsutil.net.ISocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLSocketListener;

public class JssSSLSocketFactory
implements ISocketFactory {
    private String mClientAuthCertNickname = null;
    private String mClientCiphers = null;
    private SSLSocket s = null;
    private SSLSocketListener sockListener = null;

    public JssSSLSocketFactory() {
    }

    public JssSSLSocketFactory(String certNickname) {
        this.mClientAuthCertNickname = certNickname;
    }

    public JssSSLSocketFactory(String certNickname, String ciphers) {
        if (certNickname != null) {
            this.mClientAuthCertNickname = certNickname;
        }
        if (ciphers != null) {
            this.mClientCiphers = ciphers.trim();
            try {
                if (!this.mClientCiphers.isEmpty()) {
                    CryptoUtil.setClientCiphers(this.mClientCiphers);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Socket makeSocket(String host, int port) throws IOException, UnknownHostException {
        return this.makeSocket(host, port, null, null, 0);
    }

    @Override
    public Socket makeSocket(String host, int port, SSLCertificateApprovalCallback certApprovalCallback, SSLClientCertificateSelectionCallback clientCertCallback, int timeout) throws IOException, UnknownHostException {
        try {
            this.s = new SSLSocket(host, port, null, 0, certApprovalCallback, clientCertCallback);
            this.s.setUseClientMode(true);
            this.s.setSoTimeout(timeout);
            ClientHandshakeCB listener = null;
            listener = new ClientHandshakeCB(this);
            this.s.addHandshakeCompletedListener((SSLHandshakeCompletedListener)listener);
            if (this.sockListener != null) {
                this.s.addSocketListener(this.sockListener);
            }
            if (this.mClientAuthCertNickname != null) {
                CryptoManager.getInstance().findCertByNickname(this.mClientAuthCertNickname);
                this.s.setClientCertNickname(this.mClientAuthCertNickname);
            }
            this.s.forceHandshake();
        }
        catch (ObjectNotFoundException e) {
            throw new IOException(e.toString(), e);
        }
        catch (TokenException e) {
            throw new IOException(e.toString(), e);
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.toString(), e);
        }
        return this.s;
    }

    @Override
    public Socket makeSocket(String host, int port, int timeout) throws IOException, UnknownHostException {
        ConnectAsync t = new ConnectAsync(this, host, port);
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t.isAlive()) {
            // empty if block
        }
        return this.s;
    }

    public void addSocketListener(SSLSocketListener sl) {
        this.sockListener = sl;
    }

    static class ClientHandshakeCB
    implements SSLHandshakeCompletedListener {
        Object sc;

        public ClientHandshakeCB(Object sc) {
            this.sc = sc;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
        }
    }
}

