/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.http;

import com.netscape.cmsutil.http.HttpMessage;
import com.netscape.cmsutil.http.HttpProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class HttpRequest
extends HttpMessage {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HEAD = "HEAD";
    protected String mMethod = null;
    protected String mURI = null;
    protected String mHttpVers = null;

    public void setMethod(String method) throws HttpProtocolException {
        if (!(method.equals(GET) || method.equals(HEAD) || method.equals(POST))) {
            throw new HttpProtocolException("No such method " + method);
        }
        this.mMethod = method;
    }

    public void setURI(String uri) {
        this.mURI = uri;
    }

    @Override
    public void write(OutputStreamWriter writer) throws IOException {
        if (this.mMethod == null || this.mURI == null) {
            HttpProtocolException e = new HttpProtocolException("Http request method or uri not initialized");
            throw e;
        }
        String protocol = this.getHeader("host") != null ? "HTTP/1.1" : "HTTP/1.0";
        this.mLine = this.mMethod + " " + this.mURI + " " + protocol;
        super.write(writer);
    }

    @Override
    public void parse(BufferedReader reader) throws IOException {
        super.parse(reader);
        int method = this.mLine.indexOf(32);
        this.mMethod = this.mLine.substring(0, method);
        if (!(this.mMethod.equals(GET) || this.mMethod.equals(POST) || this.mMethod.equals(HEAD))) {
            this.reset();
            throw new HttpProtocolException("Bad Http request method");
        }
        int uri = this.mLine.lastIndexOf(32);
        this.mURI = this.mLine.substring(method + 1, uri);
        this.mHttpVers = this.mLine.substring(uri + 1);
        if (!(this.mHttpVers.equals("") || this.mHttpVers.equals("HTTP/1.0") || this.mHttpVers.equals("HTTP/1.1"))) {
            this.reset();
            throw new HttpProtocolException("Bad Http version in request");
        }
    }

    @Override
    public void reset() {
        this.mMethod = null;
        this.mURI = null;
        this.mHttpVers = null;
        super.reset();
    }

    public String getMethod() {
        return this.mMethod;
    }

    public String getURI() {
        return this.mURI;
    }

    public String getHttpVers() {
        return this.mHttpVers;
    }
}

