/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NicknameConflictException;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.UserCertConflictException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.TeletexString;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.asn1.UniversalString;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenCertificate;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attribute;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attributes;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.PKCS9Attribute;
import org.mozilla.jss.netscape.security.pkcs.ParsingException;
import org.mozilla.jss.netscape.security.provider.DSAPublicKey;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500Signer;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs7.IssuerAndSerialNumber;
import org.mozilla.jss.pkcs7.RecipientInfo;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncryptedContentInfo;
import org.mozilla.jss.pkix.cms.EnvelopedData;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.crmf.EncryptedKey;
import org.mozilla.jss.pkix.crmf.EncryptedValue;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.Base64OutputStream;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    private static Logger logger = LoggerFactory.getLogger(CryptoUtil.class);
    public static final int KEY_ID_LENGTH = 20;
    public static final String INTERNAL_TOKEN_NAME = "internal";
    public static final String INTERNAL_TOKEN_FULL_NAME = "Internal Key Storage Token";
    public static final int LINE_COUNT = 76;
    private static SymmetricKey.Usage[] sess_key_usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
    public static final KeyPairGeneratorSpi.Usage[] ECDHE_USAGES_MASK = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.DERIVE};
    public static final KeyPairGeneratorSpi.Usage[] ECDH_USAGES_MASK = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.SIGN, KeyPairGeneratorSpi.Usage.SIGN_RECOVER};
    public static final KeyPairGeneratorSpi.Usage[] RSA_KEYPAIR_USAGES = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.ENCRYPT, KeyPairGeneratorSpi.Usage.DECRYPT, KeyPairGeneratorSpi.Usage.WRAP, KeyPairGeneratorSpi.Usage.UNWRAP, KeyPairGeneratorSpi.Usage.SIGN, KeyPairGeneratorSpi.Usage.SIGN_RECOVER};
    public static final KeyPairGeneratorSpi.Usage[] RSA_KEYPAIR_USAGES_MASK = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.ENCRYPT, KeyPairGeneratorSpi.Usage.DECRYPT, KeyPairGeneratorSpi.Usage.WRAP, KeyPairGeneratorSpi.Usage.UNWRAP, KeyPairGeneratorSpi.Usage.SIGN, KeyPairGeneratorSpi.Usage.SIGN_RECOVER};
    public static final Integer[] clientECCiphers = new Integer[]{49161, 49162, 49187, 49195, 52393, 49188, 49196};
    public static List<Integer> clientECCipherList = new ArrayList<Integer>(Arrays.asList(clientECCiphers));
    private static final String[] ecCurves = new String[]{"nistp256", "nistp384", "nistp521", "sect163k1", "nistk163", "sect163r1", "sect163r2", "nistb163", "sect193r1", "sect193r2", "sect233k1", "nistk233", "sect233r1", "nistb233", "sect239k1", "sect283k1", "nistk283", "sect283r1", "nistb283", "sect409k1", "nistk409", "sect409r1", "nistb409", "sect571k1", "nistk571", "sect571r1", "nistb571", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "nistp192", "secp224k1", "secp224r1", "nistp224", "secp256k1", "secp256r1", "secp384r1", "secp521r1", "prime192v1", "prime192v2", "prime192v3", "prime239v1", "prime239v2", "prime239v3", "c2pnb163v1", "c2pnb163v2", "c2pnb163v3", "c2pnb176v1", "c2tnb191v1", "c2tnb191v2", "c2tnb191v3", "c2pnb208w1", "c2tnb239v1", "c2tnb239v2", "c2tnb239v3", "c2pnb272w1", "c2pnb304w1", "c2tnb359w1", "c2pnb368w1", "c2tnb431r1", "secp112r1", "secp112r2", "secp128r1", "secp128r2", "sect113r1", "sect113r2", "sect131r1", "sect131r2"};
    public static final Map<String, Vector<String>> ecOIDs = Map.ofEntries(Map.entry("1.2.840.10045.3.1.7", new Vector<String>(List.of("nistp256", "secp256r1"))), Map.entry("1.3.132.0.34", new Vector<String>(List.of("nistp384", "secp384r1"))), Map.entry("1.3.132.0.35", new Vector<String>(List.of("nistp521", "secp521r1"))), Map.entry("1.3.132.0.1", new Vector<String>(List.of("sect163k1", "nistk163"))), Map.entry("1.3.132.0.2", new Vector<String>(List.of("sect163r1"))), Map.entry("1.3.132.0.15", new Vector<String>(List.of("sect163r2", "nistb163"))), Map.entry("1.3.132.0.24", new Vector<String>(List.of("sect193r1"))), Map.entry("1.3.132.0.25", new Vector<String>(List.of("sect193r2"))), Map.entry("1.3.132.0.26", new Vector<String>(List.of("sect233k1", "nistk233"))), Map.entry("1.3.132.0.27", new Vector<String>(List.of("sect233r1", "nistb233"))), Map.entry("1.3.132.0.3", new Vector<String>(List.of("sect239k1"))), Map.entry("1.3.132.0.16", new Vector<String>(List.of("sect283k1", "nistk283"))), Map.entry("1.3.132.0.17", new Vector<String>(List.of("sect283r1", "nistb283"))), Map.entry("1.3.132.0.36", new Vector<String>(List.of("sect409k1", "nistk409"))), Map.entry("1.3.132.0.37", new Vector<String>(List.of("sect409r1", "nistb409"))), Map.entry("1.3.132.0.38", new Vector<String>(List.of("sect571k1", "nistk571"))), Map.entry("1.3.132.0.39", new Vector<String>(List.of("sect571r1", "nistb571"))), Map.entry("1.3.132.0.9", new Vector<String>(List.of("secp160k1"))), Map.entry("1.3.132.0.8", new Vector<String>(List.of("secp160r1"))), Map.entry("1.3.132.0.30", new Vector<String>(List.of("secp160r2"))), Map.entry("1.3.132.0.31", new Vector<String>(List.of("secp192k1"))), Map.entry("1.2.840.10045.3.1.1", new Vector<String>(List.of("secp192r1", "nistp192", "prime192v1"))), Map.entry("1.3.132.0.32", new Vector<String>(List.of("secp224k1"))), Map.entry("1.3.132.0.33", new Vector<String>(List.of("secp224r1", "nistp224"))), Map.entry("1.3.132.0.10", new Vector<String>(List.of("secp256k1"))), Map.entry("1.2.840.10045.3.1.2", new Vector<String>(List.of("prime192v2"))), Map.entry("1.2.840.10045.3.1.3", new Vector<String>(List.of("prime192v3"))), Map.entry("1.2.840.10045.3.1.4", new Vector<String>(List.of("prime239v1"))), Map.entry("1.2.840.10045.3.1.5", new Vector<String>(List.of("prime239v2"))), Map.entry("1.2.840.10045.3.1.6", new Vector<String>(List.of("prime239v3"))), Map.entry("1.2.840.10045.3.0.1", new Vector<String>(List.of("c2pnb163v1"))), Map.entry("1.2.840.10045.3.0.2", new Vector<String>(List.of("c2pnb163v2"))), Map.entry("1.2.840.10045.3.0.3", new Vector<String>(List.of("c2pnb163v3"))), Map.entry("1.2.840.10045.3.0.4", new Vector<String>(List.of("c2pnb176v1"))), Map.entry("1.2.840.10045.3.0.5", new Vector<String>(List.of("c2tnb191v1"))), Map.entry("1.2.840.10045.3.0.6", new Vector<String>(List.of("c2tnb191v2"))), Map.entry("1.2.840.10045.3.0.7", new Vector<String>(List.of("c2tnb191v3"))), Map.entry("1.2.840.10045.3.0.10", new Vector<String>(List.of("c2pnb208w1"))), Map.entry("1.2.840.10045.3.0.11", new Vector<String>(List.of("c2tnb239v1"))), Map.entry("1.2.840.10045.3.0.12", new Vector<String>(List.of("c2tnb239v2"))), Map.entry("1.2.840.10045.3.0.13", new Vector<String>(List.of("c2tnb239v3"))), Map.entry("1.2.840.10045.3.0.16", new Vector<String>(List.of("c2pnb272w1"))), Map.entry("1.2.840.10045.3.0.17", new Vector<String>(List.of("c2pnb304w1"))), Map.entry("1.2.840.10045.3.0.19", new Vector<String>(List.of("c2pnb368w1"))), Map.entry("1.2.840.10045.3.0.20", new Vector<String>(List.of("c2tnb431r1"))), Map.entry("1.3.132.0.6", new Vector<String>(List.of("secp112r1"))), Map.entry("1.3.132.0.7", new Vector<String>(List.of("secp112r2"))), Map.entry("1.3.132.0.28", new Vector<String>(List.of("secp128r1"))), Map.entry("1.3.132.0.29", new Vector<String>(List.of("secp128r2"))), Map.entry("1.3.132.0.4", new Vector<String>(List.of("sect113r1"))), Map.entry("1.3.132.0.5", new Vector<String>(List.of("sect113r2"))), Map.entry("1.3.132.0.22", new Vector<String>(List.of("sect131r1"))), Map.entry("1.3.132.0.23", new Vector<String>(List.of("sect131r2"))));
    public static OBJECT_IDENTIFIER RSA_ENCRYPTION = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 1L});

    private CryptoUtil() {
    }

    public static boolean arraysEqual(byte[] bytes, byte[] ints) {
        if (bytes == null || ints == null) {
            return false;
        }
        if (bytes.length != ints.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == ints[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isInternalToken(String name) {
        return StringUtils.isEmpty((CharSequence)name) || name.equalsIgnoreCase(INTERNAL_TOKEN_NAME) || name.equalsIgnoreCase(INTERNAL_TOKEN_FULL_NAME);
    }

    public static CryptoToken getCryptoToken(String name) throws NotInitializedException, NoSuchTokenException {
        CryptoManager cm = CryptoManager.getInstance();
        if (CryptoUtil.isInternalToken(name)) {
            return cm.getInternalCryptoToken();
        }
        return cm.getTokenByName(name);
    }

    public static CryptoToken getKeyStorageToken(String name) throws NotInitializedException, NoSuchTokenException {
        CryptoManager cm = CryptoManager.getInstance();
        if (CryptoUtil.isInternalToken(name)) {
            return cm.getInternalKeyStorageToken();
        }
        return cm.getTokenByName(name);
    }

    public static KeyPair generateRSAKeyPair(CryptoToken token, int keySize) throws Exception {
        return CryptoUtil.generateRSAKeyPair(token, keySize, null, null);
    }

    public static KeyPair generateRSAKeyPair(CryptoToken token, int keySize, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        return CryptoUtil.generateRSAKeyPair(token, keySize, false, false, false, usages, usagesMask);
    }

    public static KeyPair generateRSAKeyPair(CryptoToken token, int keySize, Boolean temporary, Boolean sensitive, Boolean extractable, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        logger.debug("CryptoUtil: Generating KRA key pair");
        KeyPairGenerator keygen = token.getKeyPairGenerator(KeyPairAlgorithm.RSA);
        logger.debug("CryptoUtil: - temporary: " + temporary);
        if (temporary != null) {
            keygen.temporaryPairs(temporary.booleanValue());
        }
        logger.debug("CryptoUtil: - sensitive: " + sensitive);
        if (sensitive != null) {
            keygen.sensitivePairs(sensitive.booleanValue());
        }
        logger.debug("CryptoUtil: - extractable: " + extractable);
        if (extractable != null) {
            keygen.extractablePairs(extractable.booleanValue());
        }
        keygen.setKeyPairUsages(usages, usagesMask);
        logger.debug("CryptoUtil: - key size: " + keySize);
        keygen.initialize(keySize);
        return keygen.genKeyPair();
    }

    public static boolean isECCKey(X509Key key) {
        String keyAlgo = key.getAlgorithm();
        return keyAlgo.equals("EC") || keyAlgo.equals("OID.1.2.840.10045.44");
    }

    public static KeyPair generateECCKeyPair(CryptoToken token, String curveName) throws Exception {
        return CryptoUtil.generateECCKeyPair(token, curveName, null, null);
    }

    public static KeyPair generateECCKeyPair(CryptoToken token, String curveName, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        return CryptoUtil.generateECCKeyPair(token, curveName, null, null, null, usages, usagesMask);
    }

    public static KeyPair generateECCKeyPair(CryptoToken token, String curveName, boolean temporary, int sensitive, int extractable, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        return CryptoUtil.generateECCKeyPair(token, curveName, (Boolean)temporary, sensitive == -1 ? null : Boolean.valueOf(sensitive == 1), extractable == -1 ? null : Boolean.valueOf(extractable == 1), usages, usagesMask);
    }

    public static KeyPair generateECCKeyPair(CryptoToken token, String curveName, Boolean temporary, Boolean sensitive, Boolean extractable, KeyPairGeneratorSpi.Usage[] usages, KeyPairGeneratorSpi.Usage[] usagesMask) throws Exception {
        logger.debug("CryptoUtil: Generating ECC key pair");
        KeyPairGenerator keygen = token.getKeyPairGenerator(KeyPairAlgorithm.EC);
        logger.debug("CryptoUtil: - curve: " + curveName);
        int curveCode = keygen.getCurveCodeByName(curveName);
        logger.debug("CryptoUtil: - temporary: " + temporary);
        if (temporary != null) {
            keygen.temporaryPairs(temporary.booleanValue());
        }
        logger.debug("CryptoUtil: - sensitive: " + sensitive);
        if (sensitive != null) {
            keygen.sensitivePairs(sensitive.booleanValue());
        }
        logger.debug("CryptoUtil: - extractable: " + extractable);
        if (extractable != null) {
            keygen.extractablePairs(extractable.booleanValue());
        }
        keygen.setKeyPairUsages(usages, usagesMask);
        keygen.initialize(curveCode);
        KeyPair pair = keygen.genKeyPair();
        org.mozilla.jss.crypto.PrivateKey privateKey = (org.mozilla.jss.crypto.PrivateKey)pair.getPrivate();
        String hexKeyID = "0x" + Utils.HexEncode((byte[])privateKey.getUniqueID());
        logger.debug("CryptoUtil: - key ID: " + hexKeyID);
        return pair;
    }

    public static void setClientCiphers(String list) throws SocketException {
        CryptoUtil.setClientCiphers(null, list);
    }

    public static void setClientCiphers(SSLSocket soc, String list) throws SocketException {
        String method = "CryptoUtil.setClientCiphers:";
        if (soc == null) {
            logger.debug(method + "begins");
        } else {
            logger.debug(method + "on soc begins");
        }
        if (list == null) {
            logger.debug(method + "no cipher list in call; using default");
            if (soc == null) {
                CryptoUtil.setDefaultSSLCiphers();
            }
            return;
        }
        logger.debug(method + "cipher list in call; processing...");
        String[] ciphers = list.split(",");
        if (ciphers.length == 0) {
            return;
        }
        if (soc == null) {
            CryptoUtil.unsetSSLCiphers();
        } else {
            CryptoUtil.unsetSSLCiphers(soc);
        }
        for (String cipher : ciphers) {
            try {
                if (soc == null) {
                    CryptoUtil.setSSLCipher(cipher, true);
                    continue;
                }
                CryptoUtil.setSSLCipher(soc, cipher, true);
            }
            catch (Exception e) {
                logger.debug(method + cipher + " failed to be set: " + e.toString());
            }
        }
        logger.debug(method + "ends");
    }

    public static void setSSLCiphers(String ciphers) throws SocketException {
        String method = "CryptoUtil.setSSLCiphers:";
        logger.debug(method + "begins");
        if (ciphers == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(ciphers);
        while (st.hasMoreTokens()) {
            String cipher = st.nextToken();
            boolean enabled = true;
            if (cipher.startsWith("-")) {
                enabled = false;
                cipher = cipher.substring(1);
            }
            CryptoUtil.setSSLCipher(cipher, enabled);
        }
        logger.debug(method + "ends");
    }

    public static void setSSLCipher(SSLSocket soc, String name, boolean enabled) throws SocketException {
        int cipherID;
        logger.debug("CryptoUtil.setSSLCipher on soc: setting cipher:" + name);
        if (name.toLowerCase().startsWith("0x")) {
            cipherID = Integer.parseInt(name.substring(2), 16);
        } else {
            SSLCipher cipher = SSLCipher.valueOf((String)name);
            cipherID = cipher.getID();
        }
        soc.setCipherPreference(cipherID, enabled);
    }

    public static void setSSLCipher(String name, boolean enabled) throws SocketException {
        int cipherID;
        logger.debug("CryptoUtil.setSSLCipher: setting cipher:" + name);
        if (name.toLowerCase().startsWith("0x")) {
            cipherID = Integer.parseInt(name.substring(2), 16);
        } else {
            SSLCipher cipher = SSLCipher.valueOf((String)name);
            cipherID = cipher.getID();
        }
        SSLSocket.setCipherPreferenceDefault((int)cipherID, (boolean)enabled);
    }

    public static void setDefaultSSLCiphers() throws SocketException {
        logger.debug("CryptoUtil.setDefaultSSLCiphers");
        int[] ciphers = SSLSocket.getImplementedCipherSuites();
        if (ciphers == null) {
            return;
        }
        for (int cipher : ciphers) {
            boolean enabled = SSLSocket.getCipherPreferenceDefault((int)cipher);
            if ((cipher & 0xFFF0) == 65280) {
                if (!enabled) continue;
                SSLSocket.setCipherPreferenceDefault((int)cipher, (boolean)false);
                continue;
            }
            if (enabled || !clientECCipherList.contains(cipher)) continue;
            SSLSocket.setCipherPreferenceDefault((int)cipher, (boolean)true);
        }
    }

    public static void unsetSSLCiphers() throws SocketException {
        logger.debug("CryptoUtil.unsetSSLCiphers");
        int[] cipherIDs = SSLSocket.getImplementedCipherSuites();
        if (cipherIDs == null) {
            return;
        }
        for (int cipherID : cipherIDs) {
            SSLSocket.setCipherPreferenceDefault((int)cipherID, (boolean)false);
        }
    }

    public static void unsetSSLCiphers(SSLSocket soc) throws SocketException {
        logger.debug("CryptoUtil.unsetSSLCiphers on soc");
        int[] cipherIDs = SSLSocket.getImplementedCipherSuites();
        if (cipherIDs == null) {
            return;
        }
        for (int cipherID : cipherIDs) {
            soc.setCipherPreference(cipherID, false);
        }
    }

    public static byte[] getModulus(PublicKey pubk) {
        java.security.interfaces.RSAPublicKey rsaKey = (java.security.interfaces.RSAPublicKey)pubk;
        return rsaKey.getModulus().toByteArray();
    }

    public static byte[] getPublicExponent(PublicKey pubk) {
        java.security.interfaces.RSAPublicKey rsaKey = (java.security.interfaces.RSAPublicKey)pubk;
        return rsaKey.getPublicExponent().toByteArray();
    }

    public static String base64Encode(byte[] bytes) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(bytes);
            b64.flush();
            String string = output.toString("8859_1");
            return string;
        }
    }

    public static byte[] base64Decode(String s) {
        return Utils.base64decode((String)s);
    }

    public static String reqFormat(String content) {
        StringBuffer result = new StringBuffer();
        result.append("-----BEGIN CERTIFICATE REQUEST-----\n");
        while (content.length() >= 76) {
            result.append(content.substring(0, 76) + "\n");
            content = content.substring(76);
        }
        if (content.length() > 0) {
            result.append(content + "\n-----END CERTIFICATE REQUEST-----");
        } else {
            result.append("-----END CERTIFICATE REQUEST-----");
        }
        return result.toString();
    }

    public static String certFormat(String content) {
        if (content == null || content.length() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append("-----BEGIN CERTIFICATE-----\n");
        while (content.length() >= 76) {
            result.append(content.substring(0, 76) + "\n");
            content = content.substring(76);
        }
        if (content.length() > 0) {
            result.append(content + "\n-----END CERTIFICATE-----");
        } else {
            result.append("-----END CERTIFICATE-----");
        }
        return result.toString();
    }

    public static String stripCertBrackets(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("-----BEGIN CERTIFICATE-----") && s.endsWith("-----END CERTIFICATE-----")) {
            return s.substring(27, s.length() - 25);
        }
        if (s.startsWith("-----BEGIN PKCS #7 SIGNED DATA-----") && s.endsWith("-----END PKCS #7 SIGNED DATA-----")) {
            return s.substring(35, s.length() - 33);
        }
        return s;
    }

    public static String normalizeCertAndReq(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("-----(BEGIN|END) [\\p{Print}&&[^- ]]([- ]?[\\p{Print}&&[^- ]])*-----", "");
        return Utils.normalizeString((String)s);
    }

    public static String normalizeCertStr(String s) {
        StringBuffer val = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r' || s.charAt(i) == '\"' || s.charAt(i) == ' ') continue;
            val.append(s.charAt(i));
        }
        return val.toString();
    }

    public static X509Certificate[] importPKCS7(PKCS7 pkcs7, String nickname, String trustFlags) throws Exception {
        CryptoManager manager = CryptoManager.getInstance();
        java.security.cert.X509Certificate[] pkcs7Certs = pkcs7.getCertificates();
        X509Certificate[] nssCerts = new X509Certificate[pkcs7Certs.length];
        pkcs7Certs = Cert.sortCertificateChain((java.security.cert.X509Certificate[])pkcs7Certs);
        for (int i = 0; i < pkcs7Certs.length; ++i) {
            java.security.cert.X509Certificate pkcs7Cert = pkcs7Certs[i];
            byte[] bytes = pkcs7Cert.getEncoded();
            nssCerts[i] = i == 0 ? manager.importCACertPackage(bytes) : (i < pkcs7Certs.length - 1 || nickname == null ? manager.importCACertPackage(bytes) : manager.importCertPackage(bytes, nickname));
        }
        X509Certificate rootCACert = nssCerts[0];
        CryptoUtil.trustCACert(rootCACert);
        if (trustFlags != null) {
            X509Certificate leafCert = nssCerts[nssCerts.length - 1];
            CryptoUtil.setTrustFlags(leafCert, trustFlags);
        }
        return nssCerts;
    }

    public static X509Certificate[] importPKCS7(PKCS7 pkcs7) throws Exception {
        return CryptoUtil.importPKCS7(pkcs7, null, null);
    }

    public static void importCertificateChain(byte[] bytes) throws Exception {
        try {
            PKCS7 pkcs7 = new PKCS7(bytes);
            CryptoUtil.importPKCS7(pkcs7);
        }
        catch (ParsingException e) {
            CryptoManager manager = CryptoManager.getInstance();
            X509Certificate leafCert = manager.importCACertPackage(bytes);
            X509Certificate[] certs = manager.buildCertificateChain(leafCert);
            X509Certificate rootCert = certs[certs.length - 1];
            CryptoUtil.trustCACert(rootCert);
        }
    }

    public static SEQUENCE parseCRMFMsgs(byte[] cert_request) throws IOException, InvalidBERException {
        if (cert_request == null) {
            throw new IOException("invalid certificate requests: cert_request null");
        }
        ByteArrayInputStream crmfBlobIn = new ByteArrayInputStream(cert_request);
        return (SEQUENCE)new SEQUENCE.OF_Template((ASN1Template)new CertReqMsg.Template()).decode((InputStream)crmfBlobIn);
    }

    public static X509Key getX509KeyFromCRMFMsgs(SEQUENCE crmfMsgs) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeyFormatException {
        if (crmfMsgs == null) {
            throw new IOException("invalid certificate requests: crmfMsgs null");
        }
        int nummsgs = crmfMsgs.size();
        if (nummsgs <= 0) {
            throw new IOException("invalid certificate requests");
        }
        CertReqMsg msg = (CertReqMsg)crmfMsgs.elementAt(0);
        return CryptoUtil.getX509KeyFromCRMFMsg(msg);
    }

    public static X509Key getX509KeyFromCRMFMsg(CertReqMsg crmfMsg) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeyFormatException {
        CertRequest certreq = crmfMsg.getCertReq();
        CertTemplate certTemplate = certreq.getCertTemplate();
        SubjectPublicKeyInfo spkinfo = certTemplate.getPublicKey();
        PublicKey pkey = spkinfo.toPublicKey();
        return CryptoUtil.createX509Key(pkey);
    }

    public static X509Key createX509Key(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rsaPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
            return new RSAPublicKey(new BigInt(rsaPublicKey.getModulus()), new BigInt(rsaPublicKey.getPublicExponent()));
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            try {
                DerValue derValue = new DerValue(ecPublicKey.getEncoded());
                return X509Key.parse((DerValue)derValue);
            }
            catch (IOException e) {
                throw new InvalidKeyException(e);
            }
        }
        if (publicKey instanceof java.security.interfaces.DSAPublicKey) {
            java.security.interfaces.DSAPublicKey dsaPublicKey = (java.security.interfaces.DSAPublicKey)publicKey;
            DSAParams params = dsaPublicKey.getParams();
            return new DSAPublicKey(dsaPublicKey.getY(), params.getP(), params.getQ(), params.getG());
        }
        String message = "Unsupported public key: " + publicKey.getClass().getName();
        logger.error(message);
        throw new InvalidKeyException(message);
    }

    public static X500Name getSubjectName(SEQUENCE crmfMsgs) throws IOException {
        int nummsgs = crmfMsgs.size();
        if (nummsgs <= 0) {
            throw new IOException("invalid certificate requests");
        }
        CertReqMsg msg = (CertReqMsg)crmfMsgs.elementAt(0);
        CertRequest certreq = msg.getCertReq();
        CertTemplate certTemplate = certreq.getCertTemplate();
        Name n = certTemplate.getSubject();
        ByteArrayOutputStream subjectEncStream = new ByteArrayOutputStream();
        n.encode((OutputStream)subjectEncStream);
        byte[] b = subjectEncStream.toByteArray();
        return new X500Name(b);
    }

    public static X509CertInfo createX509CertInfo(X509Key x509key, BigInteger serialno, CertificateIssuerName issuerName, X500Name subjectName, Date notBefore, Date notAfter, String alg, CertificateExtensions extensions) throws IOException, CertificateException, NoSuchAlgorithmException {
        X509CertInfo info = new X509CertInfo();
        info.set("version", (Object)new CertificateVersion(2));
        info.set("serialNumber", (Object)new CertificateSerialNumber(serialno));
        if (issuerName != null) {
            info.set("issuer", (Object)issuerName);
        }
        info.set("subject", (Object)new CertificateSubjectName(subjectName));
        info.set("validity", (Object)new CertificateValidity(notBefore, notAfter));
        info.set("algorithmID", (Object)new CertificateAlgorithmId(AlgorithmId.get((String)alg)));
        info.set("key", (Object)new CertificateX509Key(x509key));
        info.set("extensions", (Object)extensions);
        return info;
    }

    public static X509CertImpl signECCCert(PrivateKey privateKey, X509CertInfo certInfo) throws Exception {
        String alg = "SHA256withEC";
        return CryptoUtil.signCert(privateKey, certInfo, alg);
    }

    public static X509CertImpl signCert(PrivateKey privateKey, X509CertInfo certInfo, String alg) throws Exception {
        SignatureAlgorithm signingAlgorithm = Cert.mapAlgorithmToJss((String)alg);
        return CryptoUtil.signCert(privateKey, certInfo, signingAlgorithm);
    }

    public static X509CertImpl signCert(PrivateKey privateKey, X509CertInfo certInfo, SignatureAlgorithm signingAlgorithm) throws Exception {
        logger.debug("CryptoUtil: Signing certificate");
        logger.debug("CryptoUtil: - signing algorithm: " + signingAlgorithm);
        String algName = CryptoUtil.mapSignatureAlgorithmToInternalName(signingAlgorithm);
        logger.debug("CryptoUtil: - algorithm name: " + algName);
        AlgorithmId aid = AlgorithmId.get((String)algName);
        logger.debug("CryptoUtil: - algorithm ID: " + aid);
        certInfo.set("algorithmID", (Object)new CertificateAlgorithmId(aid));
        org.mozilla.jss.crypto.PrivateKey priKey = (org.mozilla.jss.crypto.PrivateKey)privateKey;
        CryptoToken token = priKey.getOwningToken();
        Signature signer = token.getSignatureContext(signingAlgorithm);
        signer.initSign(priKey);
        try (DerOutputStream tmp = new DerOutputStream();){
            X509CertImpl x509CertImpl;
            try (DerOutputStream out = new DerOutputStream();){
                certInfo.encode((OutputStream)tmp);
                signer.update(tmp.toByteArray());
                byte[] signed = signer.sign();
                aid.encode(tmp);
                tmp.putBitString(signed);
                out.write((byte)48, tmp);
                x509CertImpl = new X509CertImpl(out.toByteArray());
            }
            return x509CertImpl;
        }
    }

    public static PKCS10 createCertificationRequest(String subjectName, KeyPair keyPair, Extensions exts) throws Exception {
        return CryptoUtil.createCertificationRequest(subjectName, false, keyPair, exts);
    }

    public static PKCS10 createCertificationRequest(String subjectName, boolean encodeSubj, KeyPair keyPair, Extensions exts) throws Exception {
        String alg;
        PublicKey publicKey = keyPair.getPublic();
        X509Key key = CryptoUtil.createX509Key(publicKey);
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            alg = "SHA256withRSA";
        } else if (CryptoUtil.isECCKey(key)) {
            alg = "SHA256withEC";
        } else if (publicKey instanceof java.security.interfaces.DSAPublicKey) {
            alg = "DSA";
        } else {
            throw new NoSuchAlgorithmException("Unsupported algorithm: " + publicKey.getAlgorithm());
        }
        return CryptoUtil.createCertificationRequest(subjectName, encodeSubj, keyPair, alg, exts);
    }

    public static PKCS10 createCertificationRequest(String subjectName, KeyPair keyPair, String alg, Extensions exts) throws Exception {
        return CryptoUtil.createCertificationRequest(subjectName, false, keyPair, alg, exts);
    }

    public static PKCS10 createCertificationRequest(String subjectName, boolean encodeSubj, KeyPair keyPair, String alg, Extensions exts) throws Exception {
        logger.debug("CryptoUtil: Creating PKCS #10 request");
        X509Key key = CryptoUtil.createX509Key(keyPair.getPublic());
        logger.debug("CryptoUtil: - algorithm: " + alg);
        java.security.Signature sig = java.security.Signature.getInstance(alg, "Mozilla-JSS");
        sig.initSign(keyPair.getPrivate());
        logger.debug("CryptoUtil: - subject: " + subjectName);
        X500Name name = null;
        if (!encodeSubj) {
            name = new X500Name(subjectName);
        } else {
            Name n = CryptoUtil.getJssName(encodeSubj, subjectName);
            ByteArrayOutputStream subjectEncStream = new ByteArrayOutputStream();
            n.encode((OutputStream)subjectEncStream);
            byte[] b = subjectEncStream.toByteArray();
            name = new X500Name(b);
        }
        X500Signer signer = new X500Signer(sig, name);
        logger.debug("CryptoUtil: - attributes:");
        PKCS10Attributes attrs = new PKCS10Attributes();
        if (exts != null && !exts.isEmpty()) {
            PKCS10Attribute attr = new PKCS10Attribute(PKCS9Attribute.EXTENSION_REQUEST_OID, (CertAttrSet)exts);
            String attrName = attr.getAttributeValue().getName();
            logger.debug("CryptoUtil:   - " + attrName);
            attrs.setAttribute(attrName, attr);
        }
        PKCS10 pkcs10 = new PKCS10(key, attrs);
        pkcs10.encodeAndSign(signer);
        return pkcs10;
    }

    static boolean isEncoded(String elementValue) {
        boolean encoded = false;
        if (elementValue != null && (elementValue.startsWith("UTF8String:") || elementValue.startsWith("PrintableString:") || elementValue.startsWith("BMPString:") || elementValue.startsWith("TeletexString:") || elementValue.startsWith("UniversalString:"))) {
            encoded = true;
        }
        return encoded;
    }

    static Name addNameElement(Name name, OBJECT_IDENTIFIER oid, int n, String elementValue) {
        try {
            String nameValue;
            String encodingType = n > 0 ? elementValue.substring(0, n) : null;
            String string = nameValue = n > 0 ? elementValue.substring(n + 1) : null;
            if (encodingType != null && encodingType.length() > 0 && nameValue != null && nameValue.length() > 0) {
                if (encodingType.equals("UTF8String")) {
                    name.addElement(new AVA(oid, (ASN1Value)new UTF8String(nameValue)));
                } else if (encodingType.equals("PrintableString")) {
                    name.addElement(new AVA(oid, (ASN1Value)new PrintableString(nameValue)));
                } else if (encodingType.equals("BMPString")) {
                    name.addElement(new AVA(oid, (ASN1Value)new BMPString(nameValue)));
                } else if (encodingType.equals("TeletexString")) {
                    name.addElement(new AVA(oid, (ASN1Value)new TeletexString(nameValue)));
                } else if (encodingType.equals("UniversalString")) {
                    name.addElement(new AVA(oid, (ASN1Value)new UniversalString(nameValue)));
                }
            }
        }
        catch (Exception e) {
            System.out.println("CryptoUtil: Error adding name element: " + elementValue + " Error: " + e.toString());
        }
        return name;
    }

    static Name getJssName(boolean enable_encoding, String dn) {
        X500Name x5Name = null;
        try {
            x5Name = new X500Name(dn);
        }
        catch (IOException e) {
            System.out.println("CryptoUtil: Illegal Subject Name:  " + dn + " Error: " + e.toString());
            System.out.println("CryptoUtil: Filling in default Subject Name......");
            return null;
        }
        Name ret = new Name();
        RDN[] names = null;
        names = x5Name.getNames();
        int nameLen = x5Name.getNamesLength();
        RDN cur = null;
        for (int i = 0; i < nameLen; ++i) {
            cur = names[i];
            String rdnStr = cur.toString();
            String[] split = rdnStr.split("=");
            if (split.length != 2) continue;
            int n = split[1].indexOf(58);
            try {
                if (split[0].equals("UID")) {
                    if (enable_encoding && CryptoUtil.isEncoded(split[1])) {
                        ret = CryptoUtil.addNameElement(ret, new OBJECT_IDENTIFIER("0.9.2342.19200300.100.1.1"), n, split[1]);
                    } else {
                        ret.addElement(new AVA(new OBJECT_IDENTIFIER("0.9.2342.19200300.100.1.1"), (ASN1Value)new PrintableString(split[1])));
                    }
                }
                if (split[0].equals("C")) {
                    ret.addCountryName(split[1]);
                    continue;
                }
                if (split[0].equals("CN")) {
                    if (enable_encoding && CryptoUtil.isEncoded(split[1])) {
                        ret = CryptoUtil.addNameElement(ret, Name.commonName, n, split[1]);
                        continue;
                    }
                    ret.addCommonName(split[1]);
                    continue;
                }
                if (split[0].equals("L")) {
                    if (enable_encoding && CryptoUtil.isEncoded(split[1])) {
                        ret = CryptoUtil.addNameElement(ret, Name.localityName, n, split[1]);
                        continue;
                    }
                    ret.addLocalityName(split[1]);
                    continue;
                }
                if (split[0].equals("O")) {
                    if (enable_encoding && CryptoUtil.isEncoded(split[1])) {
                        ret = CryptoUtil.addNameElement(ret, Name.organizationName, n, split[1]);
                        continue;
                    }
                    ret.addOrganizationName(split[1]);
                    continue;
                }
                if (split[0].equals("ST")) {
                    if (enable_encoding && CryptoUtil.isEncoded(split[1])) {
                        ret = CryptoUtil.addNameElement(ret, Name.stateOrProvinceName, n, split[1]);
                        continue;
                    }
                    ret.addStateOrProvinceName(split[1]);
                    continue;
                }
                if (!split[0].equals("OU")) continue;
                if (enable_encoding && CryptoUtil.isEncoded(split[1])) {
                    ret = CryptoUtil.addNameElement(ret, Name.organizationalUnitName, n, split[1]);
                    continue;
                }
                ret.addOrganizationalUnitName(split[1]);
                continue;
            }
            catch (Exception e) {
                System.out.println("CryptoUtil: Error constructing RDN: " + rdnStr + " Error: " + e.toString());
            }
        }
        return ret;
    }

    public static KeyIdentifier createKeyIdentifier(KeyPair keypair) throws InvalidKeyException {
        String method = "CryptoUtil: createKeyIdentifier: ";
        logger.debug(method + "begins");
        X509Key subjectKeyInfo = CryptoUtil.createX509Key(keypair.getPublic());
        byte[] hash = CryptoUtil.generateKeyIdentifier(subjectKeyInfo.getKey());
        if (hash == null) {
            logger.debug(method + "generateKeyIdentifier returns null");
            return null;
        }
        return new KeyIdentifier(hash);
    }

    public static byte[] generateKeyIdentifier(byte[] rawKey) {
        return CryptoUtil.generateKeyIdentifier(rawKey, null);
    }

    public static byte[] generateKeyIdentifier(byte[] rawKey, String alg) {
        String method = "CryptoUtil: generateKeyIdentifier: ";
        Object msg = "";
        if (alg == null) {
            alg = "SHA-1";
        }
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            md.update(rawKey);
            return md.digest();
        }
        catch (Exception e) {
            msg = method + e;
            logger.warn((String)msg, (Throwable)e);
            return null;
        }
    }

    public static String getSKIString(X509CertImpl cert) throws IOException {
        byte[] ski;
        SubjectKeyIdentifierExtension ext = (SubjectKeyIdentifierExtension)cert.getExtension(PKIXExtensions.SubjectKey_Id.toString());
        if (ext == null) {
            ski = CryptoUtil.generateKeyIdentifier(cert.getPublicKey().getEncoded());
        } else {
            KeyIdentifier keyId = (KeyIdentifier)ext.get("key_id");
            ski = keyId.getIdentifier();
        }
        PrettyPrintFormat pp = new PrettyPrintFormat(":", 20);
        return pp.toHexString(ski).trim();
    }

    public static Extension getExtensionFromPKCS10(PKCS10 pkcs10, String extnName) throws IOException, CertificateException {
        Extension extn = null;
        String method = "CryptoUtiil: getExtensionFromPKCS10: ";
        logger.debug(method + "begins");
        PKCS10Attributes attributeSet = pkcs10.getAttributes();
        if (attributeSet == null) {
            logger.debug(method + "attributeSet not found");
            return null;
        }
        PKCS10Attribute attr = attributeSet.getAttribute("extensions");
        if (attr == null) {
            logger.debug(method + "extensions attribute not found");
            return null;
        }
        logger.debug(method + attr);
        CertAttrSet cas = attr.getAttributeValue();
        if (cas == null) {
            logger.debug(method + "CertAttrSet not found in PKCS10Attribute");
            return null;
        }
        Enumeration en = cas.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            logger.debug(method + " checking extension in request:" + name);
            if (!name.equals(extnName)) continue;
            logger.debug(method + "extension matches");
            extn = (Extension)cas.get(name);
        }
        logger.debug(method + "ends");
        return extn;
    }

    public static Extension getExtensionFromCertTemplate(CertTemplate certTemplate, ObjectIdentifier csOID) {
        OBJECT_IDENTIFIER jssOID = new OBJECT_IDENTIFIER(csOID.toString());
        String method = "CryptoUtil: getSKIExtensionFromCertTemplate: ";
        SubjectKeyIdentifierExtension extn = null;
        OBJECT_IDENTIFIER SKIoid = new OBJECT_IDENTIFIER(PKIXExtensions.SubjectKey_Id.toString());
        if (certTemplate.hasExtensions()) {
            int numexts = certTemplate.numExtensions();
            for (int j = 0; j < numexts; ++j) {
                org.mozilla.jss.pkix.cert.Extension jssext = certTemplate.extensionAt(j);
                OBJECT_IDENTIFIER extnoid = jssext.getExtnId();
                logger.debug(method + "checking extension in request:" + extnoid);
                if (!extnoid.equals((Object)jssOID)) continue;
                logger.debug(method + "extension found");
                try {
                    if (jssOID.equals((Object)SKIoid)) {
                        System.out.println(method + "SKIoid == jssOID");
                        extn = new SubjectKeyIdentifierExtension(false, jssext.getExtnValue().toByteArray());
                        continue;
                    }
                    System.out.println(method + "SKIoid != jssOID");
                    extn = new Extension(csOID, false, jssext.getExtnValue().toByteArray());
                    continue;
                }
                catch (IOException e) {
                    logger.warn(method + e, (Throwable)e);
                }
            }
        } else {
            logger.debug(method + "no extension found");
        }
        return extn;
    }

    public static void unTrustCert(InternalCertificate cert) {
        int flag = cert.getSSLTrust();
        cert.setSSLTrust(flag ^= 8);
    }

    public static void trustCertByNickname(String nickname) throws NotInitializedException, TokenException {
        CryptoManager cm = CryptoManager.getInstance();
        X509Certificate[] certs = cm.findCertsByNickname(nickname);
        if (certs == null) {
            return;
        }
        for (int i = 0; i < certs.length; ++i) {
            CryptoUtil.trustCert((InternalCertificate)certs[i]);
        }
    }

    public static void trustCert(InternalCertificate cert) {
        int flag = 216;
        cert.setSSLTrust(flag);
        cert.setObjectSigningTrust(flag);
        cert.setEmailTrust(flag);
    }

    public static void setTrustFlags(X509Certificate cert, String trustFlags) throws Exception {
        String[] flags = trustFlags.split(",", -1);
        if (flags.length < 3) {
            throw new Exception("Invalid trust flags: " + trustFlags);
        }
        InternalCertificate internalCert = (InternalCertificate)cert;
        internalCert.setSSLTrust(PK11Cert.decodeTrustFlags((String)flags[0]));
        internalCert.setEmailTrust(PK11Cert.decodeTrustFlags((String)flags[1]));
        internalCert.setObjectSigningTrust(PK11Cert.decodeTrustFlags((String)flags[2]));
    }

    public static void trustCACert(X509Certificate cert) {
        InternalCertificate ic = (InternalCertificate)cert;
        ic.setSSLTrust(152);
        ic.setEmailTrust(24);
        ic.setObjectSigningTrust(24);
    }

    public static void trustAuditSigningCert(X509Certificate cert) {
        InternalCertificate ic = (InternalCertificate)cert;
        ic.setSSLTrust(64);
        ic.setEmailTrust(64);
        ic.setObjectSigningTrust(67);
    }

    public static boolean isCertTrusted(InternalCertificate cert) {
        return CryptoUtil.isTrust(cert.getSSLTrust()) && CryptoUtil.isTrust(cert.getObjectSigningTrust()) && CryptoUtil.isTrust(cert.getEmailTrust());
    }

    public static boolean isTrust(int flag) {
        return (flag & 8) > 0 && (flag & 0x10) > 0 && (flag & 0x40) > 0 && (flag & 0x80) > 0;
    }

    public static SymmetricKey generateKey(CryptoToken token, KeyGenAlgorithm alg, int keySize, SymmetricKey.Usage[] usages, boolean temporary) throws Exception {
        KeyGenerator kg = token.getKeyGenerator(alg);
        if (usages != null) {
            kg.setKeyUsages(usages);
        }
        kg.temporaryKeys(temporary);
        if (alg == KeyGenAlgorithm.AES || alg == KeyGenAlgorithm.RC4 || alg == KeyGenAlgorithm.RC2) {
            kg.initialize(keySize);
        }
        return kg.generate();
    }

    public static SymmetricKey generateKey(CryptoToken token, KeyGenAlgorithm alg, int keySize, SymmetricKey.Usage[] usages, boolean temporary, boolean sensitive) throws Exception {
        KeyGenerator kg = token.getKeyGenerator(alg);
        if (usages != null) {
            kg.setKeyUsages(usages);
        }
        kg.sensitiveKeys(sensitive);
        kg.temporaryKeys(temporary);
        if (alg == KeyGenAlgorithm.AES || alg == KeyGenAlgorithm.RC4 || alg == KeyGenAlgorithm.RC2) {
            kg.initialize(keySize);
        }
        return kg.generate();
    }

    public static boolean compare(byte[] src, byte[] dest) {
        if (src != null && dest != null && src.length == dest.length) {
            boolean matched = true;
            for (int i = 0; i < src.length; ++i) {
                if (src[i] == dest[i]) continue;
                matched = false;
            }
            if (matched) {
                return true;
            }
        }
        return false;
    }

    public static String byte2string(byte[] id) {
        return new BigInteger(id).toString(16);
    }

    public static byte[] string2byte(String id) {
        return new BigInteger(id, 16).toByteArray();
    }

    public static String encodeKeyID(byte[] keyID) {
        if (keyID.length != 20) {
            String hexKeyID = "0x" + Utils.HexEncode((byte[])keyID);
            throw new IllegalArgumentException("Unable to encode Key ID: " + hexKeyID);
        }
        return new BigInteger(keyID).toString(16);
    }

    public static byte[] decodeKeyID(String id) throws DecoderException {
        if (((String)id).startsWith("0x")) {
            if (((String)(id = ((String)id).substring(2))).length() % 2 == 1) {
                id = "0" + (String)id;
            }
            return Hex.decodeHex((String)id);
        }
        BigInteger value = new BigInteger((String)id, 16);
        byte[] array = value.toByteArray();
        if (array.length > 20) {
            throw new IllegalArgumentException("Unable to decode Key ID: " + (String)id);
        }
        if (array.length < 20) {
            byte[] tmp = array;
            array = new byte[20];
            int p = 20 - tmp.length;
            byte b = (byte)(value.signum() >= 0 ? 0 : 255);
            Arrays.fill(array, 0, p, b);
            System.arraycopy(tmp, 0, array, p, tmp.length);
        }
        return array;
    }

    public static byte[] hexString2Bytes(String string) {
        if (string == null) {
            return null;
        }
        int stringLength = string.length();
        if (stringLength == 0 || stringLength % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[stringLength / 2];
        int i = 0;
        int b = 0;
        while (i < stringLength) {
            String nextByte = string.substring(i, i + 2);
            bytes[b] = (byte)Integer.parseInt(nextByte, 16);
            i += 2;
            ++b;
        }
        return bytes;
    }

    public static char[] bytesToChars(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Charset charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes));
        char[] result = Arrays.copyOf(charBuffer.array(), charBuffer.limit());
        if (charBuffer.hasArray()) {
            char[] contentsToBeErased = charBuffer.array();
            CryptoUtil.obscureChars(contentsToBeErased);
        }
        return result;
    }

    public static byte[] charsToBytes(char[] chars) {
        if (chars == null) {
            return null;
        }
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(chars));
        byte[] result = Arrays.copyOf(byteBuffer.array(), byteBuffer.limit());
        if (byteBuffer.hasArray()) {
            byte[] contentsToBeErased = byteBuffer.array();
            CryptoUtil.obscureBytes(contentsToBeErased, "random");
        }
        return result;
    }

    public static Password createPasswordFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] pwdChars = CryptoUtil.bytesToChars(bytes);
        Password password = new Password(pwdChars);
        CryptoUtil.obscureChars(pwdChars);
        return password;
    }

    public static org.mozilla.jss.crypto.PrivateKey findPrivateKey(byte[] id) throws Exception {
        CryptoManager cm = CryptoManager.getInstance();
        Enumeration enums = cm.getAllTokens();
        while (enums.hasMoreElements()) {
            CryptoToken token = (CryptoToken)enums.nextElement();
            org.mozilla.jss.crypto.PrivateKey privateKey = CryptoUtil.findPrivateKey(token, id);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    public static org.mozilla.jss.crypto.PrivateKey findPrivateKey(CryptoToken token, byte[] id) throws Exception {
        CryptoStore store = token.getCryptoStore();
        org.mozilla.jss.crypto.PrivateKey[] privateKeys = store.getPrivateKeys();
        if (privateKeys == null) {
            return null;
        }
        for (org.mozilla.jss.crypto.PrivateKey privateKey : privateKeys) {
            if (!CryptoUtil.compare(privateKey.getUniqueID(), id)) continue;
            return privateKey;
        }
        return null;
    }

    public static org.mozilla.jss.crypto.PrivateKey findPrivateKey(String nickname) throws Exception {
        try {
            CryptoManager cm = CryptoManager.getInstance();
            X509Certificate cert = cm.findCertByNickname(nickname);
            return cm.findPrivKeyByCert(cert);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    public static X509CertImpl[] getAllUserCerts() throws NotInitializedException, TokenException {
        Vector<X509CertImpl> certs = new Vector<X509CertImpl>();
        CryptoManager cm = CryptoManager.getInstance();
        Enumeration enums = cm.getAllTokens();
        while (enums.hasMoreElements()) {
            CryptoToken token = (CryptoToken)enums.nextElement();
            CryptoStore store = token.getCryptoStore();
            X509Certificate[] list = store.getCertificates();
            for (int i = 0; i < list.length; ++i) {
                try {
                    org.mozilla.jss.crypto.PrivateKey key = cm.findPrivKeyByCert(list[i]);
                    X509CertImpl impl = null;
                    try {
                        impl = new X509CertImpl(list[i].getEncoded());
                    }
                    catch (CertificateException e) {
                        continue;
                    }
                    certs.addElement(impl);
                    continue;
                }
                catch (ObjectNotFoundException | TokenException throwable) {
                    // empty catch block
                }
            }
        }
        if (certs.isEmpty()) {
            return null;
        }
        Object[] c = new X509CertImpl[certs.size()];
        certs.copyInto(c);
        return c;
    }

    public static void deletePrivateKey(org.mozilla.jss.crypto.PrivateKey prikey) throws TokenException {
        try {
            CryptoToken token = prikey.getOwningToken();
            CryptoStore store = token.getCryptoStore();
            store.deletePrivateKey(prikey);
        }
        catch (NoSuchItemOnTokenException noSuchItemOnTokenException) {
            // empty catch block
        }
    }

    public static void deleteCertificates(String nickname) throws TokenException, ObjectNotFoundException, NoSuchItemOnTokenException, NotInitializedException {
        CryptoManager manager = CryptoManager.getInstance();
        X509Certificate[] certs = manager.findCertsByNickname(nickname);
        if (certs == null || certs.length == 0) {
            throw new ObjectNotFoundException("Certificate not found: " + nickname);
        }
        for (X509Certificate cert : certs) {
            CryptoToken token;
            if (cert instanceof TokenCertificate) {
                TokenCertificate tokenCert = (TokenCertificate)cert;
                token = tokenCert.getOwningToken();
            } else {
                token = manager.getInternalKeyStorageToken();
            }
            CryptoStore store = token.getCryptoStore();
            store.deleteCert(cert);
        }
    }

    public static void deleteUserCertificates(String nickname) throws NotInitializedException, TokenException {
        CryptoManager cm = CryptoManager.getInstance();
        X509Certificate[] certs = cm.findCertsByNickname(nickname);
        if (certs == null) {
            return;
        }
        for (X509Certificate cert : certs) {
            try {
                org.mozilla.jss.crypto.PrivateKey prikey = cm.findPrivKeyByCert(cert);
                CryptoToken token = prikey.getOwningToken();
                CryptoStore store = token.getCryptoStore();
                store.deleteCert(cert);
            }
            catch (NoSuchItemOnTokenException | ObjectNotFoundException throwable) {
                // empty catch block
            }
        }
    }

    public static X509Certificate importUserCertificateChain(String c, String nickname) throws NotInitializedException, NicknameConflictException, UserCertConflictException, NoSuchItemOnTokenException, TokenException, CertificateEncodingException {
        CryptoManager cm = CryptoManager.getInstance();
        X509Certificate cert = cm.importCertPackage(c.getBytes(), nickname);
        CryptoUtil.trustCertByNickname(nickname);
        return cert;
    }

    public static X509Certificate importUserCertificate(byte[] bytes, String nickname) throws NotInitializedException, CertificateEncodingException, NoSuchItemOnTokenException, TokenException, NicknameConflictException, UserCertConflictException {
        CryptoManager cm = CryptoManager.getInstance();
        return cm.importUserCACertPackage(bytes, nickname);
    }

    public static java.security.cert.X509Certificate[] getX509CertificateFromPKCS7(byte[] b) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        CertificateChain certchain = new CertificateChain();
        certchain.decode((InputStream)bis);
        return certchain.getChain();
    }

    public static byte[] getNonceData(int size) throws GeneralSecurityException {
        byte[] iv = new byte[size];
        SecureRandom rnd = CryptoUtil.getRandomNumberGenerator();
        rnd.nextBytes(iv);
        return iv;
    }

    public static SecureRandom getRandomNumberGenerator() throws GeneralSecurityException {
        return SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
    }

    public static void obscureChars(char[] memory) {
        if (memory == null || memory.length == 0) {
            return;
        }
        Arrays.fill(memory, '\u0000');
    }

    public static void obscureBytes(byte[] memory, String method) {
        SecureRandom rnd;
        if (memory == null || memory.length == 0) {
            return;
        }
        try {
            rnd = CryptoUtil.getRandomNumberGenerator();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        if ("zeroes".equals(method)) {
            Arrays.fill(memory, (byte)0);
        } else {
            rnd.nextBytes(memory);
        }
    }

    public static byte[] unwrapUsingPassphrase(byte[] wrappedRecoveredKey, String recoveryPassphrase) throws IOException, InvalidBERException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NotInitializedException, TokenException, IllegalBlockSizeException, BadPaddingException {
        EncryptedContentInfo cInfo = null;
        PBEAlgorithm pbeAlg = PBEAlgorithm.PBE_SHA1_DES3_CBC;
        Password pass = new Password(recoveryPassphrase.toCharArray());
        try {
            byte[] byArray;
            try (ByteArrayInputStream inStream = new ByteArrayInputStream(wrappedRecoveredKey);){
                PasswordConverter passConverter = new PasswordConverter();
                cInfo = (EncryptedContentInfo)new EncryptedContentInfo.Template().decode((InputStream)inStream);
                byArray = cInfo.decrypt(pass, (KeyGenerator.CharToByteConverter)passConverter);
            }
            return byArray;
        }
        finally {
            pass.clear();
        }
    }

    public static byte[] encryptSecret(CryptoToken token, byte[] secret, IVParameterSpec iv, SymmetricKey key, EncryptionAlgorithm algorithm) throws NoSuchAlgorithmException, TokenException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = token.getCipherContext(algorithm);
        cipher.initEncrypt(key, (AlgorithmParameterSpec)iv);
        return cipher.doFinal(secret);
    }

    public static byte[] wrapSymmetricKey(CryptoToken token, PublicKey wrappingKey, SymmetricKey sk) throws Exception {
        return CryptoUtil.wrapUsingPublicKey(token, wrappingKey, sk, KeyWrapAlgorithm.RSA);
    }

    public static PKIArchiveOptions createPKIArchiveOptions(CryptoToken token, PublicKey wrappingKey, org.mozilla.jss.crypto.PrivateKey data, WrappingParams params, AlgorithmIdentifier aid) throws Exception {
        return CryptoUtil.createPKIArchiveOptionsInternal(token, wrappingKey, null, data, null, params, aid);
    }

    public static byte[] createEncodedPKIArchiveOptions(CryptoToken token, PublicKey wrappingKey, org.mozilla.jss.crypto.PrivateKey data, WrappingParams params, AlgorithmIdentifier aid) throws Exception {
        PKIArchiveOptions opts = CryptoUtil.createPKIArchiveOptionsInternal(token, wrappingKey, null, data, null, params, aid);
        return CryptoUtil.encodePKIArchiveOptions(opts);
    }

    public static byte[] createEncodedPKIArchiveOptions(CryptoToken token, PublicKey wrappingKey, SymmetricKey data, WrappingParams params, AlgorithmIdentifier aid) throws Exception {
        PKIArchiveOptions opts = CryptoUtil.createPKIArchiveOptionsInternal(token, wrappingKey, null, null, data, params, aid);
        return CryptoUtil.encodePKIArchiveOptions(opts);
    }

    public static PKIArchiveOptions createPKIArchiveOptions(CryptoToken token, PublicKey wrappingKey, char[] data, WrappingParams params, AlgorithmIdentifier aid) throws Exception {
        return CryptoUtil.createPKIArchiveOptionsInternal(token, wrappingKey, data, null, null, params, aid);
    }

    public static byte[] createEncodedPKIArchiveOptions(CryptoToken token, PublicKey wrappingKey, char[] data, WrappingParams params, AlgorithmIdentifier aid) throws Exception {
        PKIArchiveOptions opts = CryptoUtil.createPKIArchiveOptionsInternal(token, wrappingKey, data, null, null, params, aid);
        return CryptoUtil.encodePKIArchiveOptions(opts);
    }

    private static PKIArchiveOptions createPKIArchiveOptionsInternal(CryptoToken token, PublicKey wrappingKey, char[] passphraseData, org.mozilla.jss.crypto.PrivateKey privKeyData, SymmetricKey symKeyData, WrappingParams params, AlgorithmIdentifier aid) throws Exception {
        byte[] key_data;
        CryptoManager cm = CryptoManager.getInstance();
        SymmetricKey sessionKey = CryptoUtil.generateKey(token, params.getSkKeyGenAlgorithm(), params.getSkLength(), sess_key_usages, false, cm.FIPSEnabled());
        if (passphraseData != null) {
            byte[] secret = CryptoUtil.charsToBytes(passphraseData);
            key_data = CryptoUtil.encryptSecret(token, secret, params.getPayloadEncryptionIV(), sessionKey, params.getPayloadEncryptionAlgorithm());
        } else if (privKeyData != null) {
            key_data = CryptoUtil.wrapUsingSymmetricKey(token, sessionKey, privKeyData, params.getPayloadWrappingIV(), params.getPayloadWrapAlgorithm());
        } else if (symKeyData != null) {
            key_data = CryptoUtil.wrapUsingSymmetricKey(token, sessionKey, symKeyData, params.getPayloadWrappingIV(), params.getPayloadWrapAlgorithm());
        } else {
            throw new IOException("No data to package in PKIArchiveOptions!");
        }
        byte[] session_data = CryptoUtil.wrapUsingPublicKey(token, wrappingKey, sessionKey, params.getSkWrapAlgorithm());
        return CryptoUtil.createPKIArchiveOptions(session_data, key_data, aid);
    }

    public static PKIArchiveOptions createPKIArchiveOptions(byte[] session_data, byte[] key_data, AlgorithmIdentifier aid) {
        EncryptedValue encValue = new EncryptedValue(null, aid, new BIT_STRING(session_data, 0), null, null, new BIT_STRING(key_data, 0));
        EncryptedKey key = new EncryptedKey(encValue);
        return new PKIArchiveOptions(key);
    }

    public static byte[] encodePKIArchiveOptions(PKIArchiveOptions opts) throws Exception {
        byte[] encoded = null;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        opts.encode((OutputStream)oStream);
        encoded = oStream.toByteArray();
        ByteArrayInputStream inStream = new ByteArrayInputStream(encoded);
        PKIArchiveOptions options = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)inStream);
        return encoded;
    }

    public static org.mozilla.jss.crypto.PrivateKey importPKIArchiveOptions(CryptoToken token, org.mozilla.jss.crypto.PrivateKey unwrappingKey, PublicKey pubkey, byte[] data, boolean useOAEPKeyWrap) throws InvalidBERException, Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        PKIArchiveOptions options = (PKIArchiveOptions)new PKIArchiveOptions.Template().decode((InputStream)in);
        EncryptedKey encKey = options.getEncryptedKey();
        EncryptedValue encVal = encKey.getEncryptedValue();
        AlgorithmIdentifier algId = encVal.getSymmAlg();
        BIT_STRING encSymKey = encVal.getEncSymmKey();
        BIT_STRING encPrivKey = encVal.getEncValue();
        OBJECT_IDENTIFIER oid = algId.getOID();
        ASN1Value v = algId.getParameters();
        v = ((ANY)v).decodeWith((ASN1Template)new OCTET_STRING.Template());
        byte[] iv = ((OCTET_STRING)v).toByteArray();
        IVParameterSpec ivps = new IVParameterSpec(iv);
        KeyWrapAlgorithm wrapAlg = KeyWrapAlgorithm.RSA;
        if (useOAEPKeyWrap) {
            wrapAlg = KeyWrapAlgorithm.RSA_OAEP;
        }
        if (oid.equals((Object)new OBJECT_IDENTIFIER("1.2.840.113549.3.7"))) {
            SymmetricKey sk = CryptoUtil.unwrap(token, SymmetricKey.Type.DES3, 0, SymmetricKey.Usage.UNWRAP, unwrappingKey, encSymKey.getBits(), wrapAlg);
            return CryptoUtil.unwrap(token, pubkey, false, sk, encPrivKey.getBits(), KeyWrapAlgorithm.DES3_CBC_PAD, ivps);
        }
        if (oid.equals((Object)new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.1.2"))) {
            SymmetricKey sk = CryptoUtil.unwrap(token, SymmetricKey.Type.AES, 0, SymmetricKey.Usage.UNWRAP, unwrappingKey, encSymKey.getBits(), wrapAlg);
            return CryptoUtil.unwrap(token, pubkey, false, sk, encPrivKey.getBits(), KeyWrapAlgorithm.AES_CBC_PAD, ivps);
        }
        throw new IOException("PKIArchiveOptions symmetric algorithm " + oid.toString() + " not supported");
    }

    public static boolean sharedSecretExists(String nickname) throws NotInitializedException, TokenException {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = cm.getInternalKeyStorageToken();
        KeyManager km = new KeyManager(token);
        return km.uniqueNamedKeyExists(nickname);
    }

    public static void createSharedSecret(String nickname) throws NotInitializedException, TokenException {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = cm.getInternalKeyStorageToken();
        KeyManager km = new KeyManager(token);
        km.generateUniqueNamedKey(nickname);
    }

    public static void deleteSharedSecret(String nickname) throws NotInitializedException, TokenException, InvalidKeyException {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = cm.getInternalKeyStorageToken();
        KeyManager km = new KeyManager(token);
        km.deleteUniqueNamedKey(nickname);
    }

    public static SymmetricKey createDes3SessionKeyOnInternal() throws Exception {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = cm.getInternalKeyStorageToken();
        KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.DES3);
        SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
        kg.setKeyUsages(usages);
        kg.temporaryKeys(true);
        return kg.generate();
    }

    public static List<byte[]> exportSharedSecret(String nickname, java.security.cert.X509Certificate wrappingCert, SymmetricKey wrappingKey) throws Exception {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = cm.getInternalKeyStorageToken();
        ArrayList<byte[]> listWrappedKeys = new ArrayList<byte[]>();
        KeyManager km = new KeyManager(token);
        if (!km.uniqueNamedKeyExists(nickname)) {
            throw new IOException("Shared secret " + nickname + " does not exist");
        }
        SymmetricKey sharedSecretKey = null;
        try {
            sharedSecretKey = CryptoUtil.getSymKeyByName(token, nickname);
        }
        catch (Exception e) {
            sharedSecretKey = null;
        }
        if (sharedSecretKey == null) {
            throw new IOException("Shared secret " + nickname + " does not exist");
        }
        PublicKey pub = wrappingCert.getPublicKey();
        PK11PubKey pubK = PK11PubKey.fromSPKI((byte[])pub.getEncoded());
        byte[] wrappedKey = CryptoUtil.wrapUsingPublicKey(token, (PublicKey)pubK, wrappingKey, KeyWrapAlgorithm.RSA);
        listWrappedKeys.add(wrappedKey);
        byte[] wrappedSharedSecret = CryptoUtil.wrapUsingSymmetricKey(token, wrappingKey, sharedSecretKey, null, KeyWrapAlgorithm.DES3_ECB);
        listWrappedKeys.add(wrappedSharedSecret);
        if (listWrappedKeys.size() != 2) {
            throw new IOException("Can't write out shared secret data to export for nickname: " + nickname);
        }
        return listWrappedKeys;
    }

    public static void importSharedSecret(byte[] wrappedSessionKey, byte[] wrappedSharedSecret, String subsystemCertNickname, String sharedSecretNickname) throws Exception, NotInitializedException, TokenException, NoSuchAlgorithmException, ObjectNotFoundException, InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken token = cm.getInternalKeyStorageToken();
        KeyManager km = new KeyManager(token);
        if (km.uniqueNamedKeyExists(sharedSecretNickname)) {
            throw new IOException("Shared secret " + sharedSecretNickname + " already exists");
        }
        KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.RSA);
        X509Certificate cert = cm.findCertByNickname(subsystemCertNickname);
        org.mozilla.jss.crypto.PrivateKey subsystemPrivateKey = cm.findPrivKeyByCert(cert);
        keyWrap.initUnwrap(subsystemPrivateKey, null);
        SymmetricKey unwrappedSessionKey = keyWrap.unwrapSymmetric(wrappedSessionKey, SymmetricKey.DES3, 0);
        SymmetricKey unwrappedSharedSecret = null;
        KeyWrapper sharedSecretWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES3_ECB);
        sharedSecretWrap.initUnwrap(unwrappedSessionKey, null);
        unwrappedSharedSecret = sharedSecretWrap.unwrapSymmetricPerm(wrappedSharedSecret, SymmetricKey.DES3, 0);
        unwrappedSharedSecret.setNickName(sharedSecretNickname);
    }

    public static SymmetricKey getSymKeyByName(CryptoToken token, String name) throws Exception {
        SymmetricKey[] keys;
        String method = "CryptoUtil.getSymKeyByName:";
        if (token == null || name == null) {
            throw new Exception(method + "Invalid input data!");
        }
        try {
            keys = token.getCryptoStore().getSymmetricKeys();
        }
        catch (TokenException e) {
            throw new Exception(method + "Can't get the list of symmetric keys!");
        }
        for (SymmetricKey cur : keys) {
            if (cur == null || !name.equals(cur.getNickName())) continue;
            return cur;
        }
        return null;
    }

    public static String[] getECcurves() {
        return ecCurves;
    }

    public static Vector<String> getECKeyCurve(X509Key key) throws Exception {
        AlgorithmId algid = key.getAlgorithmId();
        String params = null;
        if (algid != null) {
            params = algid.getParametersString();
        }
        if (params != null && params.startsWith("OID.")) {
            params = params.substring(4);
        }
        return ecOIDs.get(params);
    }

    public static byte[] decryptUsingSymmetricKey(CryptoToken token, IVParameterSpec ivspec, byte[] encryptedData, SymmetricKey wrappingKey, EncryptionAlgorithm encryptionAlgorithm) throws Exception {
        Cipher decryptor = token.getCipherContext(encryptionAlgorithm);
        decryptor.initDecrypt(wrappingKey, (AlgorithmParameterSpec)ivspec);
        return decryptor.doFinal(encryptedData);
    }

    public static byte[] encryptUsingSymmetricKey(CryptoToken token, SymmetricKey wrappingKey, byte[] data, EncryptionAlgorithm alg, IVParameterSpec ivspec) throws Exception {
        Cipher cipher = token.getCipherContext(alg);
        cipher.initEncrypt(wrappingKey, (AlgorithmParameterSpec)ivspec);
        return cipher.doFinal(data);
    }

    public static byte[] wrapUsingSymmetricKey(CryptoToken token, SymmetricKey wrappingKey, SymmetricKey data, IVParameterSpec ivspec, KeyWrapAlgorithm alg) throws Exception {
        KeyWrapper wrapper = token.getKeyWrapper(alg);
        wrapper.initWrap(wrappingKey, (AlgorithmParameterSpec)ivspec);
        return wrapper.wrap(data);
    }

    public static byte[] wrapUsingSymmetricKey(CryptoToken token, SymmetricKey wrappingKey, org.mozilla.jss.crypto.PrivateKey data, IVParameterSpec ivspec, KeyWrapAlgorithm alg) throws Exception {
        KeyWrapper wrapper = token.getKeyWrapper(alg);
        wrapper.initWrap(wrappingKey, (AlgorithmParameterSpec)ivspec);
        return wrapper.wrap(data);
    }

    public static byte[] wrapUsingPublicKey(CryptoToken token, PublicKey wrappingKey, SymmetricKey data, KeyWrapAlgorithm alg) throws Exception {
        String method = "CryptoUtil.wrapUsingPublicKey ";
        KeyWrapper rsaWrap = token.getKeyWrapper(alg);
        logger.debug(method + " KeyWrapAlg: " + alg);
        if (alg.equals(KeyWrapAlgorithm.RSA_OAEP)) {
            OAEPParameterSpec config = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            rsaWrap.initWrap(wrappingKey, (AlgorithmParameterSpec)config);
        } else {
            rsaWrap.initWrap(wrappingKey, null);
        }
        return rsaWrap.wrap(data);
    }

    public static SymmetricKey unwrap(CryptoToken token, SymmetricKey.Type keyType, int strength, SymmetricKey.Usage usage, SymmetricKey wrappingKey, byte[] wrappedData, KeyWrapAlgorithm wrapAlgorithm, IVParameterSpec wrappingIV) throws Exception {
        KeyWrapper wrapper = token.getKeyWrapper(wrapAlgorithm);
        wrapper.initUnwrap(wrappingKey, (AlgorithmParameterSpec)wrappingIV);
        return wrapper.unwrapSymmetric(wrappedData, keyType, usage, strength / 8);
    }

    public static SymmetricKey unwrap(CryptoToken token, SymmetricKey.Type keyType, int strength, SymmetricKey.Usage usage, org.mozilla.jss.crypto.PrivateKey wrappingKey, byte[] wrappedData, KeyWrapAlgorithm wrapAlgorithm) throws Exception {
        KeyWrapper keyWrapper = token.getKeyWrapper(wrapAlgorithm);
        String method = "CryptoUtil.unwrap";
        logger.debug(method + " KeyWrapAlg: " + wrapAlgorithm);
        if (wrapAlgorithm.equals(KeyWrapAlgorithm.RSA_OAEP)) {
            OAEPParameterSpec config = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            keyWrapper.initUnwrap(wrappingKey, (AlgorithmParameterSpec)config);
        } else {
            keyWrapper.initUnwrap(wrappingKey, null);
        }
        return keyWrapper.unwrapSymmetric(wrappedData, keyType, usage, strength / 8);
    }

    public static org.mozilla.jss.crypto.PrivateKey unwrap(CryptoToken token, PublicKey pubKey, boolean temporary, SymmetricKey wrappingKey, byte[] wrappedData, KeyWrapAlgorithm wrapAlgorithm, IVParameterSpec wrapIV) throws Exception {
        KeyWrapper wrapper = token.getKeyWrapper(wrapAlgorithm);
        wrapper.initUnwrap(wrappingKey, (AlgorithmParameterSpec)wrapIV);
        PrivateKey.Type keyType = null;
        if (pubKey.getAlgorithm().equalsIgnoreCase("RSA")) {
            keyType = org.mozilla.jss.crypto.PrivateKey.RSA;
        } else if (pubKey.getAlgorithm().equalsIgnoreCase("DSA")) {
            keyType = org.mozilla.jss.crypto.PrivateKey.DSA;
        } else if (pubKey.getAlgorithm().equalsIgnoreCase("EC")) {
            keyType = org.mozilla.jss.crypto.PrivateKey.EC;
        }
        org.mozilla.jss.crypto.PrivateKey pk = null;
        pk = temporary ? wrapper.unwrapTemporaryPrivate(wrappedData, keyType, pubKey) : wrapper.unwrapPrivate(wrappedData, keyType, pubKey);
        return pk;
    }

    public static EnvelopedData createEnvelopedData(byte[] encContent, byte[] encSymKey) throws Exception {
        String method = "CryptoUtl: createEnvelopedData: ";
        Object msg = "";
        logger.debug(method + "begins");
        if (encContent == null || encSymKey == null) {
            msg = method + "method parameters cannot be null";
            logger.warn((String)msg);
            throw new Exception(method + (String)msg);
        }
        byte[] default_iv = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        OBJECT_IDENTIFIER oid = EncryptionAlgorithm.AES_128_CBC.toOID();
        AlgorithmIdentifier aid = new AlgorithmIdentifier(oid, (ASN1Value)new OCTET_STRING(default_iv));
        EncryptedContentInfo encCInfo = new EncryptedContentInfo(ContentInfo.DATA, aid, new OCTET_STRING(encContent));
        Name name = new Name();
        name.addCommonName("unUsedIssuerName");
        RecipientInfo recipient = new RecipientInfo(new INTEGER(0L), new IssuerAndSerialNumber(name, new INTEGER(0L)), new AlgorithmIdentifier(RSA_ENCRYPTION, (ASN1Value)new NULL()), new OCTET_STRING(encSymKey));
        SET recipients = new SET();
        recipients.addElement((ASN1Value)recipient);
        return new EnvelopedData(new INTEGER(0L), recipients, encCInfo);
    }

    public static String getDefaultHashAlgName() {
        return "SHA-256";
    }

    public static AlgorithmIdentifier getDefaultHashAlg() throws Exception {
        AlgorithmIdentifier hashAlg = new AlgorithmIdentifier(CryptoUtil.getHashAlgorithmOID(CryptoUtil.getDefaultHashAlgName()));
        return hashAlg;
    }

    @Deprecated(since="11.0.1", forRemoval=true)
    public static Key importHmacSha1Key(byte[] key) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("HmacSHA1", "Mozilla-JSS");
        return factory.generateSecret(new SecretKeySpec(key, "SHA1_HMAC"));
    }

    public static String getHMACtoMessageDigestName(String name) {
        String mdName = name;
        if (name != null) {
            if (name.equals("SHA-256-HMAC")) {
                mdName = "SHA-256";
            } else if (name.equals("SHA-384-HMAC")) {
                mdName = "SHA-384";
            } else if (name.equals("SHA-512-HMAC")) {
                mdName = "SHA-512";
            }
        }
        return mdName;
    }

    public static OBJECT_IDENTIFIER getHMACAlgorithmOID(String name) throws NoSuchAlgorithmException {
        OBJECT_IDENTIFIER oid = null;
        if (name != null) {
            if (name.equals("SHA-256-HMAC")) {
                oid = HMACAlgorithm.SHA256.toOID();
            } else if (name.equals("SHA-384-HMAC")) {
                oid = HMACAlgorithm.SHA384.toOID();
            } else if (name.equals("SHA-512-HMAC")) {
                oid = HMACAlgorithm.SHA512.toOID();
            }
        }
        if (oid == null) {
            throw new NoSuchAlgorithmException();
        }
        return oid;
    }

    public static OBJECT_IDENTIFIER getHashAlgorithmOID(String name) throws NoSuchAlgorithmException {
        OBJECT_IDENTIFIER oid = null;
        if (name != null) {
            if (name.equals("SHA-256")) {
                oid = DigestAlgorithm.SHA256.toOID();
            } else if (name.equals("SHA-384")) {
                oid = DigestAlgorithm.SHA384.toOID();
            } else if (name.equals("SHA-512")) {
                oid = DigestAlgorithm.SHA512.toOID();
            }
        }
        if (oid == null) {
            throw new NoSuchAlgorithmException();
        }
        return oid;
    }

    public static String getNameFromHashAlgorithm(AlgorithmIdentifier ai) throws NoSuchAlgorithmException {
        logger.debug("CryptoUtil: getNameFromHashAlgorithm: " + ai.getOID().toString());
        if (ai != null) {
            if (ai.getOID().equals((Object)DigestAlgorithm.SHA256.toOID())) {
                return "SHA-256";
            }
            if (ai.getOID().equals((Object)DigestAlgorithm.SHA384.toOID())) {
                return "SHA-384";
            }
            if (ai.getOID().equals((Object)DigestAlgorithm.SHA512.toOID())) {
                return "SHA-512";
            }
        }
        throw new NoSuchAlgorithmException();
    }

    public static String getHMACAlgName(String name) {
        logger.debug("CrytoUtil: getHMaCAlgName: name: " + name);
        String mdName = "HmacSHA256";
        if (name != null) {
            if (name.equals("SHA-256-HMAC")) {
                mdName = "HmacSHA256";
            } else if (name.equals("SHA-384-HMAC")) {
                mdName = "HmacSHAS384";
            } else if (name.equals("SHA-512-HMAC")) {
                mdName = "HmacSHA512";
            }
        }
        logger.debug("CrytoUtil: getHMaCAlgName: returning: " + mdName);
        return mdName;
    }

    public static OBJECT_IDENTIFIER getOID(KeyWrapAlgorithm kwAlg) throws NoSuchAlgorithmException {
        String name = kwAlg.toString();
        if (name.equals(KeyWrapAlgorithm.AES_KEY_WRAP_PAD.toString())) {
            return KeyWrapAlgorithm.AES_KEY_WRAP_PAD_OID;
        }
        if (name.equals(KeyWrapAlgorithm.AES_KEY_WRAP.toString())) {
            return KeyWrapAlgorithm.AES_KEY_WRAP_OID;
        }
        if (name.equals(KeyWrapAlgorithm.AES_CBC_PAD.toString())) {
            return KeyWrapAlgorithm.AES_CBC_PAD_OID;
        }
        if (name.equals(KeyWrapAlgorithm.DES3_CBC_PAD.toString())) {
            return KeyWrapAlgorithm.DES_CBC_PAD_OID;
        }
        if (name.equals(KeyWrapAlgorithm.DES_CBC_PAD.toString())) {
            return KeyWrapAlgorithm.DES_CBC_PAD_OID;
        }
        if (name.equals(KeyWrapAlgorithm.AES_KEY_WRAP_PAD_KWP.toString())) {
            return KeyWrapAlgorithm.AES_KEY_WRAP_KWP_OID;
        }
        throw new NoSuchAlgorithmException();
    }

    public static String mapSignatureAlgorithmToInternalName(SignatureAlgorithm alg) throws NoSuchAlgorithmException {
        String method = "CryptoUtil.mapSignatureAlgorithmToInternalName ";
        if (alg == null) {
            throw new NoSuchAlgorithmException(method + alg);
        }
        String algname = alg.toString();
        if (algname.equals(SignatureAlgorithm.RSASignatureWithMD5Digest.toString())) {
            return "MD5withRSA";
        }
        if (algname.equals(SignatureAlgorithm.RSASignatureWithMD2Digest.toString())) {
            return "MD2withRSA";
        }
        if (algname.equals(SignatureAlgorithm.RSASignatureWithSHA1Digest.toString())) {
            return "SHA1withRSA";
        }
        if (algname.equals(SignatureAlgorithm.DSASignatureWithSHA1Digest.toString())) {
            return "SHA1withDSA";
        }
        if (algname.equals(SignatureAlgorithm.RSASignatureWithSHA256Digest.toString())) {
            return "SHA256withRSA";
        }
        if (algname.equals(SignatureAlgorithm.RSASignatureWithSHA384Digest.toString())) {
            return "SHA384withRSA";
        }
        if (algname.equals(SignatureAlgorithm.RSASignatureWithSHA512Digest.toString())) {
            return "SHA512withRSA";
        }
        if (algname.equals(SignatureAlgorithm.ECSignatureWithSHA1Digest.toString())) {
            return "SHA1withEC";
        }
        if (algname.equals(SignatureAlgorithm.ECSignatureWithSHA256Digest.toString())) {
            return "SHA256withEC";
        }
        if (algname.equals(SignatureAlgorithm.ECSignatureWithSHA384Digest.toString())) {
            return "SHA384withEC";
        }
        if (algname.equals(SignatureAlgorithm.ECSignatureWithSHA512Digest.toString())) {
            return "SHA512withEC";
        }
        if (algname.equals(SignatureAlgorithm.RSAPSSSignatureWithSHA256Digest.toString())) {
            return "SHA256withRSA/PSS";
        }
        if (algname.equals(SignatureAlgorithm.RSAPSSSignatureWithSHA384Digest.toString())) {
            return "SHA384withRSA/PSS";
        }
        if (algname.equals(SignatureAlgorithm.RSAPSSSignatureWithSHA512Digest.toString())) {
            return "SHA512withRSA/PSS";
        }
        throw new NoSuchAlgorithmException(method + alg);
    }
}

