/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.netscape.certsrv.request.RequestStatusDeserializer;
import com.netscape.certsrv.request.RequestStatusSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonSerialize(using=RequestStatusSerializer.class)
@JsonDeserialize(using=RequestStatusDeserializer.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class RequestStatus
implements Serializable {
    private static final long serialVersionUID = -8176052970922133411L;
    public static final Collection<RequestStatus> INSTANCES = new ArrayList<RequestStatus>();
    public static final Map<String, RequestStatus> LABELS = new LinkedHashMap<String, RequestStatus>();
    public static RequestStatus BEGIN = new RequestStatus("begin");
    public static RequestStatus PENDING = new RequestStatus("pending");
    public static RequestStatus APPROVED = new RequestStatus("approved");
    public static RequestStatus SVC_PENDING = new RequestStatus("svc_pending");
    public static RequestStatus CANCELED = new RequestStatus("canceled");
    public static RequestStatus REJECTED = new RequestStatus("rejected");
    public static RequestStatus COMPLETE = new RequestStatus("complete");
    public String label;

    private RequestStatus() {
    }

    private RequestStatus(String label) {
        this.label = label;
        INSTANCES.add(this);
        LABELS.put(label.toLowerCase(), this);
    }

    public static RequestStatus valueOf(String label) {
        return LABELS.get(label.toLowerCase());
    }

    @JsonValue
    public String toString() {
        return this.label;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestStatus other = (RequestStatus)obj;
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

