/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.netscape.certsrv.account.Account;
import com.netscape.certsrv.account.AccountClient;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmsutil.json.JSONObject;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.dogtagpki.common.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SubsystemClient
extends Client {
    public static final Logger logger = LoggerFactory.getLogger(SubsystemClient.class);
    public static String SUCCESS = "0";
    public static String FAILURE = "1";
    public static String AUTH_FAILURE = "2";
    public AccountClient accountClient;

    public SubsystemClient(PKIClient client, String name) throws Exception {
        super(client, name, name);
        this.accountClient = new AccountClient(client, name, "rest");
        this.addClient(this.accountClient);
    }

    public Account login() throws Exception {
        return this.accountClient.login();
    }

    public boolean exists() throws Exception {
        ClientConfig config = this.client.getConfig();
        URI serverURI = config.getServerURL().toURI();
        URI subsystemURI = new URI(serverURI.getScheme(), null, serverURI.getHost(), serverURI.getPort(), "/" + this.name, null, null);
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet method = new HttpGet(subsystemURI);
            CloseableHttpResponse response = client.execute((HttpUriRequest)method);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                boolean bl = true;
                return bl;
            }
            if (code == 404) {
                boolean bl = false;
                return bl;
            }
            throw new Exception("Error: " + response.getStatusLine());
        }
    }

    public Range requestRange(String type, String sessionID) throws Exception {
        logger.info("Requesting " + type + " range");
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"type", (Object)type);
        content.putSingle((Object)"xmlOutput", (Object)"true");
        content.putSingle((Object)"sessionID", (Object)sessionID);
        String response = this.client.post(this.name + "/admin/" + this.name + "/updateNumberRange", (MultivaluedMap<String, String>)content, String.class);
        logger.debug("Response: " + response);
        if (StringUtils.isEmpty((CharSequence)response)) {
            String message = "Unable to request " + type + " range";
            logger.error(message);
            throw new IOException(message);
        }
        try {
            return this.buildRangeFromJSONResponse(new ByteArrayInputStream(response.getBytes()));
        }
        catch (Exception e) {
            return this.buildRangeFromXMLResponse(new ByteArrayInputStream(response.getBytes()));
        }
    }

    private Range buildRangeFromJSONResponse(ByteArrayInputStream bais) throws IOException, EAuthException {
        JSONObject parser = new JSONObject(bais);
        JsonNode responseNode = parser.getJsonNode().get("Response");
        String status = responseNode.get("Status").asText();
        logger.debug("Status: " + status);
        if (status.equals(AUTH_FAILURE)) {
            throw new EAuthException(AUTH_FAILURE);
        }
        if (!status.equals(SUCCESS)) {
            String error = parser.getJsonNode().get("Error").asText();
            throw new IOException(error);
        }
        String begin = responseNode.get("beginNumber").asText();
        logger.info("Begin: " + begin);
        String end = responseNode.get("endNumber").asText();
        logger.info("End: " + end);
        Range range = new Range();
        range.setBegin(begin);
        range.setEnd(end);
        return range;
    }

    @Deprecated(since="11.0.0", forRemoval=true)
    private Range buildRangeFromXMLResponse(ByteArrayInputStream bais) throws IOException, EAuthException, SAXException, ParserConfigurationException {
        XMLObject parser = new XMLObject(bais);
        String status = parser.getValue("Status");
        logger.debug("Status: " + status);
        if (status.equals(AUTH_FAILURE)) {
            throw new EAuthException(AUTH_FAILURE);
        }
        if (!status.equals(SUCCESS)) {
            String error = parser.getValue("Error");
            throw new IOException(error);
        }
        String begin = parser.getValue("beginNumber");
        logger.info("Begin: " + begin);
        String end = parser.getValue("endNumber");
        logger.info("End: " + end);
        Range range = new Range();
        range.setBegin(begin);
        range.setEnd(end);
        return range;
    }

    public void addUser(URI secdomainURI, String uid, String subsystemName, String subsystemCert, String sessionId) throws Exception {
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"uid", (Object)uid);
        content.putSingle((Object)"xmlOutput", (Object)"true");
        content.putSingle((Object)"sessionID", (Object)sessionId);
        content.putSingle((Object)"auth_hostname", (Object)secdomainURI.getHost());
        content.putSingle((Object)"auth_port", (Object)("" + secdomainURI.getPort()));
        content.putSingle((Object)"certificate", (Object)subsystemCert);
        content.putSingle((Object)"name", (Object)subsystemName);
        String path = this.name + "/admin/" + this.name + "/registerUser";
        String response = this.client.post(path, (MultivaluedMap<String, String>)content, String.class);
        logger.debug("SubsystemClient: Response: " + response);
        if (response == null || response.equals("")) {
            logger.error("SubsystemClient: No response");
            throw new IOException("No response");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        try {
            this.processJSONResponse(bis);
        }
        catch (Exception e) {
            this.processXMLResponse(bis);
        }
        logger.debug("SubsystemClient: Added user " + uid);
    }

    private void processJSONResponse(ByteArrayInputStream bis) throws EAuthException, IOException {
        JSONObject parser = new JSONObject(bis);
        JsonNode responseNode = parser.getJsonNode().get("Response");
        String status = responseNode.get("Status").asText();
        logger.debug("SubsystemClient: Status: " + status);
        if (status.equals(AUTH_FAILURE)) {
            throw new EAuthException(AUTH_FAILURE);
        }
        if (!status.equals(SUCCESS)) {
            String error = parser.getJsonNode().get("Error").asText();
            throw new IOException(error);
        }
    }

    @Deprecated(since="11.0.0", forRemoval=true)
    private void processXMLResponse(ByteArrayInputStream bis) throws EAuthException, IOException, SAXException, ParserConfigurationException {
        XMLObject parser = new XMLObject(bis);
        String status = parser.getValue("Status");
        logger.debug("SubsystemClient: Status: " + status);
        if (status.equals(AUTH_FAILURE)) {
            throw new EAuthException(AUTH_FAILURE);
        }
        if (!status.equals(SUCCESS)) {
            String error = parser.getValue("Error");
            throw new IOException(error);
        }
    }

    public void logout() throws Exception {
        this.accountClient.logout();
    }
}

