/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.client;

import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClientAuthenticator;
import com.netscape.certsrv.client.PKIRESTProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.ClientParamsStack;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.ssl.SSLAlertDescription;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLAlertLevel;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIConnection
implements AutoCloseable {
    public static Logger logger = LoggerFactory.getLogger(PKIConnection.class);
    ClientConfig config;
    DefaultHttpClient httpClient = new DefaultHttpClient();
    SSLCertificateApprovalCallback callback;
    ApacheHttpClient4Engine engine;
    Client client;
    WebTarget target;
    int requestCounter;
    int responseCounter;
    File output;

    public PKIConnection(ClientConfig config) throws Exception {
        this.config = config;
        Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)new JSSProtocolSocketFactory());
        this.httpClient.getConnectionManager().getSchemeRegistry().register(scheme);
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                ++PKIConnection.this.requestCounter;
                logger.info("HTTP request: " + request.getRequestLine());
                for (Header header : request.getAllHeaders()) {
                    String name = header.getName();
                    String value = header.getValue();
                    if ("Authorization".equalsIgnoreCase(name)) {
                        value = "********";
                    }
                    logger.info("  " + name + ": " + value);
                }
                if (PKIConnection.this.output != null) {
                    File file = new File(PKIConnection.this.output, "http-request-" + PKIConnection.this.requestCounter);
                    try (PrintStream out = new PrintStream(file);){
                        PKIConnection.this.storeRequest(out, request);
                    }
                    logger.debug("Request: " + file.getAbsolutePath());
                } else if (logger.isDebugEnabled()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try (PrintStream out = new PrintStream(os);){
                        PKIConnection.this.storeRequest(out, request);
                    }
                    logger.debug("Request:\n" + os.toString("UTF-8"));
                }
                HttpParams params = request.getParams();
                if (params instanceof ClientParamsStack) {
                    ClientParamsStack paramsStack = (ClientParamsStack)request.getParams();
                    params = paramsStack.getRequestParams();
                }
                HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
            }
        });
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                ++PKIConnection.this.responseCounter;
                logger.info("HTTP response: " + response.getStatusLine());
                for (Header header : response.getAllHeaders()) {
                    logger.info("  " + header.getName() + ": " + header.getValue());
                }
                if (PKIConnection.this.output != null) {
                    File file = new File(PKIConnection.this.output, "http-response-" + PKIConnection.this.responseCounter);
                    try (PrintStream out = new PrintStream(file);){
                        PKIConnection.this.storeResponse(out, response);
                    }
                    logger.debug("Response: " + file.getAbsolutePath());
                } else if (logger.isDebugEnabled()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try (PrintStream out = new PrintStream(os);){
                        PKIConnection.this.storeResponse(out, response);
                    }
                    logger.debug("Response:\n" + os.toString("UTF-8"));
                }
            }
        });
        this.httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                HttpUriRequest uriRequest = super.getRedirect(request, response, context);
                URI uri = uriRequest.getURI();
                logger.info("HTTP redirect: " + uri);
                Object wrapper = request instanceof HttpEntityEnclosingRequest ? new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request) : new RequestWrapper(request);
                wrapper.setURI(uri);
                return wrapper;
            }

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return response.getStatusLine().getStatusCode() == 302;
            }
        });
        this.engine = new ApacheHttpClient4Engine((HttpClient)this.httpClient);
        this.client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)this.engine).build();
        this.client.register((Object)new PKIClientAuthenticator(config), 1000);
        this.client.register(PKIRESTProvider.class);
        URI uri = config.getServerURL().toURI();
        this.target = this.client.target(uri);
    }

    public void setCallback(SSLCertificateApprovalCallback callback) {
        this.callback = callback;
    }

    public void storeRequest(PrintStream out, HttpRequest request) throws IOException {
        if (request instanceof EntityEnclosingRequestWrapper) {
            EntityEnclosingRequestWrapper wrapper = (EntityEnclosingRequestWrapper)request;
            HttpEntity entity = wrapper.getEntity();
            if (entity == null) {
                return;
            }
            if (!entity.isRepeatable()) {
                BufferedHttpEntity bufferedEntity = new BufferedHttpEntity(entity);
                wrapper.setEntity((HttpEntity)bufferedEntity);
                entity = bufferedEntity;
            }
            this.storeEntity(out, entity);
        }
    }

    public void storeResponse(PrintStream out, HttpResponse response) throws IOException {
        if (response instanceof BasicHttpResponse) {
            BasicHttpResponse basicResponse = (BasicHttpResponse)response;
            HttpEntity entity = basicResponse.getEntity();
            if (entity == null) {
                return;
            }
            if (!entity.isRepeatable()) {
                BufferedHttpEntity bufferedEntity = new BufferedHttpEntity(entity);
                basicResponse.setEntity((HttpEntity)bufferedEntity);
                entity = bufferedEntity;
            }
            this.storeEntity(out, entity);
        }
    }

    public void storeEntity(OutputStream out, HttpEntity entity) throws IOException {
        byte[] buffer = new byte[1024];
        try (InputStream in = entity.getContent();){
            int c;
            while ((c = in.read(buffer)) > 0) {
                out.write(buffer, 0, c);
            }
        }
    }

    public WebTarget target(String path) {
        return this.target.path(path);
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @Override
    public void close() {
        this.client.close();
        this.engine.close();
        this.httpClient.close();
    }

    private class JSSProtocolSocketFactory
    implements SchemeLayeredSocketFactory {
        private JSSProtocolSocketFactory() {
        }

        public Socket createSocket(HttpParams params) throws IOException {
            return null;
        }

        public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException {
            try {
                CryptoManager.getInstance();
            }
            catch (NotInitializedException e) {
                throw new Error("Certificate database not initialized.", e);
            }
            String hostName = null;
            int port = 0;
            if (remoteAddress != null) {
                hostName = remoteAddress.getHostName();
                port = remoteAddress.getPort();
            }
            int localPort = 0;
            InetAddress localAddr = null;
            if (localAddress != null) {
                localPort = localAddress.getPort();
                localAddr = localAddress.getAddress();
            }
            SSLSocket socket = sock == null ? new SSLSocket(InetAddress.getByName(hostName), port, localAddr, localPort, PKIConnection.this.callback, null) : new SSLSocket(sock, hostName, PKIConnection.this.callback, null);
            String certNickname = PKIConnection.this.config.getCertNickname();
            if (certNickname != null) {
                logger.info("Client certificate: " + certNickname);
                socket.setClientCertNickname(certNickname);
            }
            socket.addSocketListener(new SSLSocketListener(){

                public void alertReceived(SSLAlertEvent event) {
                    int intLevel = event.getLevel();
                    SSLAlertLevel level = SSLAlertLevel.valueOf((int)intLevel);
                    int intDescription = event.getDescription();
                    SSLAlertDescription description = SSLAlertDescription.valueOf((int)intDescription);
                    if (level == SSLAlertLevel.FATAL || logger.isInfoEnabled()) {
                        logger.error(level + ": SSL alert received: " + description);
                    }
                }

                public void alertSent(SSLAlertEvent event) {
                    int intLevel = event.getLevel();
                    SSLAlertLevel level = SSLAlertLevel.valueOf((int)intLevel);
                    int intDescription = event.getDescription();
                    SSLAlertDescription description = SSLAlertDescription.valueOf((int)intDescription);
                    if (level == SSLAlertLevel.FATAL || logger.isInfoEnabled()) {
                        logger.error(level + ": SSL alert sent: " + description);
                    }
                }

                public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
                }
            });
            return socket;
        }

        public boolean isSecure(Socket sock) {
            return true;
        }

        public Socket createLayeredSocket(Socket socket, String target, int port, HttpParams params) throws IOException, UnknownHostException {
            return null;
        }
    }
}

