/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.util.JSONSerializer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientConfig
implements JSONSerializer {
    URL serverURL;
    String nssDatabase;
    String nssPassword;
    Map<String, String> nssPasswords = new LinkedHashMap<String, String>();
    String tokenName;
    String certNickname;
    String username;
    String password;
    String messageFormat;

    public ClientConfig() {
    }

    public ClientConfig(ClientConfig config) {
        this.serverURL = config.serverURL;
        this.nssDatabase = config.nssDatabase;
        this.nssPassword = config.nssPassword;
        this.nssPasswords.clear();
        this.nssPasswords.putAll(config.nssPasswords);
        this.tokenName = config.tokenName;
        this.certNickname = config.certNickname;
        this.username = config.username;
        this.password = config.password;
        this.messageFormat = config.messageFormat;
    }

    public void setServerURI(URI serverUri) {
        try {
            this.serverURL = serverUri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) throws MalformedURLException {
        this.serverURL = new URL(serverURL);
    }

    public void setServerURL(String protocol, String hostname, int port) throws MalformedURLException {
        this.serverURL = new URL(protocol, hostname, port, "");
    }

    public void setServerURL(URL serverURL) {
        this.serverURL = serverURL;
    }

    public String getSubsystem() {
        String path = this.serverURL.getPath();
        if (path.length() <= 1) {
            return null;
        }
        return path.substring(1);
    }

    public String getNSSDatabase() {
        return this.nssDatabase;
    }

    public void setNSSDatabase(String nssDatabase) {
        this.nssDatabase = nssDatabase;
    }

    public String getNSSPassword() {
        return this.nssPassword;
    }

    public void setNSSPassword(String nssPassword) {
        this.nssPassword = nssPassword;
    }

    public Map<String, String> getNSSPasswords() {
        return this.nssPasswords;
    }

    public void setNSSPasswords(Map<String, String> nssPasswords) {
        this.nssPasswords.clear();
        this.nssPasswords.putAll(nssPasswords);
    }

    public String getNSSPassword(String name) {
        return this.nssPasswords.get(name);
    }

    public void setNSSPassword(String name, String value) {
        this.nssPasswords.put(name, value);
    }

    public String removeNSSPassword(String name) {
        return this.nssPasswords.remove(name);
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public String getCertNickname() {
        return this.certNickname;
    }

    public void setCertNickname(String certNickname) {
        this.certNickname = certNickname;
    }

    @Deprecated
    public String getCertPassword() {
        return this.nssPassword;
    }

    @Deprecated
    public void setCertPassword(String certPassword) {
        this.nssPassword = certPassword;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public void setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certNickname == null ? 0 : this.certNickname.hashCode());
        result = 31 * result + (this.messageFormat == null ? 0 : this.messageFormat.hashCode());
        result = 31 * result + (this.nssDatabase == null ? 0 : this.nssDatabase.hashCode());
        result = 31 * result + (this.nssPassword == null ? 0 : this.nssPassword.hashCode());
        result = 31 * result + (this.nssPasswords == null ? 0 : this.nssPasswords.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.serverURL == null ? 0 : this.serverURL.hashCode());
        result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)obj;
        if (this.certNickname == null ? other.certNickname != null : !this.certNickname.equals(other.certNickname)) {
            return false;
        }
        if (this.messageFormat == null ? other.messageFormat != null : !this.messageFormat.equals(other.messageFormat)) {
            return false;
        }
        if (this.nssDatabase == null ? other.nssDatabase != null : !this.nssDatabase.equals(other.nssDatabase)) {
            return false;
        }
        if (this.nssPassword == null ? other.nssPassword != null : !this.nssPassword.equals(other.nssPassword)) {
            return false;
        }
        if (this.nssPasswords == null ? other.nssPasswords != null : !this.nssPasswords.equals(other.nssPasswords)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.serverURL == null ? other.serverURL != null : !this.serverURL.equals(other.serverURL)) {
            return false;
        }
        if (this.tokenName == null ? other.tokenName != null : !this.tokenName.equals(other.tokenName)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public static class NSSPassword {
        public String name;
        public String value;
    }

    public static class NSSPasswordList {
        public List<NSSPassword> passwords = new ArrayList<NSSPassword>();
    }
}

