/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.cert;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.dbs.certdb.CertId;

public class CertNotFoundException
extends ResourceNotFoundException {
    private static final long serialVersionUID = -4784839378360933483L;
    public CertId certId;

    public CertNotFoundException(CertId certId) {
        this(certId, "Certificate ID " + certId.toHexString() + " not found");
    }

    public CertNotFoundException(CertId certId, String message) {
        super(message);
        this.certId = certId;
    }

    public CertNotFoundException(CertId certId, String message, Throwable cause) {
        super(message, cause);
        this.certId = certId;
    }

    public CertNotFoundException(PKIException.Data data) {
        super(data);
        this.certId = new CertId(data.getAttribute("certId"));
    }

    @Override
    public PKIException.Data getData() {
        PKIException.Data data = super.getData();
        data.setAttribute("certId", this.certId.toString());
        return data;
    }

    public CertId getCertId() {
        return this.certId;
    }

    public void setRequestId(CertId certId) {
        this.certId = certId;
    }
}

