/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.account;

import com.netscape.certsrv.account.Account;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountClient
extends Client {
    public static Logger logger = LoggerFactory.getLogger(AccountClient.class);
    public boolean loggedIn;

    public AccountClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, null, "account");
    }

    public AccountClient(PKIClient client, String subsystem, String prefix) throws Exception {
        super(client, subsystem, prefix, "account");
    }

    public Account login() throws Exception {
        Account account = this.get("login", Account.class);
        this.loggedIn = true;
        logger.info("Account:");
        logger.info("- ID: " + account.getID());
        logger.info("- Full Name: " + account.getFullName());
        logger.info("- Email: " + account.getEmail());
        logger.info("Roles:");
        for (String role : account.getRoles()) {
            logger.info("- " + role);
        }
        return account;
    }

    public void logout() throws Exception {
        if (!this.loggedIn) {
            return;
        }
        this.get("logout", Void.class);
        this.loggedIn = false;
    }
}

