/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.ocsp.IOCSPStore;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.ocsp.OCSPAuthority;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ocsp.OCSPConfig;
import org.dogtagpki.server.ocsp.OCSPEngine;

public class OCSPAdminServlet
extends AdminServlet {
    private static final long serialVersionUID = -3349635369730415767L;
    protected static final String PROP_ENABLED = "enabled";
    private static final String INFO = "OCSPAdminServlet";
    private OCSPAuthority mOCSP = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        OCSPEngine engine = OCSPEngine.getInstance();
        this.mOCSP = (OCSPAuthority)engine.getSubsystem("ocsp");
    }

    public String getServletInfo() {
        return INFO;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        String op = req.getParameter("OP_TYPE");
        String scope = req.getParameter("OP_SCOPE");
        if (op == null || scope == null) {
            this.sendResponse(1, "Invalid Protocol", null, resp);
            return;
        }
        super.authenticate(req);
        try {
            AUTHZ_RES_NAME = "certServer.ocsp.configuration";
            if (scope.equals("extendedPluginInfo")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                try {
                    this.getExtendedPluginInfo(req, resp);
                    return;
                }
                catch (EBaseException e) {
                    this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
                }
            }
            if (scope.equals("ocspStoreDef") && op.equals("OP_MODIFY")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                this.setDefaultStore(req, resp);
                return;
            }
            if (op.equals("OP_READ")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("general")) {
                    this.getGeneralConfig(req, resp);
                    return;
                }
                if (scope.equals("ocspStoresRules")) {
                    this.getOCSPStoresConfig(req, resp);
                    return;
                }
            } else if (op.equals("OP_MODIFY")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("general")) {
                    this.setGeneralConfig(req, resp);
                    return;
                }
                if (scope.equals("ocspStoresRules")) {
                    this.setOCSPStoresConfig(req, resp);
                    return;
                }
            } else if (op.equals("OP_SEARCH")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("ocspStoresRules")) {
                    this.listOCSPStoresConfig(req, resp);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.sendResponse(1, e.toString(), null, resp);
            return;
        }
    }

    private void getExtendedPluginInfo(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        int colon = id.indexOf(58);
        String implName = id.substring(colon + 1);
        NameValuePairs params = this.getExtendedPluginInfo(implName);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private NameValuePairs getExtendedPluginInfo(String implName) {
        IExtendedPluginInfo ext_info = null;
        IExtendedPluginInfo impl = null;
        impl = OCSPAdminServlet.getClassByNameAsExtendedPluginInfo((String)implName);
        if (impl != null && impl instanceof IExtendedPluginInfo) {
            ext_info = impl;
        }
        NameValuePairs nvps = null;
        nvps = ext_info == null ? new NameValuePairs() : this.convertStringArrayToNVPairs(ext_info.getExtendedPluginInfo());
        return nvps;
    }

    private void setDefaultStore(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        OCSPEngine engine = OCSPEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String id = req.getParameter("RS_ID");
            this.mOCSP.getConfigStore().putString("storeId", id);
            this.commit(true);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, null, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void getOCSPStoresConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        IOCSPStore store = this.mOCSP.getOCSPStore(id);
        NameValuePairs params = store.getConfigParameters();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setOCSPStoresConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        OCSPEngine engine = OCSPEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            NameValuePairs params = new NameValuePairs();
            String id = req.getParameter("RS_ID");
            IOCSPStore store = this.mOCSP.getOCSPStore(id);
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.equals("OP_TYPE") || name.equals("RS_ID") || name.equals("OP_SCOPE") || name.equals("implName") || name.equals("RULENAME")) continue;
                String value = req.getParameter(name);
                params.put((Object)name, (Object)value);
            }
            store.setConfigParameters(params);
            this.commit(true);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, null, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void listOCSPStoresConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        OCSPConfig config = this.mOCSP.getConfigStore();
        String defStore = config.getString("storeId");
        ConfigStore SubStore = config.getSubStore("store", ConfigStore.class);
        Enumeration enumStores = SubStore.getSubStoreNames().elements();
        while (enumStores.hasMoreElements()) {
            String storeName = (String)enumStores.nextElement();
            boolean storeEnabled = false;
            if (storeName.equals(defStore)) {
                storeEnabled = true;
            }
            params.put((Object)storeName, (Object)(storeName + ";visible;" + (storeEnabled ? PROP_ENABLED : "disabled")));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getGeneralConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        this.getSigningAlgConfig(params);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getSigningAlgConfig(NameValuePairs params) {
        String defaultAlgorithm = this.mOCSP.getDefaultAlgorithm();
        logger.info("OCSPAdminServlet: Default algorithm: " + defaultAlgorithm);
        params.put((Object)"defaultSigningAlgorithm", (Object)defaultAlgorithm);
        String[] algorithms = this.mOCSP.getOCSPSigningAlgorithms();
        StringBuffer algorStr = new StringBuffer();
        logger.info("OCSPAdminServlet: Signing algorithms:");
        for (int i = 0; i < algorithms.length; ++i) {
            logger.info("OCSPAdminServlet: - " + algorithms[i]);
            if (i > 0) {
                algorStr.append(":");
            }
            algorStr.append(algorithms[i]);
        }
        params.put((Object)"allSigningAlgorithms", (Object)algorStr.toString());
    }

    private void setGeneralConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        OCSPEngine engine = OCSPEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            Enumeration enum1 = req.getParameterNames();
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                String value = req.getParameter(key);
                if (!key.equals("defaultSigningAlgorithm")) continue;
                this.mOCSP.setDefaultAlgorithm(value);
            }
            this.commit(true);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, null, resp);
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_OCSP_PROFILE_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }
}

