/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.user.UserClient;
import com.netscape.certsrv.user.UserData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.user.UserCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserModifyCLI.class);
    public UserCLI userCLI;

    public UserModifyCLI(UserCLI userCLI) {
        super("mod", "Modify user", (CLI)userCLI);
        this.userCLI = userCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <User ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "fullName", true, "Full name");
        option.setArgName("fullName");
        this.options.addOption(option);
        option = new Option(null, "email", true, "Email");
        option.setArgName("email");
        this.options.addOption(option);
        option = new Option(null, "password", true, "Password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "phone", true, "Phone");
        option.setArgName("phone");
        this.options.addOption(option);
        option = new Option(null, "state", true, "State");
        option.setArgName("state");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No User ID specified.");
        }
        String userId = cmdArgs[0];
        UserData userData = new UserData();
        userData.setID(userId);
        userData.setFullName(cmd.getOptionValue("fullName"));
        userData.setEmail(cmd.getOptionValue("email"));
        userData.setPassword(cmd.getOptionValue("password"));
        userData.setPhone(cmd.getOptionValue("phone"));
        userData.setState(cmd.getOptionValue("state"));
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        UserClient userClient = this.userCLI.getUserClient();
        userData = userClient.modifyUser(userId, userData);
        MainCLI.printMessage("Modified user \"" + userId + "\"");
        UserCLI.printUser(userData);
    }
}

