/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.user.UserClient;
import com.netscape.certsrv.user.UserData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.cli.SubsystemCLI;
import com.netscape.cmstools.user.UserAddCLI;
import com.netscape.cmstools.user.UserCertCLI;
import com.netscape.cmstools.user.UserFindCLI;
import com.netscape.cmstools.user.UserMembershipCLI;
import com.netscape.cmstools.user.UserModifyCLI;
import com.netscape.cmstools.user.UserRemoveCLI;
import com.netscape.cmstools.user.UserShowCLI;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(UserCLI.class);
    public UserClient userClient;

    public UserCLI(CLI parent) {
        super("user", "User management commands", parent);
        this.addModule((CLI)new UserFindCLI(this));
        this.addModule((CLI)new UserShowCLI(this));
        this.addModule((CLI)new UserAddCLI(this));
        this.addModule((CLI)new UserModifyCLI(this));
        this.addModule((CLI)new UserRemoveCLI(this));
        this.addModule(new UserCertCLI(this));
        this.addModule(new UserMembershipCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getManPage() {
        return "pki-user";
    }

    public UserClient getUserClient() throws Exception {
        String subsystem;
        if (this.userClient != null) {
            return this.userClient;
        }
        PKIClient client = this.getClient();
        if (this.parent instanceof SubsystemCLI) {
            SubsystemCLI subsystemCLI = (SubsystemCLI)this.parent;
            subsystem = subsystemCLI.getName();
        } else {
            subsystem = client.getSubsystem();
            if (subsystem == null) {
                subsystem = "ca";
            }
        }
        this.userClient = new UserClient(client, subsystem);
        return this.userClient;
    }

    public static void printUser(UserData userData) {
        String tpsProfiles;
        String state;
        String type;
        String phone;
        String email;
        System.out.println("  User ID: " + userData.getID());
        String fullName = userData.getFullName();
        if (!StringUtils.isEmpty((CharSequence)fullName)) {
            System.out.println("  Full name: " + fullName);
        }
        if (!StringUtils.isEmpty((CharSequence)(email = userData.getEmail()))) {
            System.out.println("  Email: " + email);
        }
        if (!StringUtils.isEmpty((CharSequence)(phone = userData.getPhone()))) {
            System.out.println("  Phone: " + phone);
        }
        if (!StringUtils.isEmpty((CharSequence)(type = userData.getType()))) {
            System.out.println("  Type: " + type);
        }
        if (!StringUtils.isEmpty((CharSequence)(state = userData.getState()))) {
            System.out.println("  State: " + state);
        }
        if ((tpsProfiles = userData.getAttribute("tpsProfiles")) != null) {
            System.out.println("  TPS Profiles:");
            for (String profile : tpsProfiles.split(",")) {
                System.out.println("    " + profile);
            }
        }
    }
}

