/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.profile;

import com.netscape.certsrv.tps.profile.ProfileClient;
import com.netscape.certsrv.tps.profile.ProfileData;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.profile.ProfileCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileAddCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ProfileAddCLI.class);
    public ProfileCLI profileCLI;

    public ProfileAddCLI(ProfileCLI profileCLI) {
        super("add", "Add profile", (CLI)profileCLI);
        this.profileCLI = profileCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " --input <file> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "input", true, "Input file containing profile properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        ProfileData profileData;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String input = cmd.getOptionValue("input");
        if (input == null) {
            throw new Exception("Missing input file");
        }
        try (BufferedReader in = new BufferedReader(new FileReader(input));
             StringWriter sw = new StringWriter();
             PrintWriter out = new PrintWriter((Writer)sw, true);){
            String line;
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            profileData = (ProfileData)JSONSerializer.fromJSON((String)sw.toString(), ProfileData.class);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ProfileClient profileClient = this.profileCLI.getProfileClient();
        profileData = profileClient.addProfile(profileData);
        MainCLI.printMessage("Added profile \"" + profileData.getID() + "\"");
        ProfileCLI.printProfileData(profileData, true);
    }
}

