/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.connector;

import com.netscape.certsrv.tps.connector.ConnectorClient;
import com.netscape.certsrv.tps.connector.ConnectorData;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.connector.ConnectorCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorAddCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ConnectorAddCLI.class);
    public ConnectorCLI connectorCLI;

    public ConnectorAddCLI(ConnectorCLI connectorCLI) {
        super("add", "Add connector", (CLI)connectorCLI);
        this.connectorCLI = connectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " --input <file> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "input", true, "Input file containing connector properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        ConnectorData connectorData;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String input = cmd.getOptionValue("input");
        if (input == null) {
            throw new Exception("Missing input file");
        }
        try (BufferedReader in = new BufferedReader(new FileReader(input));
             StringWriter sw = new StringWriter();
             PrintWriter out = new PrintWriter((Writer)sw, true);){
            String line;
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            connectorData = (ConnectorData)JSONSerializer.fromJSON((String)sw.toString(), ConnectorData.class);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ConnectorClient connectorClient = this.connectorCLI.getConnectorClient();
        connectorData = connectorClient.addConnector(connectorData);
        MainCLI.printMessage("Added connector \"" + connectorData.getID() + "\"");
        ConnectorCLI.printConnectorData(connectorData, true);
    }
}

