/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.authenticator;

import com.netscape.certsrv.tps.authenticator.AuthenticatorClient;
import com.netscape.certsrv.tps.authenticator.AuthenticatorData;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.authenticator.AuthenticatorCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatorAddCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuthenticatorAddCLI.class);
    public AuthenticatorCLI authenticatorCLI;

    public AuthenticatorAddCLI(AuthenticatorCLI authenticatorCLI) {
        super("add", "Add authenticator", (CLI)authenticatorCLI);
        this.authenticatorCLI = authenticatorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " --input <file> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "input", true, "Input file containing authenticator properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        AuthenticatorData authenticatorData;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String input = cmd.getOptionValue("input");
        if (input == null) {
            throw new Exception("Missing input file");
        }
        try (BufferedReader in = new BufferedReader(new FileReader(input));
             StringWriter sw = new StringWriter();
             PrintWriter out = new PrintWriter((Writer)sw, true);){
            String line;
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            authenticatorData = (AuthenticatorData)JSONSerializer.fromJSON((String)sw.toString(), AuthenticatorData.class);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuthenticatorClient authenticatorClient = this.authenticatorCLI.getAuthenticatorClient();
        authenticatorData = authenticatorClient.addAuthenticator(authenticatorData);
        MainCLI.printMessage("Added authenticator \"" + authenticatorData.getID() + "\"");
        AuthenticatorCLI.printAuthenticatorData(authenticatorData, true);
    }
}

