/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.certsrv.system.TPSConnectorData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tks.TPSConnectorCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSConnectorModCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TPSConnectorModCLI.class);
    public TPSConnectorCLI tpsConnectorCLI;

    public TPSConnectorModCLI(TPSConnectorCLI tpsConnectorCLI) {
        super("mod", "Modify TPS connector on TKS", (CLI)tpsConnectorCLI);
        this.tpsConnectorCLI = tpsConnectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Connector ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "host", true, "TPS host");
        option.setArgName("host");
        this.options.addOption(option);
        option = new Option(null, "port", true, "TPS port");
        option.setArgName("port");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Connector ID specified.");
        }
        String connID = cmdArgs[0];
        TPSConnectorData data = new TPSConnectorData();
        data.setID(connID);
        data.setHost(cmd.getOptionValue("host"));
        data.setPort(cmd.getOptionValue("port"));
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TPSConnectorClient tpsConnectorClient = this.tpsConnectorCLI.getTPSConnectorClient();
        data = tpsConnectorClient.modifyConnector(connID, data);
        MainCLI.printMessage("Modified TPS connector \"" + connID + "\"");
        TPSConnectorCLI.printConnectorInfo(data);
    }
}

