/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs12;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs12.PKCS12CLI;
import java.io.BufferedReader;
import java.io.FileReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS12;
import org.mozilla.jss.netscape.security.pkcs.PKCS12Util;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS12ImportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(PKCS12ImportCLI.class);
    public PKCS12CLI pkcs12CLI;

    public PKCS12ImportCLI(PKCS12CLI pkcs12CLI) {
        super("import", "Import PKCS #12 file into NSS database", (CLI)pkcs12CLI);
        this.pkcs12CLI = pkcs12CLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] [nicknames...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs12", true, "PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-file", true, "DEPRECATED: PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "password", true, "PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password", true, "DEPRECATED: PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "password-file", true, "PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password-file", true, "DEPRECATED: PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
        this.options.addOption(null, "no-trust-flags", false, "Do not include trust flags");
        this.options.addOption(null, "overwrite", false, "Overwrite existing certificates");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String[] nicknames = cmd.getArgs();
        String filename = cmd.getOptionValue("pkcs12");
        if (filename == null) {
            filename = cmd.getOptionValue("pkcs12-file");
        }
        if (filename == null) {
            throw new Exception("Missing PKCS #12 file");
        }
        String passwordString = cmd.getOptionValue("password");
        if (passwordString == null) {
            passwordString = cmd.getOptionValue("pkcs12-password");
        }
        if (passwordString == null) {
            String passwordFile = cmd.getOptionValue("password-file");
            if (passwordFile == null) {
                passwordFile = cmd.getOptionValue("pkcs12-password-file");
            }
            if (passwordFile != null) {
                try (BufferedReader in = new BufferedReader(new FileReader(passwordFile));){
                    passwordString = in.readLine();
                }
            }
        }
        if (passwordString == null) {
            throw new Exception("Missing PKCS #12 password");
        }
        boolean trustFlagsEnabled = !cmd.hasOption("no-trust-flags");
        boolean overwrite = cmd.hasOption("overwrite");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        Password password = new Password(passwordString.toCharArray());
        try {
            PKCS12Util util = new PKCS12Util();
            util.setTrustFlagsEnabled(trustFlagsEnabled);
            PKCS12 pkcs12 = util.loadFromFile(filename, password);
            if (nicknames.length == 0) {
                util.storeIntoNSS(pkcs12, password, overwrite);
            } else {
                for (String nickname : nicknames) {
                    util.storeCertIntoNSS(pkcs12, password, nickname, overwrite);
                }
            }
        }
        finally {
            password.clear();
        }
    }
}

