/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.IPAddressName;
import org.mozilla.jss.netscape.security.x509.OIDName;
import org.mozilla.jss.netscape.security.x509.RFC822Name;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class GenSubjectAltNameExt {
    public static void main(String[] args) {
        try {
            if (args.length == 0 || args.length % 2 != 0) {
                GenSubjectAltNameExt.doUsage();
                System.exit(0);
            }
            GeneralNames gns = new GeneralNames();
            for (int i = 0; i < args.length; i += 2) {
                GeneralNameInterface gni = GenSubjectAltNameExt.buildGeneralNameInterface(args[i], args[i + 1]);
                gns.addElement((Object)gni);
            }
            SubjectAlternativeNameExtension sane = new SubjectAlternativeNameExtension(gns);
            GenSubjectAltNameExt.output(sane);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static void output(SubjectAlternativeNameExtension ext) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ext.encode((OutputStream)os);
        System.out.println(Utils.base64encode((byte[])os.toByteArray(), (boolean)true));
    }

    public static void doUsage() {
        System.out.println();
        System.out.println("Usage:  GenSubjectAltNameExt <general_type0> <general_name0> ... <general_typeN> <general_nameN>");
        System.out.println("where,");
        System.out.println("<general_type> can be one of the following string:");
        System.out.println("\tDNSName");
        System.out.println("\tEDIPartyName");
        System.out.println("\tIPAddressName");
        System.out.println("\tURIName");
        System.out.println("\tRFC822Name");
        System.out.println("\tOIDName");
        System.out.println("\tX500Name");
        System.out.println("<general_name> is a string");
    }

    public static GeneralNameInterface buildGeneralNameInterface(String type, String value) throws Exception {
        if (type.equals("DNSName")) {
            return new DNSName(value);
        }
        if (type.equals("EDIPartyName")) {
            return new DNSName(value);
        }
        if (type.equals("IPAddressName")) {
            InetAddress addr = InetAddress.getByName(value);
            return new IPAddressName(addr.getAddress());
        }
        if (type.equals("URIName")) {
            return new URIName(value);
        }
        if (type.equals("OIDName")) {
            return new OIDName(new ObjectIdentifier(value));
        }
        if (type.equals("RFC822Name")) {
            return new RFC822Name(value);
        }
        if (type.equals("X500Name")) {
            return new X500Name(value);
        }
        System.out.println("Error: unknown general_type " + type);
        GenSubjectAltNameExt.doUsage();
        System.exit(0);
        return null;
    }
}

