/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.processor;

import org.dogtagpki.tps.main.TPSBuffer;

public class AppletInfo {
    private byte majorVersion;
    private byte minorVersion;
    private byte appMajorVersion;
    private byte appMinorVersion;
    private String finalAppletVersion = null;
    private TPSBuffer aid;
    private TPSBuffer cuid;
    private TPSBuffer kdd;
    private TPSBuffer msn;
    private int totalMem;
    private int freeMem;

    public AppletInfo(byte appletMajorVer, byte appletMinorVer, byte appMajorVer, byte appMinorVer) {
        this.majorVersion = appletMajorVer;
        this.minorVersion = appletMinorVer;
        this.appMajorVersion = appMajorVer;
        this.appMinorVersion = appMinorVer;
    }

    public void setFinalAppletVersion(String appletVersion) {
        this.finalAppletVersion = appletVersion;
    }

    public String getFinalAppletVersion() {
        return this.finalAppletVersion;
    }

    public void setKDD(TPSBuffer theKDD) {
        this.kdd = new TPSBuffer(theKDD);
    }

    public TPSBuffer getKDD() {
        return this.kdd;
    }

    public void setCUID(TPSBuffer theCuid) {
        this.cuid = new TPSBuffer(theCuid);
    }

    public TPSBuffer getCUID() {
        return this.cuid;
    }

    public String getKDDhexString() {
        if (this.cuid != null) {
            return this.kdd.toHexString();
        }
        return null;
    }

    public String getKDDhexStringPlain() {
        if (this.cuid != null) {
            return this.kdd.toHexStringPlain();
        }
        return null;
    }

    public void setMSN(TPSBuffer theMsn) {
        this.msn = new TPSBuffer(theMsn);
    }

    public TPSBuffer getMSN() {
        return this.msn;
    }

    public String getCUIDhexString() {
        if (this.cuid != null) {
            return this.cuid.toHexString();
        }
        return null;
    }

    public String getCUIDhexStringPlain() {
        if (this.cuid != null) {
            return this.cuid.toHexStringPlain();
        }
        return null;
    }

    public String getCUIDHexStringHyphens() {
        String HEX_DIGITS = "0123456789ABCDEF";
        if (this.cuid == null) {
            return null;
        }
        byte[] cuidBytes = this.cuid.toBytesArray();
        StringBuffer cuidStr = new StringBuffer(cuidBytes.length + cuidBytes.length / 2 - 1);
        for (int i = 0; i < cuidBytes.length; ++i) {
            byte cuidByte = cuidBytes[i];
            cuidStr.append("0123456789ABCDEF".charAt((cuidByte & 0xF0) >> 4));
            cuidStr.append("0123456789ABCDEF".charAt(cuidByte & 0xF));
            if (i % 2 != 1 || i == cuidBytes.length - 1) continue;
            cuidStr.append('-');
        }
        return cuidStr.toString();
    }

    public String getMSNString() {
        if (this.msn != null) {
            return this.msn.toHexString();
        }
        return null;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public byte getAppMinorVersion() {
        return this.appMinorVersion;
    }

    public byte getAppMajorVersion() {
        return this.appMajorVersion;
    }

    public static void main(String[] args) {
    }

    public void setTotalMem(int total_mem) {
        this.totalMem = total_mem;
    }

    public int getTotalMem() {
        return this.totalMem;
    }

    public void setFreeMem(int free_mem) {
        this.freeMem = free_mem;
    }

    public int getFreeMem() {
        return this.freeMem;
    }

    public TPSBuffer getAid() {
        return this.aid;
    }

    public void setAid(TPSBuffer aid) {
        this.aid = aid;
    }
}

