/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;

public class NSCCommentExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 4066287070285105375L;
    public static final String IDENT = "x509.info.extensions.CommentExtension";
    public static final String NAME = "NSCCommentExtension";
    public static final String INFOS = "infos";
    public static final ObjectIdentifier OID = new ObjectIdentifier("2.16.840.1.113730.1.13");
    public String mComment = null;
    private Vector<Object> mInfos;
    private transient PrettyPrintFormat pp = new PrettyPrintFormat(":");

    private void encodeThis() throws IOException {
        try (DerOutputStream os = new DerOutputStream();){
            os.putIA5String(this.mComment);
            this.extensionValue = os.toByteArray();
        }
    }

    public NSCCommentExtension(boolean critical, String comment) throws IOException {
        this.mComment = comment;
        this.extensionId = new ObjectIdentifier("2.16.840.1.113730.1.13");
        this.critical = critical;
        this.encodeThis();
    }

    public NSCCommentExtension(boolean critical) {
        this.extensionId = new ObjectIdentifier("2.16.840.1.113730.1.13");
        this.critical = critical;
        this.mInfos = new Vector(1, 1);
    }

    public NSCCommentExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = new ObjectIdentifier("2.16.840.1.113730.1.13");
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.mComment = val.getIA5String();
    }

    @Override
    public String toString() {
        if (this.mInfos == null) {
            return "";
        }
        String s = super.toString() + "Netscape Comment [\n" + this.mInfos.toString() + "]\n";
        return s;
    }

    public String toPrint(int indent) {
        String s = "Comment :\n" + this.pp.indent(indent + 4) + (this.mComment == null ? "" : this.mComment.trim()) + "\n";
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier("2.16.840.1.113730.1.13");
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public String getComment() {
        return this.mComment;
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (name.equalsIgnoreCase(INFOS)) {
            if (!(obj instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NSCCommentExtension.");
        }
        this.mInfos = (Vector)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(INFOS)) {
            return this.mInfos;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NSCCommentExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(INFOS)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:NSCCommentExtension.");
        }
        this.mInfos = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(INFOS);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

