/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.SymKeyProxy;

public final class PK11SymKey
implements SymmetricKey {
    private SymKeyProxy keyProxy;
    private String nickName;

    protected PK11SymKey(byte[] pointer) {
        assert (pointer != null);
        this.keyProxy = new SymKeyProxy(pointer);
        this.nickName = null;
    }

    protected PK11SymKey(byte[] pointer, String nickName) {
        assert (pointer != null);
        this.keyProxy = new SymKeyProxy(pointer);
        this.nickName = nickName;
    }

    @Override
    public SymmetricKey.Type getType() {
        KeyType kt = this.getKeyType();
        SymmetricKey.Type result = SymmetricKey.Type.fromKeyType(kt);
        if (result == null) {
            throw new RuntimeException("Unrecognized key type: " + kt);
        }
        return result;
    }

    @Override
    public native CryptoToken getOwningToken();

    @Override
    public native int getStrength();

    @Override
    public native int getLength();

    @Override
    public native byte[] getKeyData() throws SymmetricKey.NotExtractableException;

    public native KeyType getKeyType();

    @Override
    public String getAlgorithm() {
        return this.getKeyType().toString();
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.getKeyData();
        }
        catch (SymmetricKey.NotExtractableException nee) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public String getNickName() {
        return this.nickName;
    }

    @Override
    public void setNickName(String nickName) {
        this.nickName = nickName;
        if (nickName != null) {
            this.setNickNameNative(nickName);
        }
    }

    public native void setNickNameNative(String var1);
}

