"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.browserMeta = void 0;
var ua_parser_js_1 = require("ua-parser-js");
var browserMeta = function () {
    var parser = new ua_parser_js_1.UAParser();
    var _a = parser.getBrowser(), name = _a.name, version = _a.version;
    var _b = parser.getOS(), osName = _b.name, osVersion = _b.version;
    var mobile = navigator.userAgent.includes('Mobi');
    var unknown = 'unknown';
    return {
        browser: {
            name: name !== null && name !== void 0 ? name : unknown,
            version: version !== null && version !== void 0 ? version : unknown,
            os: "".concat(osName !== null && osName !== void 0 ? osName : unknown, " ").concat(osVersion !== null && osVersion !== void 0 ? osVersion : unknown),
            mobile: mobile,
        },
    };
};
exports.browserMeta = browserMeta;
//# sourceMappingURL=index.js.map