/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.user.UserClient;
import com.netscape.certsrv.user.UserMembershipCollection;
import com.netscape.certsrv.user.UserMembershipData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.user.UserMembershipCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMembershipFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserMembershipFindCLI.class);
    public UserMembershipCLI userMembershipCLI;

    public UserMembershipFindCLI(UserMembershipCLI userMembershipCLI) {
        super("find", "Find user memberships", (CLI)userMembershipCLI);
        this.userMembershipCLI = userMembershipCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <User ID> [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1 || cmdArgs.length > 2) {
            throw new Exception("Incorrect number of arguments specified.");
        }
        String userID = cmdArgs[0];
        String filter = cmdArgs.length < 2 ? null : cmdArgs[1];
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        UserClient userClient = this.userMembershipCLI.getUserClient();
        UserMembershipCollection response = userClient.findUserMemberships(userID, filter, start, size);
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection entries = response.getEntries();
        boolean first = true;
        for (UserMembershipData userMembershipData : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            UserMembershipCLI.printUserMembership(userMembershipData);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

