/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SymKeyGenerationProcessedEvent;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cms.servlet.key.KeyRequestDAO;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.KeyRecoveryAuthority;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymKeyGenService
implements IService {
    public static Logger logger = LoggerFactory.getLogger(SymKeyGenService.class);
    public static final String ATTR_KEY_RECORD = "keyRecord";
    private static final String STATUS_ACTIVE = "active";
    private KeyRecoveryAuthority mKRA;
    private IStorageKeyUnit mStorageUnit = null;

    public SymKeyGenService(KeyRecoveryAuthority kra) {
        this.mKRA = kra;
        this.mStorageUnit = kra.getStorageKeyUnit();
    }

    public boolean serviceRequest(Request request) throws EBaseException {
        SymmetricKey.Usage[] keyUsages;
        RequestId id = request.getRequestId();
        logger.info("SymKeyGenService: Generating symmetric key for request " + id.toHexString());
        String clientKeyId = request.getExtDataInString("clientKeyID");
        logger.info("SymKeyGenService: - client key ID: " + clientKeyId);
        String algorithm = request.getExtDataInString("keyGenAlgorithm");
        logger.info("SymKeyGenService: - algorithm: " + algorithm);
        String realm = request.getRealm();
        logger.info("SymKeyGenService: - realm: " + realm);
        String usageStr = request.getExtDataInString("keyGenUsages");
        ArrayList<String> usages = new ArrayList<String>(Arrays.asList(StringUtils.split((String)usageStr, (String)",")));
        logger.info("SymKeyGenService: - usages: " + usages);
        String keySizeStr = request.getExtDataInString("keyGenSize");
        int keySize = Integer.parseInt(keySizeStr);
        logger.info("SymKeyGenService: - key size: " + keySize);
        String owner = request.getExtDataInString("requestOwner");
        logger.info("SymKeyGenService: - owner: " + owner);
        KRAEngine engine = KRAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = owner;
        if (algorithm == null || clientKeyId == null || keySize <= 0) {
            logger.error("SymKeyGenService: Missing client key ID or algorithm or invalid key size");
            auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, "Bad data in request"));
            throw new EBaseException("Bad data in SymKeyGenService.serviceRequest");
        }
        KRAEngineConfig configStore = engine.getConfig();
        boolean allowEncDecrypt_archival = configStore.getBoolean("kra.allowEncDecrypt.archival", false);
        logger.info("SymKeyGenService: - allowEncDecrypt archival: " + allowEncDecrypt_archival);
        CryptoToken token = this.mStorageUnit.getToken();
        KeyGenAlgorithm kgAlg = KeyRequestDAO.SYMKEY_GEN_ALGORITHMS.get(algorithm);
        if (kgAlg == null) {
            logger.error("SymKeyGenService: Invalid algorithm: " + algorithm);
            throw new EBaseException("Invalid algorithm");
        }
        if (usages.size() > 0) {
            keyUsages = new SymmetricKey.Usage[usages.size()];
            int index = 0;
            Iterator iterator = usages.iterator();
            while (iterator.hasNext()) {
                String usage;
                switch (usage = (String)iterator.next()) {
                    case "decrypt": {
                        keyUsages[index] = SymmetricKey.Usage.DECRYPT;
                        break;
                    }
                    case "encrypt": {
                        keyUsages[index] = SymmetricKey.Usage.ENCRYPT;
                        break;
                    }
                    case "wrap": {
                        keyUsages[index] = SymmetricKey.Usage.WRAP;
                        break;
                    }
                    case "unwrap": {
                        keyUsages[index] = SymmetricKey.Usage.UNWRAP;
                        break;
                    }
                    case "sign": {
                        keyUsages[index] = SymmetricKey.Usage.SIGN;
                        break;
                    }
                    case "verify": {
                        keyUsages[index] = SymmetricKey.Usage.VERIFY;
                        break;
                    }
                    default: {
                        throw new EBaseException("Invalid usage");
                    }
                }
                ++index;
            }
        } else {
            keyUsages = new SymmetricKey.Usage[]{SymmetricKey.Usage.DECRYPT, SymmetricKey.Usage.ENCRYPT};
        }
        logger.info("SymKeyGenService: Generating symmetric key");
        SymmetricKey sk = null;
        try {
            sk = CryptoUtil.generateKey((CryptoToken)token, (KeyGenAlgorithm)kgAlg, (int)keySize, (SymmetricKey.Usage[])keyUsages, (boolean)true);
            logger.debug("SymKeyGenService: session key generated on slot: " + token.getName());
        }
        catch (Exception e) {
            String message = "Unable to generate symmetric key: " + e.getMessage();
            logger.error("SymKeyGenService: " + message, (Throwable)e);
            auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, message));
            throw new EBaseException(message, (Throwable)e);
        }
        if (sk == null) {
            String message = "Unable to generate security data";
            logger.error("SymKeyGenService: " + message);
            auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, message));
            throw new EBaseException(message);
        }
        logger.info("SymKeyGenService: Wrapping symmetric key");
        byte[] publicKey = null;
        byte[] privateSecurityData = null;
        WrappingParams params = null;
        try {
            params = this.mStorageUnit.getWrappingParams(allowEncDecrypt_archival);
            privateSecurityData = this.mStorageUnit.wrap(sk, params);
        }
        catch (Exception e) {
            String message = "Unable to wrap security data: " + e.getMessage();
            logger.error("SymKeyGenService: " + message);
            auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, message));
            throw new EBaseException(message, (Throwable)e);
        }
        logger.info("SymKeyGenService: Creating key record");
        KeyRecord rec = new KeyRecord(null, publicKey, privateSecurityData, owner, algorithm, owner);
        rec.set("clientId", (Object)clientKeyId);
        if (rec.getSerialNumber() != null) {
            String message = CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]);
            logger.error("SymKeyGenService: " + message);
            auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, message));
            throw new EBaseException(message);
        }
        KeyRepository storage = this.mKRA.getKeyRepository();
        BigInteger serialNo = storage.getNextSerialNumber();
        if (serialNo == null) {
            String message = CMS.getLogMessage((String)"CMSCORE_KRA_GET_NEXT_SERIAL", (Object[])new Object[0]);
            logger.error("SymKeyGenService: " + message);
            auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, message));
            throw new EBaseException(message);
        }
        rec.set("keySerialNumber", (Object)serialNo);
        rec.set("dataType", (Object)"symmetricKey");
        rec.set("status", (Object)STATUS_ACTIVE);
        rec.set("keySize", (Object)keySize);
        request.setExtData(ATTR_KEY_RECORD, serialNo);
        if (realm != null) {
            rec.set("realm", (Object)realm);
        }
        try {
            rec.setWrappingParams(params, allowEncDecrypt_archival);
        }
        catch (Exception e) {
            String message = "Unable to store wrapping parameters: " + e.getMessage();
            logger.error("SymKeyGenService: " + message, (Throwable)e);
            auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Failure", request.getRequestId(), clientKeyId, null, message));
            throw new EBaseException(message, (Throwable)e);
        }
        logger.debug("SymKeyGenService: adding security data key record " + serialNo);
        storage.addKeyRecord(rec);
        auditor.log((LogEvent)new SymKeyGenerationProcessedEvent(auditSubjectID, "Success", request.getRequestId(), clientKeyId, new KeyId(serialNo), "None"));
        logger.info("SymKeyGenService: Updating key request record");
        request.setExtData("Result", Request.RES_SUCCESS);
        engine.getRequestRepository().updateRequest(request);
        return true;
    }
}

