/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.listeners;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.listeners.EListenersException;
import com.netscape.certsrv.notification.ENotificationException;
import com.netscape.certsrv.notification.EmailResolver;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cms.notification.MailNotification;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.notification.EmailFormProcessor;
import com.netscape.cmscore.notification.EmailResolverKeys;
import com.netscape.cmscore.notification.EmailTemplate;
import com.netscape.cmscore.notification.ReqCertSANameEmailResolver;
import com.netscape.cmscore.request.Request;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateIssuedListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(CertificateIssuedListener.class);
    protected static final String PROP_CERT_ISSUED_SUBSTORE = "certIssued";
    protected static final String PROP_ENABLED = "enabled";
    protected static final String PROP_NOTIFY_SUBSTORE = "notification";
    protected static final String PROP_SENDER_EMAIL = "senderEmail";
    protected static final String PROP_EMAIL_SUBJECT = "emailSubject";
    public static final String PROP_EMAIL_TEMPLATE = "emailTemplate";
    protected static final String REJECT_FILE_NAME = "certRequestRejected";
    private boolean mEnabled = false;
    private String mSenderEmail = null;
    private String mSubject = null;
    private String mSubject_Success = null;
    private String mFormPath = null;
    private String mRejectPath = null;
    private Hashtable<String, Object> mContentParams = new Hashtable();
    private CAConfig mConfig;
    private DateFormat mDateFormat = null;
    private CertificateAuthority mSubsystem;
    private String mHttpHost = null;
    private String mHttpPort = null;
    private RequestId mReqId = null;

    public void init(Subsystem sub, ConfigStore config) throws EListenersException, EPropertyNotFound, EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        this.mSubsystem = (CertificateAuthority)sub;
        this.mConfig = this.mSubsystem.getConfigStore();
        ConfigStore nc = this.mConfig.getSubStore(PROP_NOTIFY_SUBSTORE, ConfigStore.class);
        ConfigStore rc = nc.getSubStore(PROP_CERT_ISSUED_SUBSTORE, ConfigStore.class);
        this.mEnabled = rc.getBoolean(PROP_ENABLED, false);
        this.mSenderEmail = rc.getString(PROP_SENDER_EMAIL);
        if (this.mSenderEmail == null) {
            throw new EListenersException(CMS.getLogMessage((String)"NO_NOTIFY_SENDER_EMAIL_CONFIG_FOUND", (Object[])new Object[0]));
        }
        this.mFormPath = rc.getString(PROP_EMAIL_TEMPLATE);
        String mDir = null;
        int ridx = this.mFormPath.lastIndexOf(File.separator);
        if (ridx == -1) {
            logger.debug("CertificateIssuedListener: file separator: " + File.separator + " not found. Use default /");
            ridx = this.mFormPath.lastIndexOf("/");
            mDir = this.mFormPath.substring(0, ridx + 1);
        } else {
            mDir = this.mFormPath.substring(0, ridx + File.separator.length());
        }
        logger.debug("CertificateIssuedListener: template file directory: " + mDir);
        this.mRejectPath = mDir + REJECT_FILE_NAME;
        if (this.mFormPath.endsWith(".html")) {
            this.mRejectPath = this.mRejectPath + ".html";
        } else if (this.mFormPath.endsWith(".HTML")) {
            this.mRejectPath = this.mRejectPath + ".HTML";
        } else if (this.mFormPath.endsWith(".htm")) {
            this.mRejectPath = this.mRejectPath + ".htm";
        } else if (this.mFormPath.endsWith(".HTM")) {
            this.mRejectPath = this.mRejectPath + ".HTM";
        }
        logger.debug("CertificateIssuedListener: Reject file path: " + this.mRejectPath);
        this.mDateFormat = DateFormat.getDateTimeInstance();
        this.mSubject_Success = rc.getString(PROP_EMAIL_SUBJECT, "Your Certificate Request");
        this.mSubject = new String(this.mSubject_Success);
        this.mHttpHost = cs.getHostname();
        this.mHttpPort = engine.getEESSLPort();
        engine.registerRequestListener(this);
    }

    public void accept(Request r) {
        String requestType;
        logger.debug("CertificateIssuedListener: accept " + r.getRequestId().toString());
        if (!this.mEnabled) {
            return;
        }
        this.mSubject = this.mSubject_Success;
        this.mReqId = r.getRequestId();
        String rs = r.getRequestStatus().toString();
        if (rs.equals("rejected")) {
            logger.debug("CertificateIssuedListener: Request status: " + rs);
            this.rejected(r);
            return;
        }
        logger.debug("CertificateIssuedListener: accept check status ");
        String profileId = r.getExtDataInString("profileId");
        if (profileId == null) {
            if (r.getExtDataInInteger("Result") == null) {
                return;
            }
            if (r.getExtDataInInteger("Result").equals(Request.RES_ERROR)) {
                logger.debug("CertificateIssuedListener: Request errored. No need to email notify for enrollment request id " + this.mReqId);
                return;
            }
        }
        if ((requestType = r.getRequestType()).equals("enrollment") || requestType.equals("renewal")) {
            logger.debug("accept() enrollment/renewal request...");
            X509CertImpl[] issuedCert = null;
            issuedCert = profileId == null ? r.getExtDataInCertArray("issuedCerts") : new X509CertImpl[]{r.getExtDataInCert("req_issued_cert")};
            if (issuedCert != null) {
                logger.debug("CertificateIssuedListener: Sending email notification..");
                String mEmail = null;
                EmailResolverKeys keys = new EmailResolverKeys();
                try {
                    keys.set("request", (Object)r);
                    keys.set("cert", (Object)issuedCert[0]);
                }
                catch (EBaseException e) {
                    logger.warn("CertificateIssuedListener: setting email resolver: " + e.getMessage(), (Throwable)e);
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_SET_RESOLVER", (Object[])new Object[]{e.toString()}));
                }
                ReqCertSANameEmailResolver er = new ReqCertSANameEmailResolver();
                try {
                    mEmail = ((EmailResolver)er).getEmail(keys);
                }
                catch (ENotificationException e) {
                    logger.warn("CertificateIssuedListener: getting email: " + e.getMessage(), (Throwable)e);
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_EXCEPTION", (Object[])new Object[]{e.toString()}));
                }
                catch (EBaseException e) {
                    logger.warn("CertificateIssuedListener: getting email: " + e.getMessage(), (Throwable)e);
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_EXCEPTION", (Object[])new Object[]{e.toString()}));
                }
                catch (Exception e) {
                    logger.warn("CertificateIssuedListener: getting email: " + e.getMessage(), (Throwable)e);
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_EXCEPTION", (Object[])new Object[]{e.toString()}));
                }
                if (mEmail != null && !mEmail.equals("")) {
                    logger.debug("CertificateIssuedListener: found email: " + mEmail);
                    this.mailIt(mEmail, issuedCert);
                } else {
                    logger.warn("CertificateIssuedListener: failed finding email");
                    logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_NOTIFY_ERROR", (Object[])new Object[]{issuedCert[0].getSerialNumber().toString(), this.mReqId.toString()}));
                    logger.debug("CertificateIssuedListener: notifying sender...");
                    this.mSubject = "Certificate Issued notification undeliverable";
                    this.mailIt(this.mSenderEmail, issuedCert);
                }
            }
        }
    }

    private void mailIt(String mEmail, X509CertImpl[] issuedCert) {
        CAEngine engine = CAEngine.getInstance();
        MailNotification mn = engine.getMailNotification();
        mn.setFrom(this.mSenderEmail);
        mn.setTo(mEmail);
        mn.setSubject(this.mSubject);
        EmailTemplate template = new EmailTemplate(this.mFormPath);
        if (!template.init()) {
            return;
        }
        this.buildContentParams(issuedCert, mEmail);
        EmailFormProcessor et = new EmailFormProcessor();
        String c = et.getEmailContent(template.toString(), this.mContentParams);
        if (template.isHTML()) {
            mn.setContentType("text/html");
        }
        mn.setContent(c);
        try {
            mn.sendNotification();
        }
        catch (ENotificationException e) {
            logger.warn("CertificateIssuedListener: mailIt: " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}));
        }
        catch (IOException e) {
            logger.warn("CertificateIssuedListener: mailIt: " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}));
        }
    }

    private void rejected(Request r) {
        String mEmail = null;
        EmailResolverKeys keys = new EmailResolverKeys();
        try {
            keys.set("request", (Object)r);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_SET_RESOLVER", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        ReqCertSANameEmailResolver er = new ReqCertSANameEmailResolver();
        try {
            mEmail = ((EmailResolver)er).getEmail(keys);
        }
        catch (ENotificationException e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (mEmail != null && !mEmail.equals("")) {
            CAEngine engine = CAEngine.getInstance();
            MailNotification mn = engine.getMailNotification();
            mn.setFrom(this.mSenderEmail);
            mn.setTo(mEmail);
            mn.setSubject(this.mSubject);
            EmailTemplate template = new EmailTemplate(this.mRejectPath);
            if (!template.init()) {
                return;
            }
            if (template.isHTML()) {
                mn.setContentType("text/html");
            }
            this.mContentParams.put("InstanceID", this.mConfig.getName());
            this.mReqId = r.getRequestId();
            this.mContentParams.put("RequestId", this.mReqId.toString());
            EmailFormProcessor et = new EmailFormProcessor();
            String c = et.getEmailContent(template.toString(), this.mContentParams);
            mn.setContent(c);
            try {
                mn.sendNotification();
            }
            catch (ENotificationException e) {
                logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (IOException e) {
                logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
        } else {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_REJECTION_NOTIFICATION", (Object[])new Object[]{this.mReqId.toString()}));
        }
    }

    private void buildContentParams(X509CertImpl[] issuedCert, String mEmail) {
        this.mContentParams.put("InstanceID", this.mConfig.getName());
        this.mContentParams.put("SerialNumber", issuedCert[0].getSerialNumber().toString());
        this.mContentParams.put("HexSerialNumber", Long.toHexString(issuedCert[0].getSerialNumber().longValue()));
        this.mContentParams.put("RequestId", this.mReqId.toString());
        this.mContentParams.put("HttpHost", this.mHttpHost);
        this.mContentParams.put("HttpPort", this.mHttpPort);
        this.mContentParams.put("IssuerDN", issuedCert[0].getIssuerName().toString());
        this.mContentParams.put("SubjectDN", issuedCert[0].getSubjectName().toString());
        Date date = issuedCert[0].getNotAfter();
        this.mContentParams.put("NotAfter", this.mDateFormat.format(date));
        date = issuedCert[0].getNotBefore();
        this.mContentParams.put("NotBefore", this.mDateFormat.format(date));
        this.mContentParams.put("SenderEmail", this.mSenderEmail);
        this.mContentParams.put("RecipientEmail", mEmail);
    }

    public void set(String name, String val) {
        if (name.equalsIgnoreCase(PROP_ENABLED)) {
            this.mEnabled = val.equalsIgnoreCase("true");
        } else if (name.equalsIgnoreCase(PROP_SENDER_EMAIL)) {
            this.mSenderEmail = val;
        } else if (name.equalsIgnoreCase(PROP_EMAIL_SUBJECT)) {
            this.mSubject = this.mSubject_Success = val;
        } else if (name.equalsIgnoreCase(PROP_EMAIL_TEMPLATE)) {
            this.mFormPath = val;
        } else {
            logger.warn(CMS.getLogMessage((String)"LISTENERS_CERT_ISSUED_SET", (Object[])new Object[0]));
        }
    }
}

