/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.certsrv.user.UserCollection;
import com.netscape.certsrv.user.UserData;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystemConfig;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.ldap.LDAPUtil;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.util.Enumeration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemUserFindCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemUserFindCLI.class);

    public SubsystemUserFindCLI(CLI parent) {
        super("find", "Find " + parent.getParent().getName().toUpperCase() + " users", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "see-also", true, "Find users linked to a certificate.");
        option.setArgName("subject DN");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: text (default), json.");
        option.setArgName("format");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        this.initializeTomcatJSS();
        String subsystem = this.parent.getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        UGSubsystemConfig ugConfig = cs.getUGSubsystemConfig();
        LDAPConfig ldapConfig = ugConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        UGSubsystem ugSubsystem = new UGSubsystem();
        String filter = null;
        String seeAlso = cmd.getOptionValue("see-also");
        if (seeAlso != null) {
            filter = "(seeAlso=" + LDAPUtil.escapeFilter((Object)seeAlso) + ")";
        }
        String outputFormat = cmd.getOptionValue("output-format", "text");
        UserCollection response = new UserCollection();
        try {
            ugSubsystem.init(ldapConfig, socketConfig, passwordStore);
            Enumeration<User> users = ugSubsystem.findUsers(filter);
            int total = 0;
            while (users.hasMoreElements()) {
                String state;
                String type;
                String phone;
                String email;
                String fullName;
                User user = users.nextElement();
                UserData userData = new UserData();
                String userID = user.getUserID();
                if (!StringUtils.isEmpty((CharSequence)userID)) {
                    userData.setID(userID);
                    userData.setUserID(userID);
                }
                if (!StringUtils.isEmpty((CharSequence)(fullName = user.getFullName()))) {
                    userData.setFullName(fullName);
                }
                if (!StringUtils.isEmpty((CharSequence)(email = user.getEmail()))) {
                    userData.setEmail(email);
                }
                if (!StringUtils.isEmpty((CharSequence)(phone = user.getPhone()))) {
                    userData.setPhone(phone);
                }
                if (!StringUtils.isEmpty((CharSequence)(type = user.getUserType()))) {
                    userData.setType(type);
                }
                if (!StringUtils.isEmpty((CharSequence)(state = user.getState()))) {
                    userData.setState(state);
                }
                response.addEntry((Object)userData);
                ++total;
            }
            response.setTotal(total);
        }
        finally {
            ugSubsystem.shutdown();
        }
        if (outputFormat.equalsIgnoreCase("json")) {
            System.out.println(response.toJSON());
        } else if (outputFormat.equalsIgnoreCase("text")) {
            boolean first = true;
            for (User user : response.getEntries()) {
                String state;
                String type;
                String phone;
                String email;
                if (first) {
                    first = false;
                } else {
                    System.out.println();
                }
                System.out.println("  User ID: " + user.getUserID());
                String fullName = user.getFullName();
                if (!StringUtils.isEmpty((CharSequence)fullName)) {
                    System.out.println("  Full name: " + fullName);
                }
                if (!StringUtils.isEmpty((CharSequence)(email = user.getEmail()))) {
                    System.out.println("  Email: " + email);
                }
                if (!StringUtils.isEmpty((CharSequence)(phone = user.getPhone()))) {
                    System.out.println("  Phone: " + phone);
                }
                if (!StringUtils.isEmpty((CharSequence)(type = user.getType()))) {
                    System.out.println("  Type: " + type);
                }
                if (StringUtils.isEmpty((CharSequence)(state = user.getState()))) continue;
                System.out.println("  State: " + state);
            }
        } else {
            throw new Exception("Unsupported output format: " + outputFormat);
        }
    }
}

