/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.usrgrp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.LDAPExceptionConverter;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.ldap.LDAPUtil;
import com.netscape.cmsutil.password.PasswordStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGSubsystem {
    public static Logger logger = LoggerFactory.getLogger(UGSubsystem.class);
    public static final String SUPER_CERT_ADMINS = "Administrators";
    protected static final String OBJECTCLASS_ATTR = "objectclass";
    protected static final String MEMBER_ATTR = "uniquemember";
    protected static final String GROUP_ATTR_VALUE = "groupofuniquenames";
    protected static final String LDAP_ATTR_USER_CERT_STRING = "description";
    protected static final String LDAP_ATTR_CERTDN = "seeAlso";
    protected static final String LDAP_ATTR_USER_CERT = "userCertificate";
    protected static final String LDAP_ATTR_PROFILE_ID = "profileID";
    protected CMSEngine engine;
    protected transient LdapBoundConnFactory mLdapConnFactory = null;
    protected String mBaseDN = null;

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void init(LDAPConfig ldapConfig, PKISocketConfig socketConfig, PasswordStore passwordStore) throws Exception {
        this.mBaseDN = ldapConfig.getBaseDN();
        this.mLdapConnFactory = new LdapBoundConnFactory("UGSubsystem");
        this.mLdapConnFactory.setCMSEngine(this.engine);
        this.mLdapConnFactory.init(socketConfig, ldapConfig, passwordStore);
    }

    public void shutdown() {
        try {
            if (this.mLdapConnFactory != null) {
                this.mLdapConnFactory.reset();
            }
        }
        catch (ELdapException e) {
            logger.warn("Unable to shutdown connection: " + e.getMessage(), (Throwable)e);
        }
    }

    public User createUser(String id) {
        User user = new User();
        user.setUserID(id);
        return user;
    }

    public Group createGroup(String id) {
        return new Group(id);
    }

    public User getUser(String userID) throws EUsrGrpException {
        if (userID == null) {
            return null;
        }
        String userDN = userID.indexOf(61) < 0 ? this.getUserDN(userID) : userID;
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            logger.info("UGSubsystem: Retrieving user " + userDN);
            LDAPSearchResults res = ldapconn.search(userDN, 0, "(objectclass=*)", null, false);
            Enumeration<User> e = this.buildUsers(res);
            User user = e.nextElement();
            return user;
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to retrieve user: " + userID + ": " + e.getMessage(), (Exception)((Object)e));
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                logger.info("UGSubsystem: User not found: " + userID);
                User user = null;
                return user;
            }
            throw new EUsrGrpException("Unable to retrieve user: " + userID + ": " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUser(X509Certificate cert) throws EUsrGrpException {
        if (cert == null) {
            return null;
        }
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            String filter = "description=" + LDAPUtil.escapeFilter((Object)this.getCertificateString(cert));
            LDAPSearchResults res = ldapconn.search(this.getUserBaseDN(), 2, filter, null, false);
            Enumeration<User> e = this.buildUsers(res);
            User user = e.nextElement();
            return user;
        }
        catch (LDAPException e) {
            logger.warn("Unable to find user: " + e.getMessage(), (Throwable)e);
        }
        catch (ELdapException e) {
            logger.warn("Unable to connect to internal database: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUsersByCert(String filter) throws EUsrGrpException {
        if (filter == null) {
            return null;
        }
        int hasSlash = ((String)filter).indexOf(92);
        if (hasSlash != -1) {
            String up = filter;
            StringBuffer stripped = new StringBuffer();
            hasSlash = up.indexOf(92);
            while (hasSlash != -1) {
                stripped.append(up.substring(0, hasSlash) + "\\5c");
                up = up.substring(hasSlash + 1);
                hasSlash = up.indexOf(92);
            }
            filter = stripped.toString() + up;
        }
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            LDAPSearchResults res = ldapconn.search(this.getUserBaseDN(), 2, "(" + (String)filter + ")", null, false);
            Enumeration<User> e = this.buildUsers(res);
            User user = e.nextElement();
            return user;
        }
        catch (LDAPException e) {
            logger.warn("Unable to find user by certificate: " + e.getMessage(), (Throwable)e);
        }
        catch (ELdapException e) {
            logger.warn("Unable to find user by certificate: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        return null;
    }

    public Enumeration<User> findUsersByKeyword(String keyword) throws EUsrGrpException {
        String filter = null;
        if (keyword != null) {
            keyword = LDAPUtil.escapeFilter((Object)keyword);
            filter = "(|(uid=*" + keyword + "*)(cn=*" + keyword + "*)(mail=*" + keyword + "*))";
        }
        return this.findUsers(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<User> findUsers(String filter) throws EUsrGrpException {
        String baseDN = this.getUserBaseDN();
        if (StringUtils.isEmpty((CharSequence)filter)) {
            filter = "(uid=*)";
        }
        logger.info("LDAP: search " + baseDN + " with " + filter);
        LDAPConnection ldapconn = null;
        try {
            Enumeration<User> e;
            ldapconn = this.getConn();
            LDAPSearchResults res = ldapconn.search(baseDN, 1, filter, null, false);
            Enumeration<User> enumeration = e = this.buildUsers(res);
            return enumeration;
        }
        catch (LDAPException e) {
            logger.warn("Unable to find user: " + e.getMessage(), (Throwable)e);
        }
        catch (ELdapException e) {
            logger.warn("Unable to find user: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public Enumeration<User> listUsers(String filter) throws EUsrGrpException {
        if (filter == null) {
            return null;
        }
        LDAPConnection ldapconn = null;
        try {
            Enumeration<User> e;
            String[] attrs = new String[]{"uid", "cn"};
            ldapconn = this.getConn();
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            cons.setMaxResults(0);
            LDAPSearchResults res = ldapconn.search(this.getUserBaseDN(), 2, "(uid=" + filter + ")", attrs, false, cons);
            Enumeration<User> enumeration = e = this.lbuildUsers(res);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
            return enumeration;
        }
        catch (LDAPException e) {
            logger.warn("Unable to list users: " + e.getMessage(), (Throwable)e);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        catch (Exception e2) {
            throw new EUsrGrpException("Unable to list users: " + e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    if (ldapconn != null) {
                        this.returnConn(ldapconn);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    protected Enumeration<User> lbuildUsers(LDAPSearchResults res) throws EUsrGrpException {
        Vector<User> v = new Vector<User>();
        while (res.hasMoreElements()) {
            LDAPEntry entry = (LDAPEntry)res.nextElement();
            User user = this.lbuildUser(entry);
            v.addElement(user);
        }
        return v.elements();
    }

    protected Enumeration<User> buildUsers(LDAPSearchResults res) throws EUsrGrpException {
        Vector<User> v = new Vector<User>();
        if (res != null) {
            while (res.hasMoreElements()) {
                LDAPEntry entry = (LDAPEntry)res.nextElement();
                User user = this.buildUser(entry);
                v.addElement(user);
            }
        }
        if (v.size() == 0) {
            throw new EUsrGrpException("User not found");
        }
        return v.elements();
    }

    protected User lbuildUser(LDAPEntry entry) throws EUsrGrpException {
        LDAPAttribute certAttr;
        String cn;
        LDAPAttribute uid = entry.getAttribute("uid");
        if (uid == null) {
            throw new EUsrGrpException("No Attribute UID in LDAP Entry " + entry.getDN());
        }
        User id = this.createUser((String)uid.getStringValues().nextElement());
        LDAPAttribute cnAttr = entry.getAttribute("cn");
        if (cnAttr != null && (cn = (String)cnAttr.getStringValues().nextElement()) != null) {
            id.setFullName(cn);
        }
        if ((certAttr = entry.getAttribute(LDAP_ATTR_USER_CERT)) != null) {
            Vector<X509CertImpl> certVector = new Vector<X509CertImpl>();
            Enumeration e = certAttr.getByteValues();
            try {
                while (e != null && e.hasMoreElements()) {
                    X509CertImpl cert = new X509CertImpl((byte[])e.nextElement());
                    certVector.addElement(cert);
                }
            }
            catch (Exception ex) {
                throw new EUsrGrpException("Unable to get user certificate: " + ex.getMessage(), ex);
            }
            if (certVector != null && certVector.size() != 0) {
                X509Certificate[] certArray = new X509Certificate[certVector.size()];
                Enumeration en = certVector.elements();
                int i = 0;
                while (en.hasMoreElements()) {
                    certArray[i++] = (X509Certificate)en.nextElement();
                }
                id.setX509Certificates(certArray);
            }
        }
        return id;
    }

    protected User buildUser(LDAPEntry entry) throws EUsrGrpException {
        LDAPAttribute profileAttr;
        LDAPAttribute userTypeAttr;
        String phone;
        Enumeration en;
        LDAPAttribute phoneAttr;
        String pwd;
        LDAPAttribute pwdAttr;
        String mail;
        Enumeration en2;
        String cn;
        String dn = entry.getDN();
        logger.info("UGSubsystem: User " + dn + ":");
        LDAPAttribute uidAttr = entry.getAttribute("uid");
        if (uidAttr == null) {
            throw new EUsrGrpException("Missing UID attribute: " + entry.getDN());
        }
        String uid = (String)uidAttr.getStringValues().nextElement();
        logger.info("UGSubsystem: - uid: " + uid);
        User user = this.createUser(uid);
        LDAPAttribute cnAttr = entry.getAttribute("cn");
        if (cnAttr != null && (cn = (String)cnAttr.getStringValues().nextElement()) != null) {
            logger.info("UGSubsystem: - cn: " + cn);
            user.setFullName(cn);
        }
        user.setUserDN(dn);
        LDAPAttribute mailAttr = entry.getAttribute("mail");
        if (mailAttr != null && (en2 = mailAttr.getStringValues()) != null && en2.hasMoreElements() && (mail = (String)en2.nextElement()) != null) {
            logger.info("UGSubsystem: - mail: " + mail);
            user.setEmail(mail);
        }
        if (user.getEmail() == null) {
            user.setEmail("");
        }
        if ((pwdAttr = entry.getAttribute("userpassword")) != null && (pwd = (String)pwdAttr.getStringValues().nextElement()) != null) {
            logger.info("UGSubsystem: - userPassword: ********");
            user.setPassword(pwd);
        }
        if ((phoneAttr = entry.getAttribute("telephonenumber")) != null && (en = phoneAttr.getStringValues()) != null && en.hasMoreElements() && (phone = (String)en.nextElement()) != null) {
            logger.info("UGSubsystem: - telephoneNumber: " + phone);
            user.setPhone(phone);
        }
        if (user.getPhone() == null) {
            user.setPhone("");
        }
        if ((userTypeAttr = entry.getAttribute("usertype")) == null) {
            user.setUserType("");
        } else {
            Enumeration en3 = userTypeAttr.getStringValues();
            if (en3 != null && en3.hasMoreElements()) {
                String userType = (String)en3.nextElement();
                if (userType != null && !userType.equals("undefined")) {
                    logger.info("UGSubsystem: - usertype: " + userType);
                    user.setUserType(userType);
                } else {
                    user.setUserType("");
                }
            }
        }
        LDAPAttribute userStateAttr = entry.getAttribute("userstate");
        if (userStateAttr == null) {
            user.setState("");
        } else {
            Enumeration en4 = userStateAttr.getStringValues();
            if (en4 != null && en4.hasMoreElements()) {
                String userState = (String)en4.nextElement();
                if (userState != null) {
                    logger.info("UGSubsystem: - userstate: " + userState);
                    user.setState(userState);
                } else {
                    user.setState("");
                }
            }
        }
        LDAPAttribute certAttr = entry.getAttribute(LDAP_ATTR_USER_CERT);
        if (certAttr != null) {
            Vector<X509CertImpl> certVector = new Vector<X509CertImpl>();
            Enumeration e = certAttr.getByteValues();
            try {
                while (e != null && e.hasMoreElements()) {
                    X509CertImpl cert = new X509CertImpl((byte[])e.nextElement());
                    String certID = this.getCertificateString((X509Certificate)cert);
                    logger.info("UGSubsystem: - user cert: " + certID);
                    certVector.addElement(cert);
                }
            }
            catch (Exception ex) {
                throw new EUsrGrpException("Unable to get user certificate: " + ex.getMessage(), ex);
            }
            if (certVector != null && certVector.size() != 0) {
                X509Certificate[] certArray = new X509Certificate[certVector.size()];
                Enumeration en5 = certVector.elements();
                int i = 0;
                while (en5.hasMoreElements()) {
                    certArray[i++] = (X509Certificate)en5.nextElement();
                }
                user.setX509Certificates(certArray);
            }
        }
        if ((profileAttr = entry.getAttribute(LDAP_ATTR_PROFILE_ID)) != null) {
            Enumeration profiles = profileAttr.getStringValues();
            ArrayList<String> tpsProfiles = new ArrayList<String>();
            while (profiles.hasMoreElements()) {
                String profileID = (String)profiles.nextElement();
                logger.info("UGSubsystem: - profileID: " + profileID);
                tpsProfiles.add(profileID);
            }
            user.setTpsProfiles(tpsProfiles);
        }
        return user;
    }

    public void addUser(User user) throws EUsrGrpException {
        List<LDAPAttribute> attributes;
        List<String> profiles;
        String state;
        String userType;
        String password;
        String phone;
        if (user == null) {
            throw new EUsrGrpException("Missing user");
        }
        String userID = user.getUserID();
        if (userID == null) {
            throw new EUsrGrpException("Missing user ID");
        }
        String dn = "uid=" + LDAPUtil.escapeRDNValue((Object)userID) + "," + this.getUserBaseDN();
        logger.info("UGSubsystem: Adding user " + dn);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        ArrayList<String> ocList = new ArrayList<String>();
        ocList.add("top");
        ocList.add("person");
        ocList.add("organizationalPerson");
        ocList.add("inetOrgPerson");
        ocList.add("cmsuser");
        if (user.getTpsProfiles() != null) {
            ocList.add("tpsProfileID");
        }
        logger.debug("UGSubsystem: - objectclass: " + ocList);
        String[] oc = ocList.toArray(new String[ocList.size()]);
        attrs.add(new LDAPAttribute(OBJECTCLASS_ATTR, oc));
        logger.debug("UGSubsystem: - uid: " + userID);
        attrs.add(new LDAPAttribute("uid", userID));
        String fullName = user.getFullName();
        logger.debug("UGSubsystem: - sn: " + fullName);
        attrs.add(new LDAPAttribute("sn", fullName));
        logger.debug("UGSubsystem: - cn: " + fullName);
        attrs.add(new LDAPAttribute("cn", fullName));
        String email = user.getEmail();
        if (!StringUtils.isEmpty((CharSequence)email)) {
            logger.debug("UGSubsystem: - mail: " + email);
            attrs.add(new LDAPAttribute("mail", email));
        }
        if (!StringUtils.isEmpty((CharSequence)(phone = user.getPhone()))) {
            logger.debug("UGSubsystem: - telephoneNumber: " + phone);
            attrs.add(new LDAPAttribute("telephonenumber", phone));
        }
        if (!StringUtils.isEmpty((CharSequence)(password = user.getPassword()))) {
            logger.debug("UGSubsystem: - userPassword: ********");
            attrs.add(new LDAPAttribute("userpassword", password));
        }
        if ((userType = user.getUserType()) != null) {
            if (userType.equals("")) {
                userType = "undefined";
            }
            logger.debug("UGSubsystem: - usertype: " + userType);
            attrs.add(new LDAPAttribute("usertype", userType));
        }
        if (!StringUtils.isEmpty((CharSequence)(state = user.getState()))) {
            logger.debug("UGSubsystem: - userstate: " + state);
            attrs.add(new LDAPAttribute("userstate", state));
        }
        if ((profiles = user.getTpsProfiles()) != null && profiles.size() > 0) {
            LDAPAttribute attr = new LDAPAttribute(LDAP_ATTR_PROFILE_ID);
            for (String profile : profiles) {
                logger.debug("UGSubsystem: - profileID: " + profile);
                attr.addValue(profile);
            }
            attrs.add(attr);
        }
        if ((attributes = user.getAttributes()) != null) {
            for (LDAPAttribute attr : attributes) {
                logger.debug("UGSubsystem: - " + attr.getName() + ": " + attr.getStringValueArray());
                attrs.add(attr);
            }
        }
        LDAPEntry entry = new LDAPEntry(dn, attrs);
        SessionContext sessionContext = SessionContext.getContext();
        String adminId = (String)sessionContext.get((Object)"userid");
        logger.info("Admin UID: {} added User UID: {}", (Object)adminId, (Object)userID);
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            ldapconn.add(entry);
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to add user: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addUserCert(String userID, X509Certificate cert) throws EUsrGrpException {
        if (userID == null) {
            throw new EUsrGrpException("Missing user ID");
        }
        String dn = "uid=" + LDAPUtil.escapeRDNValue((Object)userID) + "," + this.getUserBaseDN();
        LDAPConnection ldapconn = null;
        try {
            LDAPModificationSet mods = new LDAPModificationSet();
            LDAPAttribute descAttr = new LDAPAttribute(LDAP_ATTR_USER_CERT_STRING);
            descAttr.addValue(this.getCertificateString(cert));
            mods.add(0, descAttr);
            LDAPAttribute userCertAttr = new LDAPAttribute(LDAP_ATTR_USER_CERT);
            userCertAttr.addValue(cert.getEncoded());
            mods.add(0, userCertAttr);
            ldapconn = this.getConn();
            ldapconn.modify(dn, mods);
            SessionContext sessionContext = SessionContext.getContext();
            String adminId = (String)sessionContext.get((Object)"userid");
            logger.info("Admin UID: {} added cert for User UID: {}. cert DN: {} serial number: 0x{}", new Object[]{adminId, userID, cert.getSubjectDN(), cert.getSerialNumber().toString(16)});
            if (ldapconn == null) return;
            this.returnConn(ldapconn);
            return;
        }
        catch (LDAPException e) {
            try {
                throw LDAPExceptionConverter.toPKIException((LDAPException)e);
                catch (Exception e2) {
                    throw new EUsrGrpException("Unable to add user certificate: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                if (ldapconn == null) throw throwable;
                this.returnConn(ldapconn);
                throw throwable;
            }
        }
    }

    public void addSeeAlso(String userID, String value) throws EUsrGrpException {
        if (userID == null) {
            throw new EUsrGrpException("Missing user ID");
        }
        String dn = "uid=" + LDAPUtil.escapeRDNValue((Object)userID) + "," + this.getUserBaseDN();
        LDAPModificationSet mods = new LDAPModificationSet();
        LDAPAttribute attr = new LDAPAttribute(LDAP_ATTR_CERTDN);
        attr.addValue(value);
        mods.add(0, attr);
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            ldapconn.modify(dn, mods);
            SessionContext sessionContext = SessionContext.getContext();
            String adminId = (String)sessionContext.get((Object)"userid");
            logger.info("Admin UID: {} added cert subject DN for User UID: {}. cert DN: {}", new Object[]{adminId, userID, value});
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to add seeAlso: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    public void removeSeeAlso(String userID, String value) throws EUsrGrpException {
        if (userID == null) {
            throw new EUsrGrpException("Missing user ID");
        }
        String dn = "uid=" + LDAPUtil.escapeRDNValue((Object)userID) + "," + this.getUserBaseDN();
        LDAPModificationSet mods = new LDAPModificationSet();
        LDAPAttribute attr = new LDAPAttribute(LDAP_ATTR_CERTDN);
        attr.addValue(value);
        mods.add(1, attr);
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            ldapconn.modify(dn, mods);
            SessionContext sessionContext = SessionContext.getContext();
            String adminId = (String)sessionContext.get((Object)"userid");
            logger.info("Admin UID: {} removed cert subject DN for User UID: {}. cert DN: {}", new Object[]{adminId, userID, value});
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to remove seeAlso: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    public void removeUserCert(String userID, String certID) throws EUsrGrpException {
        User ldapUser = this.getUser(userID);
        if (ldapUser == null) {
            throw new ResourceNotFoundException("User not found: " + userID);
        }
        X509Certificate[] certs = ldapUser.getX509Certificates();
        if (certs == null) {
            throw new ResourceNotFoundException("User certificate not found");
        }
        if (certID == null) {
            throw new ResourceNotFoundException("User certificate not found");
        }
        int certCount = 0;
        for (int i = 0; i < certs.length; ++i) {
            String certStr = certID.startsWith("-1;") ? this.getCertificateStringWithoutVersion(certs[i]) : this.getCertificateString(certs[i]);
            if (!certID.equalsIgnoreCase(certStr)) continue;
            LDAPConnection ldapconn = null;
            try {
                LDAPModificationSet attrs;
                ldapconn = this.getConn();
                String dn = "uid=" + LDAPUtil.escapeRDNValue((Object)userID) + "," + this.getUserBaseDN();
                try {
                    attrs = new LDAPModificationSet();
                    LDAPAttribute certDNAttrS = new LDAPAttribute(LDAP_ATTR_CERTDN);
                    certDNAttrS.addValue(certs[i].getSubjectDN().toString());
                    attrs.add(1, certDNAttrS);
                    ldapconn.modify(dn, attrs);
                }
                catch (LDAPException e) {
                    if (e.getLDAPResultCode() == 16) {
                        logger.warn("removeUserCert: No attribute seeAlso in entry " + dn);
                    }
                    throw LDAPExceptionConverter.toPKIException((LDAPException)e);
                }
                attrs = new LDAPModificationSet();
                LDAPAttribute certAttr = new LDAPAttribute(LDAP_ATTR_USER_CERT);
                certAttr.addValue(certs[i].getEncoded());
                attrs.add(1, certAttr);
                LDAPAttribute certAttrS = new LDAPAttribute(LDAP_ATTR_USER_CERT_STRING);
                certAttrS.addValue(this.getCertificateString(certs[i]));
                attrs.add(1, certAttrS);
                ldapconn.modify(dn, attrs);
                ++certCount;
                SessionContext sessionContext = SessionContext.getContext();
                String adminId = (String)sessionContext.get((Object)"userid");
                logger.info("Admin UID: {} removed cert of User UID: {}. cert DN: {} serial number: 0x{}", new Object[]{adminId, userID, certs[0].getSubjectDN(), certs[i].getSerialNumber().toString(16)});
                continue;
            }
            catch (CertificateEncodingException e) {
                throw new EUsrGrpException(e.getMessage(), (Exception)e);
            }
            catch (LDAPException e) {
                throw LDAPExceptionConverter.toPKIException((LDAPException)e);
            }
            catch (ELdapException e) {
                throw new EUsrGrpException("Unable to remove user certificate: " + e.getMessage(), (Exception)((Object)e));
            }
            finally {
                if (ldapconn != null) {
                    this.returnConn(ldapconn);
                }
            }
        }
        if (certCount == 0) {
            throw new EUsrGrpException("User certificate not found");
        }
    }

    public void addUserToGroup(Group grp, String userid) throws EUsrGrpException {
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            String groupDN = "cn=" + LDAPUtil.escapeRDNValue((Object)grp.getGroupID()) + "," + this.getGroupBaseDN();
            LDAPAttribute memberAttr = new LDAPAttribute(MEMBER_ATTR, "uid=" + LDAPUtil.escapeRDNValue((Object)userid) + "," + this.getUserBaseDN());
            LDAPModification singleChange = new LDAPModification(0, memberAttr);
            ldapconn.modify(groupDN, singleChange);
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to add user to group: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    public void removeUserFromGroup(Group grp, String userid) throws EUsrGrpException {
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            String groupDN = "cn=" + LDAPUtil.escapeRDNValue((Object)grp.getGroupID()) + "," + this.getGroupBaseDN();
            LDAPAttribute memberAttr = new LDAPAttribute(MEMBER_ATTR, "uid=" + LDAPUtil.escapeRDNValue((Object)userid) + "," + this.getUserBaseDN());
            LDAPModification singleChange = new LDAPModification(1, memberAttr);
            ldapconn.modify(groupDN, singleChange);
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to remove user from group: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userid) throws EUsrGrpException {
        if (userid == null) {
            return;
        }
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            ldapconn.delete("uid=" + LDAPUtil.escapeRDNValue((Object)userid) + "," + this.getUserBaseDN());
            SessionContext sessionContext = SessionContext.getContext();
            String adminId = (String)sessionContext.get((Object)"userid");
            logger.info("Admin UID: {} removed User UID: {} ", (Object)adminId, (Object)userid);
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            logger.error("Unable to remove user: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    public void modifyUser(User identity) throws EUsrGrpException {
        User user = identity;
        String st = null;
        LDAPModificationSet attrs = new LDAPModificationSet();
        if (user == null) {
            return;
        }
        LDAPConnection ldapconn = null;
        try {
            List<String> profiles;
            block24: {
                LDAPModification singleChange;
                block23: {
                    ldapconn = this.getConn();
                    st = user.getFullName();
                    if (st != null) {
                        attrs.add(2, new LDAPAttribute("sn", st));
                        attrs.add(2, new LDAPAttribute("cn", st));
                    }
                    if ((st = user.getEmail()) != null) {
                        LDAPAttribute ld = new LDAPAttribute("mail", st);
                        attrs.add(2, ld);
                    }
                    if ((st = user.getPassword()) != null && !st.equals("")) {
                        attrs.add(2, new LDAPAttribute("userpassword", st));
                    }
                    if ((st = user.getPhone()) != null) {
                        if (!st.equals("")) {
                            attrs.add(2, new LDAPAttribute("telephonenumber", st));
                        } else {
                            try {
                                singleChange = new LDAPModification(1, new LDAPAttribute("telephonenumber"));
                                ldapconn.modify("uid=" + LDAPUtil.escapeRDNValue((Object)user.getUserID()) + "," + this.getUserBaseDN(), singleChange);
                            }
                            catch (LDAPException e) {
                                if (e.getLDAPResultCode() == 16) break block23;
                                logger.error("modifyUser: Error in deleting telephonenumber: " + e.getMessage(), (Throwable)e);
                                throw e;
                            }
                        }
                    }
                }
                if ((st = user.getState()) != null) {
                    if (!st.equals("")) {
                        attrs.add(2, new LDAPAttribute("userstate", st));
                    } else {
                        try {
                            singleChange = new LDAPModification(1, new LDAPAttribute("userstate"));
                            ldapconn.modify("uid=" + LDAPUtil.escapeRDNValue((Object)user.getUserID()) + "," + this.getUserBaseDN(), singleChange);
                        }
                        catch (LDAPException e) {
                            if (e.getLDAPResultCode() == 16) break block24;
                            logger.error("modifyUser: Error in deleting userstate: " + e.getMessage(), (Throwable)e);
                            throw e;
                        }
                    }
                }
            }
            if ((profiles = user.getTpsProfiles()) != null) {
                String[] oc = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson", "cmsuser", "tpsProfileID"};
                attrs.add(2, new LDAPAttribute(OBJECTCLASS_ATTR, oc));
                LDAPAttribute attr = new LDAPAttribute(LDAP_ATTR_PROFILE_ID);
                for (String profile : profiles) {
                    attr.addValue(profile);
                }
                attrs.add(2, attr);
            }
            ldapconn.modify("uid=" + LDAPUtil.escapeRDNValue((Object)user.getUserID()) + "," + this.getUserBaseDN(), attrs);
            SessionContext sessionContext = SessionContext.getContext();
            String adminId = (String)sessionContext.get((Object)"userid");
            logger.info("Admin UID: {} modified User UID: {}", (Object)adminId, (Object)user.getUserID());
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to modify user: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    protected Enumeration<Group> buildGroups(LDAPSearchResults res) throws EUsrGrpException {
        Vector<Group> v = new Vector<Group>();
        while (res.hasMoreElements()) {
            LDAPEntry entry = (LDAPEntry)res.nextElement();
            v.addElement(this.buildGroup(entry));
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<Group> findGroups(String filter) throws EUsrGrpException {
        if (filter == null) {
            return null;
        }
        String baseDN = this.getGroupBaseDN();
        logger.debug("UGSubsystem: Retrieving groups from " + baseDN);
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            LDAPSearchResults res = ldapconn.search(baseDN, 2, "(&(objectclass=groupofuniquenames)(cn=" + filter + "))", null, false);
            Enumeration<Group> enumeration = this.buildGroups(res);
            return enumeration;
        }
        catch (LDAPException e) {
            logger.error("Unable to find groups: " + e, (Throwable)e);
            Enumeration<Group> enumeration = null;
            return enumeration;
        }
        catch (ELdapException e) {
            logger.error("Unable to find groups: " + e, (Throwable)e);
            Enumeration<Group> enumeration = null;
            return enumeration;
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    public Group findGroup(String filter) throws EUsrGrpException {
        Enumeration<Group> groups = this.findGroups(filter);
        if (groups == null || !groups.hasMoreElements()) {
            return null;
        }
        return groups.nextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<Group> listGroups(String filter) throws EUsrGrpException {
        Object ldapFilter;
        if (filter == null) {
            ldapFilter = "(objectclass=groupofuniquenames)";
        } else {
            filter = LDAPUtil.escapeFilter((Object)filter);
            ldapFilter = "(&(objectclass=groupofuniquenames)(cn=*" + filter + "*))";
        }
        String[] attrs = new String[]{"cn", LDAP_ATTR_USER_CERT_STRING};
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            LDAPSearchResults res = ldapconn.search(this.getGroupBaseDN(), 1, (String)ldapFilter, attrs, false);
            Enumeration<Group> enumeration = this.buildGroups(res);
            return enumeration;
        }
        catch (LDAPException e) {
            logger.warn("Unable to list groups: " + e.getMessage(), (Throwable)e);
        }
        catch (ELdapException e) {
            logger.warn("Unable to list groups: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Enumeration<Group> findGroupsByUser(String userDn, String filter) throws EUsrGrpException {
        if (userDn == null) {
            return null;
        }
        String ldapFilter = "(&(objectclass=groupofuniquenames)(uniqueMember=" + LDAPUtil.escapeFilter((Object)userDn) + ")";
        if (!StringUtils.isEmpty((CharSequence)filter)) {
            filter = LDAPUtil.escapeFilter((Object)filter);
            ldapFilter = ldapFilter + "(cn=*" + filter + "*)";
        }
        ldapFilter = ldapFilter + ")";
        LDAPConnection ldapconn = null;
        try {
            String[] attrs = new String[]{"cn", LDAP_ATTR_USER_CERT_STRING};
            ldapconn = this.getConn();
            LDAPSearchResults res = ldapconn.search(this.getGroupBaseDN(), 1, ldapFilter, attrs, false);
            Enumeration<Group> enumeration = this.buildGroups(res);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
            return enumeration;
        }
        catch (LDAPException e) {
            logger.warn("Unable to find groups by user: " + e.getMessage(), (Throwable)e);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        catch (ELdapException e2) {
            logger.warn("Unable to find groups by user: " + e2.getMessage(), (Throwable)e2);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
            {
                catch (Throwable throwable) {
                    if (ldapconn != null) {
                        this.returnConn(ldapconn);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    protected Group buildGroup(LDAPEntry entry) throws EUsrGrpException {
        LDAPAttribute attr;
        String desc;
        Enumeration en;
        LDAPAttribute cn = entry.getAttribute("cn");
        if (cn == null) {
            throw new EUsrGrpException("Cannot build group. No Attribute cn in LDAP Entry " + entry.getDN());
        }
        String groupName = (String)cn.getStringValues().nextElement();
        Group grp = this.createGroup(groupName);
        LDAPAttribute grpDesc = entry.getAttribute(LDAP_ATTR_USER_CERT_STRING);
        if (grpDesc != null && (en = grpDesc.getStringValues()) != null && en.hasMoreElements() && (desc = (String)en.nextElement()) != null) {
            try {
                grp.set(LDAP_ATTR_USER_CERT_STRING, desc);
            }
            catch (EBaseException ex) {
                logger.warn("Unable to store group description: " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (grp.getDescription() == null) {
            try {
                grp.set(LDAP_ATTR_USER_CERT_STRING, "");
            }
            catch (EBaseException ex) {
                logger.warn("Unable to store group description: " + ex.getMessage(), (Throwable)ex);
            }
        }
        if ((attr = entry.getAttribute(MEMBER_ATTR)) == null) {
            return grp;
        }
        Enumeration e = attr.getStringValues();
        while (e.hasMoreElements()) {
            String v = (String)e.nextElement();
            int i = -1;
            int j = -1;
            if (v == null || v.length() < 3 || !v.substring(0, 3).equalsIgnoreCase("uid") || (i = v.indexOf(61)) < 0 || (j = v.indexOf(44)) < 0 || i > j || v.substring(i + 1, j).indexOf(61) > -1 || v.substring(3, i).trim().length() > 0) {
                logger.warn("Invalid group member: " + v);
                continue;
            }
            grp.addMemberName(v.substring(v.indexOf(61) + 1, v.indexOf(44)));
        }
        return grp;
    }

    public Group getGroupFromName(String name) {
        return this.getGroup("cn=" + LDAPUtil.escapeRDNValue((Object)name) + "," + this.getGroupBaseDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String groupDN) {
        if (groupDN == null) {
            return null;
        }
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            LDAPSearchResults res = ldapconn.search(groupDN, 0, "(objectclass=*)", null, false);
            Enumeration<Group> e = this.buildGroups(res);
            if (e == null || !e.hasMoreElements()) {
                Group group = null;
                return group;
            }
            Group group = e.nextElement();
            return group;
        }
        catch (Exception e) {
            logger.warn("Unable to get group: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGroupPresent(String name) {
        if (name == null) {
            return false;
        }
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            LDAPEntry entry = ldapconn.read(name);
            LDAPAttribute attr = entry.getAttribute(OBJECTCLASS_ATTR);
            if (attr == null) {
                boolean bl = false;
                return bl;
            }
            Enumeration en = attr.getStringValues();
            while (en.hasMoreElements()) {
                String v = (String)en.nextElement();
                if (!v.equalsIgnoreCase(GROUP_ATTR_VALUE)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.warn("Unable to get group: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        return false;
    }

    public boolean isMemberOf(String userid, String groupname) {
        try {
            User user = this.getUser(userid);
            if (user != null) {
                return this.isMemberOfLdapGroup(user.getUserDN(), groupname);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isMemberOf(User id, String name) {
        if (id == null) {
            logger.warn("UGSubsystem: isMemberOf(): id is null");
            return false;
        }
        if (name == null) {
            logger.warn("UGSubsystem: isMemberOf(): name is null");
            return false;
        }
        logger.trace("UGSubsystem.isMemberOf() using new lookup code");
        return this.isMemberOfLdapGroup(id.getUserDN(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean isMemberOfLdapGroup(String userid, String groupname) {
        String basedn = "cn=" + LDAPUtil.escapeRDNValue((Object)groupname) + ",ou=groups," + this.mBaseDN;
        LDAPConnection ldapconn = null;
        boolean founduser = false;
        try {
            String[] attrs = new String[]{"cn"};
            ldapconn = this.getConn();
            String filter = "(uniquemember=" + LDAPUtil.escapeFilter((Object)userid) + ")";
            logger.trace("authorization search base: " + basedn);
            logger.trace("authorization search filter: " + filter);
            LDAPSearchResults res = ldapconn.search(basedn, 0, filter, attrs, false);
            if (res.hasMoreElements()) {
                res.nextElement();
                founduser = true;
            }
            logger.trace("authorization result: " + founduser);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        catch (LDAPException e) {
            Object errMsg = "isMemberOfLdapGroup: could not find group " + groupname + ". Error " + e;
            if (e.getLDAPResultCode() == 52) {
                errMsg = "isMemberOfLdapGroup: Internal DB is unavailable";
            }
            logger.warn("UGSubsystem: authorization exception: " + (String)errMsg);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        catch (ELdapException e2) {
            String errMsg2 = "isMemberOfLdapGroup: Could not get connection to internaldb. Error " + e2;
            logger.warn("UGSubsystem: authorization exception: " + errMsg2);
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
            {
                catch (Throwable throwable) {
                    if (ldapconn != null) {
                        this.returnConn(ldapconn);
                    }
                    throw throwable;
                }
            }
        }
        return founduser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addGroup(Group group) throws EUsrGrpException {
        Group grp = group;
        if (grp == null) {
            return;
        }
        LDAPConnection ldapconn = null;
        try {
            Enumeration<String> e;
            String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)grp.getGroupID()) + "," + this.getGroupBaseDN();
            logger.info("UGSubsystem: Adding group " + dn);
            LDAPAttributeSet attrs = new LDAPAttributeSet();
            String[] oc = new String[]{"top", "groupOfUniqueNames"};
            logger.info("UGSubsystem: - objectclass: " + Arrays.asList(oc));
            attrs.add(new LDAPAttribute(OBJECTCLASS_ATTR, oc));
            logger.info("UGSubsystem: - cn: " + group.getGroupID());
            attrs.add(new LDAPAttribute("cn", group.getGroupID()));
            String description = group.getDescription();
            if (description != null) {
                logger.info("UGSubsystem: - description: " + description);
                attrs.add(new LDAPAttribute(LDAP_ATTR_USER_CERT_STRING, description));
            }
            if ((e = grp.getMemberNames()).hasMoreElements()) {
                LDAPAttribute attrMembers = new LDAPAttribute(MEMBER_ATTR);
                while (e.hasMoreElements()) {
                    String name = e.nextElement();
                    String memberDN = "uid=" + LDAPUtil.escapeRDNValue((Object)name) + "," + this.getUserBaseDN();
                    logger.info("UGSubsystem: - uniqueMember: " + memberDN);
                    attrMembers.addValue(memberDN);
                }
                attrs.add(attrMembers);
            }
            LDAPEntry entry = new LDAPEntry(dn, attrs);
            ldapconn = this.getConn();
            ldapconn.add(entry);
            if (ldapconn == null) return;
            this.returnConn(ldapconn);
            return;
        }
        catch (LDAPException e) {
            try {
                throw LDAPExceptionConverter.toPKIException((LDAPException)e);
                catch (ELdapException e2) {
                    throw new EUsrGrpException("Unable to add group: " + e2.getMessage(), (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                if (ldapconn == null) throw throwable;
                this.returnConn(ldapconn);
                throw throwable;
            }
        }
    }

    public void removeGroup(String name) throws EUsrGrpException {
        if (name == null) {
            return;
        }
        if (name.equalsIgnoreCase(SUPER_CERT_ADMINS)) {
            throw new EUsrGrpException("Unable to remove Administrators group");
        }
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            ldapconn.delete("cn=" + LDAPUtil.escapeRDNValue((Object)name) + "," + this.getGroupBaseDN());
        }
        catch (LDAPException e) {
            throw LDAPExceptionConverter.toPKIException((LDAPException)e);
        }
        catch (ELdapException e) {
            throw new EUsrGrpException("Unable to remove group: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyGroup(Group group) throws EUsrGrpException {
        Group grp = group;
        if (grp == null) {
            return;
        }
        LDAPConnection ldapconn = null;
        try {
            String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)grp.getGroupID()) + "," + this.getGroupBaseDN();
            logger.debug("dn: " + dn);
            LDAPModificationSet mod = new LDAPModificationSet();
            String description = grp.getDescription();
            mod.add(2, new LDAPAttribute(LDAP_ATTR_USER_CERT_STRING, description));
            logger.debug("description: " + description);
            Enumeration<String> e = grp.getMemberNames();
            if (grp.getName().equalsIgnoreCase(SUPER_CERT_ADMINS) && !e.hasMoreElements()) {
                throw new EUsrGrpException("Unable to remove the last member of Administrators group");
            }
            LDAPAttribute attrMembers = new LDAPAttribute(MEMBER_ATTR);
            while (true) {
                if (!e.hasMoreElements()) {
                    mod.add(2, attrMembers);
                    ldapconn = this.getConn();
                    ldapconn.modify(dn, mod);
                    if (ldapconn == null) return;
                    this.returnConn(ldapconn);
                    return;
                }
                String name = e.nextElement();
                String memberDN = "uid=" + LDAPUtil.escapeRDNValue((Object)name) + "," + this.getUserBaseDN();
                logger.debug("uniqueMember: " + memberDN);
                attrMembers.addValue(memberDN);
            }
        }
        catch (LDAPException e) {
            try {
                throw LDAPExceptionConverter.toPKIException((LDAPException)e);
                catch (ELdapException e2) {
                    throw new EUsrGrpException("Unable to modify group: " + e2.getMessage(), (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                if (ldapconn == null) throw throwable;
                this.returnConn(ldapconn);
                throw throwable;
            }
        }
    }

    public boolean evaluate(String type, User id, String op, String value) {
        if (op.equals("=")) {
            if (type.equalsIgnoreCase("user") && this.isMatched(value, id.getUserID())) {
                return true;
            }
            if (type.equalsIgnoreCase("group")) {
                return this.isMemberOf(id, value);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertUIDtoDN(String uid) throws LDAPException {
        String u = uid;
        if (u == null) {
            return null;
        }
        LDAPConnection ldapconn = null;
        try {
            ldapconn = this.getConn();
            LDAPSearchResults res = ldapconn.search(this.getUserBaseDN(), 2, "(uid=" + LDAPUtil.escapeFilter((Object)u) + ")", null, false);
            if (res.hasMoreElements()) {
                LDAPEntry entry = (LDAPEntry)res.nextElement();
                String string = entry.getDN();
                return string;
            }
        }
        catch (ELdapException e) {
            logger.warn("Unable to convert UID to DN: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (ldapconn != null) {
                this.returnConn(ldapconn);
            }
        }
        return null;
    }

    protected boolean isMatched(String dn1, String dn2) {
        String[] rdn1 = LDAPDN.explodeDN((String)dn1, (boolean)false);
        String[] rdn2 = LDAPDN.explodeDN((String)dn2, (boolean)false);
        if (rdn1 == null && rdn2 == null) {
            return true;
        }
        if (rdn1 == null || rdn2 == null) {
            return false;
        }
        if (rdn1.length == rdn2.length) {
            for (int j = 0; j < rdn1.length; ++j) {
                if (rdn1[j].equalsIgnoreCase(rdn2[j])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected String getCertificateStringWithoutVersion(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return "-1;" + cert.getSerialNumber().toString() + ";" + cert.getIssuerDN() + ";" + cert.getSubjectDN();
    }

    public String getCertificateString(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return cert.getVersion() + ";" + cert.getSerialNumber().toString() + ";" + cert.getIssuerDN() + ";" + cert.getSubjectDN();
    }

    private String getUserBaseDN() {
        return "ou=People," + this.mBaseDN;
    }

    public String getUserDN(String userID) {
        return "uid=" + LDAPUtil.escapeRDNValue((Object)userID) + "," + this.getUserBaseDN();
    }

    private String getGroupBaseDN() {
        return "ou=Groups," + this.mBaseDN;
    }

    protected LDAPConnection getConn() throws ELdapException {
        if (this.mLdapConnFactory != null) {
            LDAPConnection conn = this.mLdapConnFactory.getConn();
            if (conn == null) {
                throw new ELdapException("No Ldap Connection Available");
            }
            return conn;
        }
        throw new ELdapException("Ldap Connection Factory is Unavailable");
    }

    protected void returnConn(LDAPConnection conn) {
        if (this.mLdapConnFactory != null) {
            this.mLdapConnFactory.returnConn(conn);
        }
    }
}

